/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.serenegiant.uvccamera.R;

public class ViewAnimationHelper {
    private static final String TAG = ViewAnimationHelper.class.getSimpleName();
    private static final long DEFAULT_DURATION_MS = 500L;
    public static final int ANIMATION_UNKNOWN = -1;
    public static final int ANIMATION_FADE_OUT = 0;
    public static final int ANIMATION_FADE_IN = 1;
    public static final int ANIMATION_ZOOM_IN = 2;
    public static final int ANIMATION_ZOOM_OUT = 3;
    private static final Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            ViewAnimationHelper.onAnimation(animator, 0);
        }

        public void onAnimationEnd(Animator animator) {
            ViewAnimationHelper.onAnimation(animator, 1);
        }

        public void onAnimationCancel(Animator animator) {
            ViewAnimationHelper.onAnimation(animator, 2);
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    @SuppressLint(value={"NewApi"})
    public static void fadeIn(final View target, final long duration, final long startDelay, final ViewAnimationListener listener) {
        if (target == null) {
            return;
        }
        target.postDelayed(new Runnable(){

            @Override
            public void run() {
                target.setVisibility(0);
                target.setTag(R.id.anim_type, (Object)1);
                target.setTag(R.id.anim_listener, (Object)listener);
                target.setScaleX(1.0f);
                target.setScaleY(1.0f);
                target.setAlpha(0.0f);
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
                objectAnimator.addListener(mAnimatorListener);
                if (Build.VERSION.SDK_INT >= 18) {
                    objectAnimator.setAutoCancel(true);
                }
                objectAnimator.setDuration(duration > 0L ? duration : 500L);
                objectAnimator.setStartDelay(startDelay > 0L ? startDelay : 0L);
                objectAnimator.start();
            }
        }, 100L);
    }

    @SuppressLint(value={"NewApi"})
    public static void fadeOut(final View target, final long duration, final long startDelay, final ViewAnimationListener listener) {
        if (target != null && target.getVisibility() == 0) {
            target.postDelayed(new Runnable(){

                @Override
                public void run() {
                    target.setTag(R.id.anim_type, (Object)0);
                    target.setTag(R.id.anim_listener, (Object)listener);
                    target.setScaleX(1.0f);
                    target.setScaleY(1.0f);
                    target.setAlpha(1.0f);
                    ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
                    objectAnimator.addListener(mAnimatorListener);
                    if (Build.VERSION.SDK_INT >= 18) {
                        objectAnimator.setAutoCancel(true);
                    }
                    objectAnimator.setDuration(duration > 0L ? duration : 500L);
                    objectAnimator.setStartDelay(startDelay > 0L ? startDelay : 0L);
                    objectAnimator.start();
                }
            }, 100L);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void zoomIn(final View target, final long duration, final long startDelay, final ViewAnimationListener listener) {
        if (target == null) {
            return;
        }
        target.postDelayed(new Runnable(){

            @Override
            public void run() {
                target.setVisibility(0);
                target.setTag(R.id.anim_type, (Object)2);
                target.setTag(R.id.anim_listener, (Object)listener);
                target.setScaleX(0.0f);
                target.setScaleY(0.0f);
                target.setAlpha(1.0f);
                PropertyValuesHolder scale_x = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.01f, 1.0f});
                PropertyValuesHolder scale_y = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.01f, 1.0f});
                ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{scale_x, scale_y});
                objectAnimator.addListener(mAnimatorListener);
                if (Build.VERSION.SDK_INT >= 18) {
                    objectAnimator.setAutoCancel(true);
                }
                objectAnimator.setDuration(duration > 0L ? duration : 500L);
                objectAnimator.setStartDelay(startDelay > 0L ? startDelay : 0L);
                objectAnimator.start();
            }
        }, 100L);
    }

    @SuppressLint(value={"NewApi"})
    public static void zoomOut(final View target, final long duration, final long startDelay, final ViewAnimationListener listener) {
        if (target == null) {
            return;
        }
        target.postDelayed(new Runnable(){

            @Override
            public void run() {
                target.setVisibility(0);
                target.setTag(R.id.anim_type, (Object)3);
                target.setTag(R.id.anim_listener, (Object)listener);
                target.setScaleX(1.0f);
                target.setScaleY(1.0f);
                target.setAlpha(1.0f);
                PropertyValuesHolder scale_x = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.0f});
                PropertyValuesHolder scale_y = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.0f});
                ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{scale_x, scale_y});
                objectAnimator.addListener(mAnimatorListener);
                if (Build.VERSION.SDK_INT >= 18) {
                    objectAnimator.setAutoCancel(true);
                }
                objectAnimator.setDuration(duration > 0L ? duration : 500L);
                objectAnimator.setStartDelay(startDelay > 0L ? startDelay : 0L);
                objectAnimator.start();
            }
        }, 100L);
    }

    private static void onAnimation(Animator animator, final int event) {
        if (animator instanceof ObjectAnimator) {
            int animType;
            final ObjectAnimator anim = (ObjectAnimator)animator;
            final View target = (View)anim.getTarget();
            if (target == null) {
                return;
            }
            final ViewAnimationListener listener = (ViewAnimationListener)target.getTag(R.id.anim_listener);
            try {
                animType = (Integer)target.getTag(R.id.anim_type);
            }
            catch (Exception e) {
                return;
            }
            if (listener != null) {
                target.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            switch (event) {
                                case 0: {
                                    listener.onAnimationStart((Animator)anim, target, animType);
                                    break;
                                }
                                case 1: {
                                    listener.onAnimationEnd((Animator)anim, target, animType);
                                    break;
                                }
                                case 2: {
                                    listener.onAnimationCancel((Animator)anim, target, animType);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                }, 100L);
            }
        }
    }

    public static interface ViewAnimationListener {
        public void onAnimationStart(@NonNull Animator var1, @NonNull View var2, int var3);

        public void onAnimationEnd(@NonNull Animator var1, @NonNull View var2, int var3);

        public void onAnimationCancel(@NonNull Animator var1, @NonNull View var2, int var3);
    }
}

