/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.Image;
import android.media.ImageReader;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.herohan.uvcapp.ICameraInternal;
import com.herohan.uvcapp.IImageCapture;
import com.herohan.uvcapp.ImageCapture;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.ImageSaver2;
import com.serenegiant.usb.Size;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.utils.UriHelper;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageCapture2
implements IImageCapture {
    private static final String TAG = ImageCapture.class.getSimpleName();
    private WeakReference<ICameraInternal> mCameraInternalWeak;
    private ImageCaptureConfig mConfig;
    private Size mResolution;
    private Handler mMainHandler;
    private ExecutorService mExecutor;
    private ImageReader mImageReader;

    ImageCapture2(ICameraInternal cameraInternal, ImageCaptureConfig config, Size resolution) {
        this.mCameraInternalWeak = new WeakReference<ICameraInternal>(cameraInternal);
        this.mConfig = (ImageCaptureConfig)config.clone();
        this.mResolution = resolution;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){
            private final AtomicInteger mId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, TAG + "image_capture" + this.mId.getAndIncrement());
            }
        });
        this.initImageReader();
    }

    @SuppressLint(value={"WrongConstant"})
    private void initImageReader() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mResolution != null) {
            this.mImageReader = ImageReader.newInstance((int)this.mResolution.width, (int)this.mResolution.height, (int)1, (int)1);
        }
    }

    @Override
    public void setConfig(ImageCaptureConfig config) {
        this.mConfig = (ImageCaptureConfig)config.clone();
    }

    void setResolution(Size resolution) {
        this.mResolution = resolution;
        this.initImageReader();
    }

    @IntRange(from=1L, to=100L)
    int getJpegQualityInternal() {
        if (this.mConfig.hasJpegCompressionQuality()) {
            return this.mConfig.getJpegCompressionQuality();
        }
        switch (this.mConfig.getCaptureMode()) {
            case 0: {
                return 100;
            }
            case 1: {
                return 95;
            }
        }
        throw new IllegalStateException("CaptureMode " + this.mConfig.getCaptureMode() + " is invalid");
    }

    void clearImageReader() {
        if (this.mImageReader != null) {
            this.mImageReader.setOnImageAvailableListener(null, null);
            ICameraInternal cameraInternal = (ICameraInternal)this.mCameraInternalWeak.get();
            if (cameraInternal != null) {
                cameraInternal.removeSurface(this.mImageReader.getSurface());
            }
        }
    }

    @Override
    public void takePicture(@NonNull IImageCapture.OutputFileOptions outputFileOptions, final @NonNull IImageCapture.OnImageCaptureCallback imageSavedCallback) {
        ImageSaver2.OnImageSavedCallback imageSavedCallbackWrapper = new ImageSaver2.OnImageSavedCallback(){

            @Override
            public void onImageSaved(@NonNull IImageCapture.OutputFileResults outputFileResults) {
                ImageCapture2.this.scanMediaFile(outputFileResults.getSavedUri());
                ImageCapture2.this.mMainHandler.post(() -> imageSavedCallback.onImageSaved(outputFileResults));
            }

            @Override
            public void onError(@NonNull ImageSaver2.SaveError error, @NonNull String message, @Nullable Throwable cause) {
                ImageCapture2.this.mMainHandler.post(() -> {
                    int imageCaptureError = 0;
                    switch (error) {
                        case FILE_IO_FAILED: {
                            imageCaptureError = 1;
                            break;
                        }
                    }
                    imageSavedCallback.onError(imageCaptureError, message, cause);
                });
            }
        };
        ICameraInternal cameraInternal = (ICameraInternal)this.mCameraInternalWeak.get();
        if (cameraInternal == null) {
            imageSavedCallback.onError(4, "Not bound to a Camera", null);
        } else if (this.mImageReader == null) {
            imageSavedCallback.onError(0, "ImageReader is null", null);
        } else {
            int outputJpegQuality = this.getJpegQualityInternal();
            int width = this.mResolution.width;
            int height = this.mResolution.height;
            cameraInternal.addSurface(this.mImageReader.getSurface(), false);
            this.mImageReader.setOnImageAvailableListener(reader -> {
                Image image = null;
                try {
                    Image.Plane[] planes;
                    image = this.mImageReader.acquireLatestImage();
                    if (image != null && (planes = image.getPlanes()).length > 0) {
                        Image.Plane plane = planes[0];
                        ByteBuffer buffer = plane.getBuffer();
                        int pixelStride = plane.getPixelStride();
                        int rowStride = plane.getRowStride();
                        int rowPadding = rowStride - pixelStride * width;
                        Bitmap bmp = Bitmap.createBitmap((int)(width + rowPadding / pixelStride), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        bmp.copyPixelsFromBuffer((Buffer)buffer);
                        this.mExecutor.execute(new ImageSaver2(bmp, width, height, outputJpegQuality, outputFileOptions, imageSavedCallbackWrapper));
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = "captureImage failed with an unknown exception";
                    }
                    imageSavedCallback.onError(0, message, e);
                }
                finally {
                    if (image != null) {
                        image.close();
                    }
                    this.clearImageReader();
                    this.initImageReader();
                }
            }, null);
        }
    }

    private void scanMediaFile(Uri uri) {
        if (uri == null) {
            return;
        }
        Application context = UVCUtils.getApplication();
        String path = UriHelper.getPath((Context)context, uri);
        try {
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{path}, null, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"MediaScannerConnection:", (Throwable)e);
        }
    }

    @Override
    public void release() {
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
            this.mExecutor = null;
        }
    }
}

