/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine;

import android.util.Log;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.ResourceDecoder;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.cache.DiskCache;
import java.io.File;
import java.io.IOException;

class CacheLoader {
    private static final String TAG = "CacheLoader";
    private final DiskCache diskCache;

    public CacheLoader(DiskCache diskCache) {
        this.diskCache = diskCache;
    }

    public <Z> Resource<Z> load(Key key, ResourceDecoder<File, Z> resourceDecoder, int n2, int n3) {
        Resource<Z> resource;
        block5: {
            File file = this.diskCache.get(key);
            if (file == null) {
                return null;
            }
            resource = null;
            try {
                resource = resourceDecoder.decode(file, n2, n3);
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block5;
                Log.d((String)TAG, (String)"Exception decoding image from cache", (Throwable)iOException);
            }
        }
        if (resource == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to decode image from cache or not present in cache");
            }
            this.diskCache.delete(key);
        }
        return resource;
    }
}

