/*
 * Decompiled with CFR 0.152.
 */
package com.example.serialport;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.MultiWindowSupport;
import com.unity3d.player.UnityPlayer;

public class UnityPlayerActivity
extends Activity
implements IUnityPlayerLifecycleEvents {
    protected UnityPlayer mUnityPlayer;

    protected String updateUnityCommandLineArguments(String cmdLine) {
        return cmdLine;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        String cmdLine = this.updateUnityCommandLineArguments(this.getIntent().getStringExtra("unity"));
        this.getIntent().putExtra("unity", cmdLine);
        this.mUnityPlayer = new UnityPlayer((Context)this, (IUnityPlayerLifecycleEvents)this);
        this.setContentView((View)this.mUnityPlayer);
        this.mUnityPlayer.requestFocus();
    }

    public void onUnityPlayerUnloaded() {
        this.moveTaskToBack(true);
    }

    public void onUnityPlayerQuitted() {
    }

    protected void onNewIntent(Intent intent) {
        this.setIntent(intent);
        this.mUnityPlayer.newIntent(intent);
    }

    protected void onDestroy() {
        this.mUnityPlayer.destroy();
        super.onDestroy();
    }

    protected void onStop() {
        super.onStop();
        if (!MultiWindowSupport.getAllowResizableWindow((Activity)this)) {
            return;
        }
        this.mUnityPlayer.pause();
    }

    protected void onStart() {
        super.onStart();
        if (!MultiWindowSupport.getAllowResizableWindow((Activity)this)) {
            return;
        }
        this.mUnityPlayer.resume();
    }

    protected void onPause() {
        super.onPause();
        MultiWindowSupport.saveMultiWindowMode((Activity)this);
        if (MultiWindowSupport.getAllowResizableWindow((Activity)this)) {
            return;
        }
        this.mUnityPlayer.pause();
    }

    protected void onResume() {
        super.onResume();
        if (MultiWindowSupport.getAllowResizableWindow((Activity)this) && !MultiWindowSupport.isMultiWindowModeChangedToTrue((Activity)this)) {
            return;
        }
        this.mUnityPlayer.resume();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mUnityPlayer.lowMemory();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (level == 15) {
            this.mUnityPlayer.lowMemory();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mUnityPlayer.configurationChanged(newConfig);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mUnityPlayer.windowFocusChanged(hasFocus);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 2) {
            return this.mUnityPlayer.injectEvent((InputEvent)event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mUnityPlayer.injectEvent((InputEvent)event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.mUnityPlayer.injectEvent((InputEvent)event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mUnityPlayer.injectEvent((InputEvent)event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return this.mUnityPlayer.injectEvent((InputEvent)event);
    }
}

