/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.browser;

import android.text.TextUtils;
import com.hpplay.sdk.source.bean.BrowserTypeBean;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import java.util.concurrent.ConcurrentHashMap;

public class BrowserHistory {
    private static final String TAG = "BrowserHistory";
    private static BrowserHistory sInstance;
    private long mLocalBrowserTimeStamp = -1L;
    private long mSonicBrowserTimeStamp = -1L;
    private long mBLEBrowserTimeStamp = -1L;
    private boolean isUseMdns = false;
    private boolean isUseUPnP = false;
    private boolean isUseQR = false;
    private boolean isUsePinCode = false;
    private boolean isUseBLE = false;
    private boolean isUseSonic = false;
    private ConcurrentHashMap<String, BrowserTypeBean> mBrowserMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BrowserHistory getInstance() {
        Class<BrowserHistory> clazz = BrowserHistory.class;
        synchronized (BrowserHistory.class) {
            if (sInstance == null) {
                sInstance = new BrowserHistory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void startLocalBrowser(int n2) {
        if (n2 == 1) {
            this.isUseMdns = true;
        } else if (n2 == 2) {
            this.isUseUPnP = true;
        } else {
            this.isUseMdns = true;
            this.isUseUPnP = true;
        }
        this.mLocalBrowserTimeStamp = System.currentTimeMillis();
    }

    public void startSonicBrowser() {
        this.isUseSonic = true;
        this.mSonicBrowserTimeStamp = System.currentTimeMillis();
    }

    public void startBLEBrowser() {
        this.isUseBLE = true;
        this.mBLEBrowserTimeStamp = System.currentTimeMillis();
    }

    public void startQRBrowser() {
        this.isUseQR = true;
    }

    public void startPinCodeBrowser() {
        this.isUsePinCode = true;
    }

    public BrowserTypeBean getBrowserTypeBean(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.mBrowserMap.get(string);
    }

    public void updateBrowserInfo(BrowserInfo browserInfo, int n2, long l2) {
        if (browserInfo == null || TextUtils.isEmpty((CharSequence)browserInfo.getName())) {
            return;
        }
        BrowserTypeBean browserTypeBean = this.mBrowserMap.get(browserInfo.getName());
        if (browserTypeBean == null) {
            browserTypeBean = new BrowserTypeBean();
            this.setBrowserType(browserTypeBean, browserInfo, n2, l2);
            this.mBrowserMap.put(browserInfo.getName(), browserTypeBean);
            return;
        }
        this.setBrowserType(browserTypeBean, browserInfo, n2, l2);
    }

    private void setBrowserType(BrowserTypeBean browserTypeBean, BrowserInfo browserInfo, int n2, long l2) {
        if (browserTypeBean == null || browserInfo == null) {
            return;
        }
        switch (n2) {
            case 1: {
                if (browserInfo.getType() == 1) {
                    browserTypeBean.isMDns = true;
                    if (browserTypeBean.mDnsTime >= 0L) break;
                    browserTypeBean.mDnsTime = System.currentTimeMillis() - this.mLocalBrowserTimeStamp;
                    break;
                }
                if (browserInfo.getType() != 3) break;
                browserTypeBean.isUPnP = true;
                if (browserTypeBean.UPnPTime >= 0L) break;
                browserTypeBean.UPnPTime = System.currentTimeMillis() - this.mLocalBrowserTimeStamp;
                break;
            }
            case 2: {
                browserTypeBean.isQRCode = true;
                browserTypeBean.qrCodeCloudTime = l2;
                break;
            }
            case 5: {
                browserTypeBean.isPinCode = true;
                browserTypeBean.pinCodeCloudTime = l2;
                break;
            }
            case 9: {
                browserTypeBean.isSonic = true;
                if (browserTypeBean.sonicTime >= 0L) break;
                browserTypeBean.sonicTime = System.currentTimeMillis() - this.mSonicBrowserTimeStamp;
                browserTypeBean.sonicCloudTime = l2;
                break;
            }
            case 10: {
                browserTypeBean.isBle = true;
                if (browserTypeBean.bleTime >= 0L) break;
                browserTypeBean.bleTime = System.currentTimeMillis() - this.mBLEBrowserTimeStamp;
                browserTypeBean.bleCloudTime = l2;
                break;
            }
        }
    }

    public boolean isUseMdns() {
        return this.isUseMdns;
    }

    public boolean isUseUPnP() {
        return this.isUseUPnP;
    }

    public boolean isUseQR() {
        return this.isUseQR;
    }

    public boolean isUseSonic() {
        return this.isUseSonic;
    }

    public boolean isUsePinCode() {
        return this.isUsePinCode;
    }

    public boolean isUseBLE() {
        return this.isUseBLE;
    }

    public void clearHistory() {
        this.mBrowserMap.clear();
        this.isUseMdns = false;
        this.isUseUPnP = false;
        this.isUseQR = false;
        this.isUsePinCode = false;
        this.isUseSonic = false;
        this.isUseBLE = false;
    }
}

