/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.ssdp.HTTPMUSocket;
import com.hpplay.cybergarage.upnp.ssdp.SSDP;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import java.io.IOException;

public class SSDPNotifySocket
extends HTTPMUSocket
implements Runnable {
    private static final String TAG = "hpplay-SSDPNotifySocket";
    private boolean useIPv6Address;
    private boolean isRuning;
    private ControlPoint controlPoint = null;
    private Thread deviceNotifyThread = null;

    public SSDPNotifySocket(String string) {
        String string2 = "239.255.255.250";
        this.useIPv6Address = false;
        if (HostInterface.isIPv6Address(string)) {
            string2 = SSDP.getIPv6Address();
            this.useIPv6Address = true;
        }
        this.open(string2, 1900, string);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public boolean post(SSDPNotifyRequest sSDPNotifyRequest) {
        String string = "239.255.255.250";
        if (this.useIPv6Address) {
            string = SSDP.getIPv6Address();
        }
        sSDPNotifyRequest.setHost(string, 1900);
        return this.post((HTTPRequest)sSDPNotifyRequest);
    }

    @Override
    public void run() {
        try {
            Thread thread = Thread.currentThread();
            ControlPoint controlPoint = this.getControlPoint();
            while (this.deviceNotifyThread == thread) {
                Thread.yield();
                this.isRuning = true;
                SSDPPacket sSDPPacket = null;
                try {
                    sSDPPacket = this.receive();
                }
                catch (IOException iOException) {
                    break;
                }
                if (sSDPPacket == null) continue;
                try {
                    if (controlPoint == null) continue;
                    controlPoint.notifyReceived(sSDPPacket);
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        this.isRuning = false;
    }

    public void start() {
        StringBuffer stringBuffer = new StringBuffer("hpplay.SSDPNotifySocket/");
        String string = this.getLocalAddress();
        if (string != null && 0 < string.length()) {
            stringBuffer.append(this.getLocalAddress()).append(':');
            stringBuffer.append(this.getLocalPort()).append(" -> ");
            stringBuffer.append(this.getMulticastAddress()).append(':');
            stringBuffer.append(this.getMulticastPort());
        }
        this.deviceNotifyThread = new Thread((Runnable)this, stringBuffer.toString());
        this.deviceNotifyThread.start();
    }

    public boolean isRuning() {
        return this.isRuning;
    }

    public void stop() {
        CLog.i(TAG, " notify stop ...");
        this.isRuning = false;
        this.close();
        this.deviceNotifyThread = null;
    }
}

