/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.asyncmanager;

import com.hpplay.common.log.LeLog;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

public class FileRequest {
    private final String TAG = "FileRequest";
    public static final int TASKDONWLOADING = 0;
    public static final int TASKDONWLOADED = 1;
    public static final int TASKDOWNLOADERROR = 2;
    public static final int TASKDOWNLOADCANCEL = 3;
    private long mDownloadedSize = 0L;
    private long mTotalSize;
    private int mDownloadPercent;
    private String mLocalPath;
    private String mURL;
    private int mTaskCode = 0;
    private DownloadListener mDownloadListener;
    private boolean isShutDown = false;
    private final String cacheName = ".cache";

    public FileRequest(String string, String string2) {
        this.mLocalPath = string2;
        this.mURL = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean download() {
        File file = new File(this.mLocalPath + ".cache");
        if (file.exists()) {
            file.delete();
            this.mDownloadedSize = 0L;
        } else {
            this.mDownloadedSize = 0L;
        }
        File file2 = new File(this.mLocalPath);
        if (file2.exists()) {
            file2.delete();
        }
        LeLog.i("FileRequest", "mURL, " + this.mURL + " downloadedSize, " + this.mDownloadedSize);
        HttpURLConnection httpURLConnection = null;
        URL uRL = null;
        try {
            uRL = new URL(this.mURL);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            this.mTotalSize = httpURLConnection.getContentLength();
            LeLog.i("FileRequest", "totalSize, " + this.mTotalSize);
            if (this.mTotalSize == 0L) {
                this.makeDownLoadError();
                boolean bl = false;
                return bl;
            }
            if (this.mDownloadedSize == this.mTotalSize) {
                boolean bl = true;
                return bl;
            }
            if (this.mDownloadedSize > this.mTotalSize && !file.delete()) {
                this.makeDownLoadError();
                boolean bl = false;
                return bl;
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            LeLog.w("FileRequest", exception);
            this.makeDownLoadError();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception) {
                LeLog.w("FileRequest", exception);
            }
        }
        InputStream inputStream = null;
        RandomAccessFile randomAccessFile = null;
        boolean bl = false;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            httpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
            httpURLConnection.setRequestProperty("Referer", this.mURL);
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Range", "bytes=" + this.mDownloadedSize + "-");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setConnectTimeout(30000);
            inputStream = httpURLConnection.getInputStream();
            File file3 = new File(this.mLocalPath + ".cache");
            randomAccessFile = new RandomAccessFile(file3, "rwd");
            randomAccessFile.seek(this.mDownloadedSize);
            int n2 = 0;
            int n3 = 0;
            int n4 = (int)this.mTotalSize / 1024 / 100;
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray, 0, 1024)) != -1 && !this.isShutDown) {
                randomAccessFile.write(byArray, 0, n2);
                if (++n3 == n4 && this.mDownloadedSize < this.mTotalSize) {
                    this.mDownloadPercent = (int)(this.mDownloadedSize * 100L / this.mTotalSize);
                    n3 = 0;
                    if (this.mDownloadListener != null) {
                        this.mDownloadListener.onDownLoad(this.mTaskCode, this.mDownloadedSize, this.mTotalSize, 0);
                    }
                }
                this.mDownloadedSize += (long)n2;
            }
            bl = true;
            if (this.isShutDown) {
                if (this.mDownloadListener != null) {
                    this.mDownloadListener.onDownLoad(this.mTaskCode, this.mTotalSize, this.mTotalSize, 3);
                }
                bl = false;
            } else {
                if (this.mDownloadedSize >= this.mTotalSize && this.mDownloadedSize > 0L && this.mTotalSize > 0L) {
                    this.renameToNewFile(this.mLocalPath + ".cache", this.mLocalPath);
                }
                if (this.mDownloadListener != null) {
                    this.mDownloadListener.onDownLoad(this.mTaskCode, this.mTotalSize, this.mTotalSize, 1);
                }
            }
        }
        catch (Exception exception) {
            LeLog.w("FileRequest", exception);
            LeLog.i("FileRequest", exception.toString());
            this.makeDownLoadError();
            bl = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w("FileRequest", exception);
                }
            }
            if (httpURLConnection != null) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    LeLog.w("FileRequest", exception);
                }
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    LeLog.w("FileRequest", exception);
                }
            }
        }
        return bl;
    }

    private boolean renameToNewFile(String string, String string2) {
        File file = new File(string);
        boolean bl = file.renameTo(new File(string2));
        return bl;
    }

    public void makeDownLoadError() {
        if (this.mDownloadListener != null) {
            this.mDownloadListener.onDownLoad(this.mTaskCode, this.mDownloadedSize, this.mTotalSize, 2);
        }
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
    }

    public void setTaskCode(int n2) {
        this.mTaskCode = n2;
    }

    public void shutDown() {
        this.isShutDown = true;
    }

    public static interface DownloadListener {
        public void onDownLoad(int var1, long var2, long var4, int var6);
    }
}

