/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.utils;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

public class ExecutionTimer {
    private static ExecutionTimer timer = new ExecutionTimer();
    private final Stack stack = new Stack();

    public long start() {
        return this.stack.push(new Long(System.nanoTime()));
    }

    public double took(TimeUnit timeUnit) {
        try {
            long l2 = (Long)this.stack.pop();
            long l3 = System.nanoTime() - l2;
            switch (timeUnit) {
                case DAYS: {
                    return (double)l3 / 8.64E13;
                }
                case HOURS: {
                    return (double)l3 / 3.6E12;
                }
                case MICROSECONDS: {
                    return (double)l3 / 1000.0;
                }
                case MILLISECONDS: {
                    return (double)l3 / 1000000.0;
                }
                case MINUTES: {
                    return (double)l3 / 6.0E10;
                }
                case NANOSECONDS: {
                    return l3;
                }
                case SECONDS: {
                    return (double)l3 / 1.0E9;
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return 0.0;
    }

    public static long _start() {
        return timer.start();
    }

    public static double _took(TimeUnit timeUnit) {
        return timer.took(timeUnit);
    }
}

