/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.companion.AssociationRequest;
import android.companion.BluetoothDeviceFilter;
import android.companion.BluetoothLeDeviceFilter;
import android.companion.CompanionDeviceManager;
import android.companion.DeviceFilter;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.util.Log;
import com.tony.bluetoothunityapi.BLEBluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.ble.BluetoothHelperService;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class EmptyActivity
extends Activity {
    private final int CDM_FILTER_FLAG_DEVICE_NAME = 1;
    private final int CDM_FILTER_FLAG_DEVICE_ADDRESS = 2;
    private final int CDM_FILTER_FLAG_SERVICE_UUID = 4;
    private final int SELECT_DEVICE_REQUEST_CODE = 6862;
    private EmptyActivityEvent listener;
    private BluetoothHelper helper;
    private BluetoothDevice device;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int helperId = this.getIntent().getIntExtra("BluetoothAPI", 0);
        if (helperId != 0) {
            this.helper = BluetoothHelper.GetInstanceById(helperId);
            this.listener = this.helper;
        }
        Log.d((String)"BluetoothAPI", (String)"Activity Created");
    }

    protected void onStart() {
        super.onStart();
        if (Build.VERSION.SDK_INT >= 26 && this.listener != null) {
            AssociationRequest.Builder builder = new AssociationRequest.Builder().setSingleDevice(false);
            int flags = this.helper.getCdmDeviceFilterFlags();
            if ((flags & 1) != 0) {
                this.addDeviceNameFilter(builder);
            }
            if ((flags & 2) != 0) {
                this.addDeviceAddressFilter(builder);
            }
            if ((flags & 4) != 0) {
                this.addServiceUuidFilter(builder);
            }
            AssociationRequest scanningRequest = builder.build();
            CompanionDeviceManager deviceManager = (CompanionDeviceManager)this.getSystemService("companiondevice");
            Log.d((String)"BluetoothAPI", (String)"Starting scan");
            deviceManager.associate(scanningRequest, new CompanionDeviceManager.Callback(){

                public void onDeviceFound(IntentSender intentSender) {
                    try {
                        Log.d((String)"BluetoothAPI", (String)"Found something");
                        EmptyActivity.this.startIntentSenderForResult(intentSender, 6862, null, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e((String)"BluetoothAPI", (String)"Error", (Throwable)e);
                    }
                }

                public void onFailure(CharSequence charSequence) {
                    Log.d((String)"BluetoothAPI", (String)"Failure");
                    EmptyActivity.this.listener.OnDeviceChosen(null);
                }
            }, null);
        } else {
            this.finish();
        }
    }

    private void addServiceUuidFilter(AssociationRequest.Builder builder) {
        if (!this.helper.isBLE() || Build.VERSION.SDK_INT < 26) {
            return;
        }
        LinkedList<BluetoothHelperService> list = ((BLEBluetoothHelper)this.helper).getServices();
        if (list == null || list.size() == 0) {
            return;
        }
        Log.d((String)"BluetoothAPI", (String)"Add Service UUID Filter");
        for (BluetoothHelperService s : list) {
            ScanFilter filter = new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)s.getName())).build();
            BluetoothLeDeviceFilter bluetoothLeDeviceFilter = new BluetoothLeDeviceFilter.Builder().setScanFilter(filter).build();
            builder.addDeviceFilter((DeviceFilter)bluetoothLeDeviceFilter);
        }
    }

    private void addDeviceAddressFilter(AssociationRequest.Builder builder) {
        if (this.helper.getDeviceAddress() == null || Build.VERSION.SDK_INT < 26) {
            return;
        }
        Log.d((String)"BluetoothAPI", (String)"Add Device Address Filter");
        if (this.helper.isBLE()) {
            builder.addDeviceFilter((DeviceFilter)new BluetoothLeDeviceFilter.Builder().setScanFilter(new ScanFilter.Builder().setDeviceAddress(this.helper.getDeviceAddress()).build()).build());
        } else {
            builder.addDeviceFilter((DeviceFilter)new BluetoothDeviceFilter.Builder().setAddress(this.helper.getDeviceAddress()).build());
        }
    }

    private void addDeviceNameFilter(AssociationRequest.Builder builder) {
        if (this.helper.getDeviceName() == null || Build.VERSION.SDK_INT < 26) {
            return;
        }
        Log.d((String)"BluetoothAPI", (String)"Add Device Name Filter");
        if (this.helper.isBLE()) {
            builder.addDeviceFilter((DeviceFilter)new BluetoothLeDeviceFilter.Builder().setNamePattern(Pattern.compile(this.helper.getDeviceName())).build());
        } else {
            builder.addDeviceFilter((DeviceFilter)new BluetoothDeviceFilter.Builder().setNamePattern(Pattern.compile(this.helper.getDeviceName())).build());
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.listener != null) {
            this.listener.OnDeviceChosen(null);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)"BluetoothAPI", (String)"onActivityResult ");
        if (requestCode == 6862) {
            if (resultCode == -1 && data != null && Build.VERSION.SDK_INT >= 26 && this.listener != null) {
                Parcelable result = data.getParcelableExtra("android.companion.extra.DEVICE");
                if (result instanceof BluetoothDevice) {
                    this.listener.OnDeviceChosen((BluetoothDevice)result);
                } else if (result instanceof ScanResult) {
                    ScanResult scanResult = (ScanResult)result;
                    this.listener.OnDeviceChosen(scanResult.getDevice());
                } else {
                    Log.d((String)"BluetoothAPI", (String)("Unknown processing for class [" + result.getClass() + "]"));
                }
            }
            this.finish();
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface EmptyActivityEvent {
        public void OnDeviceChosen(BluetoothDevice var1);
    }
}

