/*
 * Decompiled with CFR 0.152.
 */
package com.ble.mycdmmanager;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.ble.mycdmmanager.CMDBleCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CMDBleManager {
    private static final String TAG = "CMDBleManager";
    private BluetoothGatt gatt;
    private BluetoothAdapter bluetoothAdapter;
    private String serviceUUID;
    private String writeUUID;
    private String notifyUUID;
    private BluetoothGattCharacteristic writeCharacteristic;
    private BluetoothGattCharacteristic notifyCharacteristic;
    private final Object batchLock = new Object();
    private final ArrayList<byte[]> batchBuffer = new ArrayList();
    private HandlerThread notifyThread = new HandlerThread("CMD-Notify-Thread");
    private Handler notifyHandler;
    public CMDBleCallback cmdBleCallback = null;
    private final Context context;
    private final Runnable processNotifyBatch = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList batchToSend;
                Object object = CMDBleManager.this.batchLock;
                synchronized (object) {
                    block11: {
                        if (!CMDBleManager.this.batchBuffer.isEmpty()) break block11;
                        CMDBleManager.this.notifyHandler.postDelayed((Runnable)this, 10L);
                        return;
                    }
                    batchToSend = new ArrayList(CMDBleManager.this.batchBuffer);
                    CMDBleManager.this.batchBuffer.clear();
                }
                if (CMDBleManager.this.cmdBleCallback != null) {
                    CMDBleManager.this.cmdBleCallback.onBLENotify(CMDBleManager.this.mergeBatch(batchToSend));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                CMDBleManager.this.notifyHandler.postDelayed((Runnable)this, 10L);
            }
        }
    };
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt g, int status, int newState) {
            if (newState == 2) {
                if (CMDBleManager.this.cmdBleCallback != null) {
                    CMDBleManager.this.cmdBleCallback.onBLEConnected();
                }
                g.discoverServices();
            }
            if (newState == 0 && CMDBleManager.this.cmdBleCallback != null) {
                CMDBleManager.this.cmdBleCallback.onBLEDisconnected();
            }
        }

        public void onServicesDiscovered(BluetoothGatt g, int status) {
            if (status != 0) {
                return;
            }
            for (BluetoothGattService service : g.getServices()) {
                if (!service.getUuid().toString().toLowerCase().contains(CMDBleManager.this.serviceUUID)) continue;
                for (BluetoothGattCharacteristic ch : service.getCharacteristics()) {
                    String uuid = ch.getUuid().toString().toLowerCase();
                    if (uuid.contains(CMDBleManager.this.writeUUID)) {
                        CMDBleManager.this.writeCharacteristic = ch;
                    }
                    if (!uuid.contains(CMDBleManager.this.notifyUUID)) continue;
                    CMDBleManager.this.notifyCharacteristic = ch;
                    g.setCharacteristicNotification(CMDBleManager.this.notifyCharacteristic, true);
                }
            }
            CMDBleManager.this.notifyHandler.postDelayed(() -> {
                if (CMDBleManager.this.cmdBleCallback != null) {
                    CMDBleManager.this.cmdBleCallback.onBLEReady();
                }
            }, 100L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt g, BluetoothGattCharacteristic ch) {
            byte[] value = ch.getValue();
            Object object = CMDBleManager.this.batchLock;
            synchronized (object) {
                CMDBleManager.this.batchBuffer.add(value);
            }
            CMDBleManager.this.notifyHandler.removeCallbacks(CMDBleManager.this.processNotifyBatch);
            CMDBleManager.this.notifyHandler.post(CMDBleManager.this.processNotifyBatch);
        }
    };
    private float lastWriteDataTime = 0.0f;

    public CMDBleManager(Context ctx) {
        this.context = ctx.getApplicationContext();
        this.notifyThread.start();
        this.notifyHandler = new Handler(this.notifyThread.getLooper());
    }

    public void setCmdBleCallback(CMDBleCallback cb) {
        this.cmdBleCallback = cb;
    }

    public void setUUIDs(String service, String write, String notify) {
        this.serviceUUID = service.toLowerCase();
        this.writeUUID = write.toLowerCase();
        this.notifyUUID = notify.toLowerCase();
    }

    public void connect(BluetoothDevice device) {
        this.gatt = device.connectGatt(this.context, false, this.gattCallback);
    }

    public boolean connectMac(String mac) {
        if (this.bluetoothAdapter == null) {
            this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (this.bluetoothAdapter == null) {
            Log.w((String)TAG, (String)"android connectMac\uff1abluetoothAdapter = null\uff1b");
            return false;
        }
        this.disconnect();
        try {
            BluetoothDevice device = this.bluetoothAdapter.getRemoteDevice(mac);
            if (device == null) {
                Log.w((String)TAG, (String)"connectMac\uff1a\u4e0d\u5b58\u5728mac\u8fde\u63a5\u8bbe\u5907");
                return false;
            }
            this.connect(device);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private byte[] mergeBatch(List<byte[]> batch) {
        int totalLen = 0;
        for (byte[] b : batch) {
            totalLen += b.length + 2;
        }
        byte[] merged = new byte[totalLen];
        int pos = 0;
        for (byte[] b : batch) {
            merged[pos++] = (byte)(b.length & 0xFF);
            merged[pos++] = (byte)(b.length >> 8 & 0xFF);
            System.arraycopy(b, 0, merged, pos, b.length);
            pos += b.length;
        }
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            Object cccd;
            if (this.gatt != null && this.notifyCharacteristic != null) {
                this.gatt.setCharacteristicNotification(this.notifyCharacteristic, false);
                cccd = this.notifyCharacteristic.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805f9b34fb"));
                if (cccd != null) {
                    cccd.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                    this.gatt.writeDescriptor((BluetoothGattDescriptor)cccd);
                }
            }
            if (this.gatt != null) {
                this.gatt.disconnect();
                this.gatt.close();
                this.gatt = null;
            }
            this.writeCharacteristic = null;
            this.notifyCharacteristic = null;
            cccd = this.batchLock;
            synchronized (cccd) {
                this.batchBuffer.clear();
            }
            this.notifyHandler.removeCallbacks(this.processNotifyBatch);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean writeString(String data) {
        try {
            if (data == null || this.writeCharacteristic == null || this.gatt == null) {
                return false;
            }
            byte[] bytes = data.getBytes();
            this.write(bytes);
            this.lastWriteDataTime = (float)System.currentTimeMillis() / 1000.0f;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeBytes(byte[] data) {
        try {
            if (data == null || this.writeCharacteristic == null || this.gatt == null) {
                return false;
            }
            this.write(data);
            this.lastWriteDataTime = (float)System.currentTimeMillis() / 1000.0f;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public float getLastWriteDataTime() {
        return this.lastWriteDataTime;
    }

    public void write(byte[] data) {
        if (this.gatt == null || this.writeCharacteristic == null) {
            return;
        }
        this.writeCharacteristic.setValue(data);
        this.gatt.writeCharacteristic(this.writeCharacteristic);
    }
}

