/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartbowlib.lebo;

import android.text.TextUtils;
import com.example.smartbowlib.UnityMsgSender;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.api.LelinkSourceSDK;
import com.hpplay.sdk.source.bean.CastBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;

class MirrorFragment {
    public final INewPlayerListener playerListener = new INewPlayerListener(){

        public void onLoading(CastBean bean) {
            UnityMsgSender.log("onLoading");
        }

        public void onStart(CastBean bean) {
            UnityMsgSender.log("onStart");
            UnityMsgSender.onMessage("lebo.onStart", "");
        }

        public void onPause(CastBean bean) {
            UnityMsgSender.log("onPause");
        }

        public void onCompletion(CastBean bean, int type) {
            UnityMsgSender.log("onCompletion 1:" + type);
        }

        public void onStop(CastBean bean) {
            UnityMsgSender.log("onStop");
            UnityMsgSender.onMessage("lebo.onStop", "");
        }

        public void onSeekComplete(CastBean bean, int position) {
            UnityMsgSender.log("onSeekComplete 1:" + position);
        }

        public void onInfo(CastBean bean, int what, int extra) {
            UnityMsgSender.log("onInfoA 1:" + what + " 2:" + extra);
        }

        public void onInfo(CastBean bean, int what, String data) {
            UnityMsgSender.log("onInfoB 1:" + what + " 2:" + data);
        }

        public void onError(CastBean bean, int what, int extra) {
            String text = null;
            switch (extra) {
                case -2: 
                case 0: {
                    text = "SDK\u8ba4\u8bc1\u5931\u8d25";
                    break;
                }
                case 211026: {
                    text = "\u8bf7\u8f93\u5165\u5bc6\u7801";
                    break;
                }
                case 210004: {
                    text = "\u63a5\u6536\u7aef\u4e0d\u5728\u7ebf";
                    break;
                }
                case 211001: {
                    text = "\u7533\u8bf7\u5f55\u5c4f\u6743\u9650\u53d1\u751f\u5f02\u5e38";
                    break;
                }
                case 211002: {
                    text = "\u7533\u8bf7\u5f55\u5c4f\u6743\u9650\u88ab\u62d2\u7edd";
                    break;
                }
                case 211004: {
                    text = "\u6b64\u8bbe\u5907\u4e0d\u652f\u6301\u955c\u50cf";
                    break;
                }
                case 211050: {
                    text = "\u7f51\u7edc\u901a\u8baf\u5f02\u5e38";
                    break;
                }
                case 211051: {
                    text = "SDK\u4e0d\u652f\u6301\u955c\u50cf";
                    break;
                }
                case 211052: {
                    text = "\u63a5\u6536\u7aef\u4e0d\u652f\u6301\u6b64\u955c\u50cf";
                    break;
                }
                case 211053: {
                    text = "\u6ca1\u6709\u4e91\u955c\u50cf\u6743\u76ca";
                    break;
                }
                case 211054: {
                    text = "\u8f93\u5165\u5f02\u5e38";
                }
            }
            if (TextUtils.isEmpty((CharSequence)text)) {
                text = "\u955c\u50cf onError " + what + "/" + extra;
            }
            UnityMsgSender.error(text);
            UnityMsgSender.onMessage("lebo.onError", text);
        }

        public void onVolumeChanged(CastBean bean, float percent) {
            UnityMsgSender.log("onVolumeChanged 1:" + percent);
        }

        public void onPositionUpdate(CastBean bean, long duration, long position) {
            UnityMsgSender.log("onPositionUpdate 1:" + duration + " 2:" + position);
        }
    };
    private String mPassword;

    MirrorFragment() {
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public void startMirror(LelinkServiceInfo mSelectInfo, int resolutionCheckId) {
        int resolutionLevel = 0;
        switch (resolutionCheckId) {
            case 2: {
                resolutionLevel = 1;
                break;
            }
            case 1: {
                resolutionLevel = 2;
                break;
            }
            case 0: {
                resolutionLevel = 3;
            }
        }
        int bitrateLevel = 0;
        int bitrateCheckId = 2;
        switch (bitrateCheckId) {
            case 2: {
                bitrateLevel = 4;
                break;
            }
            case 1: {
                bitrateLevel = 5;
                break;
            }
            case 0: {
                bitrateLevel = 6;
            }
        }
        int audioType = 2;
        int audioCheckId = 1;
        switch (audioCheckId) {
            case 1: {
                audioType = 2;
                break;
            }
            case 0: {
                audioType = 0;
            }
        }
        int fullScreen = 0;
        int fullScreenCheckId = 2;
        switch (fullScreenCheckId) {
            case 2: {
                fullScreen = 0;
                break;
            }
            case 1: {
                fullScreen = 1;
                break;
            }
            case 0: {
                fullScreen = 2;
            }
        }
        LelinkPlayerInfo lelinkPlayerInfo = new LelinkPlayerInfo();
        lelinkPlayerInfo.setAutoBitrate(false);
        lelinkPlayerInfo.setLelinkServiceInfo(mSelectInfo);
        lelinkPlayerInfo.setBitRateLevel(bitrateLevel);
        lelinkPlayerInfo.setResolutionLevel(resolutionLevel);
        if (!TextUtils.isEmpty((CharSequence)this.mPassword)) {
            lelinkPlayerInfo.setCastPwd(this.mPassword);
        }
        lelinkPlayerInfo.setMirrorAudioType(audioType);
        lelinkPlayerInfo.setFullScreen(fullScreen);
        LelinkSourceSDK.getInstance().disableExternalAudio();
        LelinkSourceSDK.getInstance().startMirror(lelinkPlayerInfo);
    }
}

