/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Client;
import java.io.EOFException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

final class TCPClient
extends Client {
    public TCPClient(long l2) {
        super(SocketChannel.open(), l2);
    }

    void bind(SocketAddress socketAddress) {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        socketChannel.socket().bind(socketAddress);
    }

    void connect(SocketAddress socketAddress) {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        if (!socketChannel.connect(socketAddress)) {
            this.key.interestOps(8);
            try {
                while (!socketChannel.finishConnect()) {
                    if (this.key.isConnectable()) continue;
                    TCPClient.blockUntil(this.key, this.endTime);
                }
            }
            finally {
                if (this.key.isValid()) {
                    this.key.interestOps(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] byArray) {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        byte[] byArray2 = new byte[]{(byte)(byArray.length >>> 8), (byte)(byArray.length & 0xFF)};
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{ByteBuffer.wrap(byArray2), ByteBuffer.wrap(byArray)};
        int n2 = 0;
        this.key.interestOps(4);
        try {
            while (n2 < byArray.length + 2) {
                if (this.key.isWritable()) {
                    long l2 = socketChannel.write(byteBufferArray);
                    if (l2 < 0L) {
                        throw new EOFException();
                    }
                    if ((n2 += (int)l2) >= byArray.length + 2 || System.currentTimeMillis() <= this.endTime) continue;
                    throw new SocketTimeoutException();
                }
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _recv(int n2) {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        int n3 = 0;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.key.interestOps(1);
        try {
            while (n3 < n2) {
                if (this.key.isReadable()) {
                    long l2 = socketChannel.read(byteBuffer);
                    if (l2 < 0L) {
                        throw new EOFException();
                    }
                    if ((n3 += (int)l2) >= n2 || System.currentTimeMillis() <= this.endTime) continue;
                    throw new SocketTimeoutException();
                }
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        return byArray;
    }

    byte[] recv() {
        byte[] byArray = this._recv(2);
        int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        byte[] byArray2 = this._recv(n2);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress socketAddress, SocketAddress socketAddress2, byte[] byArray, long l2) {
        byte[] byArray2;
        TCPClient tCPClient = new TCPClient(l2);
        try {
            if (socketAddress != null) {
                tCPClient.bind(socketAddress);
            }
            tCPClient.connect(socketAddress2);
            tCPClient.send(byArray);
            byArray2 = tCPClient.recv();
        }
        finally {
            tCPClient.cleanup();
        }
        return byArray2;
    }

    static byte[] sendrecv(SocketAddress socketAddress, byte[] byArray, long l2) {
        return TCPClient.sendrecv(null, socketAddress, byArray, l2);
    }
}

