/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device.pincode;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.LelinkServiceInfoCreator;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.device.DevicePinParser;
import com.hpplay.sdk.source.device.pincode.CodeParser;
import com.hpplay.sdk.source.device.pincode.IConferenceFuzzyMatchingPinCodeListener;
import com.hpplay.sdk.source.device.pincode.PinCodeInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.CreateUtil;
import java.util.HashMap;
import org.json.JSONObject;

public class LelinkCodeParser
implements CodeParser {
    private static final String TAG = "LelinkCodeParser";
    private Context mContext;
    private IServiceInfoParseListener mListener;
    private static long startMarkTime = 0L;
    private static String sessionId;
    private DevicePinParser mServerParser;

    LelinkCodeParser(Context context) {
        this.mContext = context;
        this.mServerParser = new DevicePinParser();
    }

    @Override
    public void parsePinCode(PinCodeInfo pinCodeInfo) {
        if (!TextUtils.isEmpty((CharSequence)pinCodeInfo.pinCode) && pinCodeInfo.pinCode.length() < 9) {
            startMarkTime = System.currentTimeMillis();
            sessionId = CreateUtil.createSessionId();
            SourceDataReport.getInstance().onPinCodeStart(sessionId);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = pinCodeInfo.pinCode;
            hashMap.put("code", string.toUpperCase());
            hashMap.put("appid", Session.getInstance().appKey);
            hashMap.put("token", a.a());
            hashMap.put("uid", Session.getInstance().getUID());
            SourceLog.i(TAG, " short pincode result " + string + "  " + CloudAPI.sMultiMirrorPinUrl);
            String string2 = HapplayUtils.getMapParams(hashMap);
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sMultiMirrorPinUrl, string2);
            long l2 = System.currentTimeMillis();
            AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    block9: {
                        if (asyncHttpParameter.out.resultType == 2) {
                            SourceLog.w(LelinkCodeParser.TAG, "parsePinCodeByNet cancel request");
                            return;
                        }
                        SourceLog.debug(LelinkCodeParser.TAG, " short pincode result " + asyncHttpParameter.out.result);
                        if (LelinkCodeParser.this.mListener != null) {
                            if (!TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                                try {
                                    JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                                    int n2 = jSONObject.optInt("status");
                                    if (n2 == 200) {
                                        JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                                        LelinkCodeParser.this.mServerParser.setParseResultListener(LelinkCodeParser.this.mListener);
                                        LelinkServiceInfo lelinkServiceInfo = LelinkCodeParser.this.mServerParser.parseServiceInfo(jSONObject2.toString(), 5);
                                        break block9;
                                    }
                                    if (n2 == 211) {
                                        LelinkCodeParser.this.callbackToApp(8, null);
                                        break block9;
                                    }
                                    if (n2 == 221) {
                                        LelinkCodeParser.this.callbackToApp(7, null);
                                        break block9;
                                    }
                                    LelinkCodeParser.this.callbackToApp(5, null);
                                }
                                catch (Exception exception) {
                                    SourceLog.w(LelinkCodeParser.TAG, exception);
                                    LelinkCodeParser.this.callbackToApp(5, null);
                                }
                            } else {
                                LelinkCodeParser.this.callbackToApp(5, null);
                            }
                        }
                    }
                }
            };
            AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)pinCodeInfo.pinCode) && pinCodeInfo.pinCode.length() == 9) {
            char c2 = pinCodeInfo.pinCode.charAt(0);
            if (c2 == '7' || c2 == '8' || c2 == '9') {
                this.parsePinCodeByLocal(pinCodeInfo.pinCode);
            } else {
                this.parsePinCodeByNet(pinCodeInfo.pinCode);
            }
        } else {
            SourceLog.i(TAG, "parsePinCode code is empty or length not equals 9");
            if (null != this.mListener) {
                this.callbackToApp(0, null);
            }
        }
    }

    private void parsePinCodeByLocal(String string) {
        LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getLocalPinCodeInfo(this.mContext, string);
        if (lelinkServiceInfo == null) {
            SourceLog.i(TAG, "parsePinCodeByLocal error: getLocalPinCodeInfo is null");
            if (null != this.mListener) {
                this.callbackToApp(0, null);
            }
        } else if (null != this.mListener) {
            this.callbackToApp(1, lelinkServiceInfo);
        }
    }

    private void parsePinCodeByNet(final String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("token", a.a());
        hashMap.put("uid", Session.getInstance().getUID());
        hashMap.put("appid", Session.getInstance().appKey);
        hashMap.put("code", string);
        String string2 = HapplayUtils.getMapParams(hashMap);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sPinUrl, string2);
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                block15: {
                    if (asyncHttpParameter.out.resultType == 2) {
                        SourceLog.w(LelinkCodeParser.TAG, "parsePinCodeByNet cancel request");
                        return;
                    }
                    SourceLog.debug(LelinkCodeParser.TAG, "parsePinCodeByNet onRequestResult result:" + asyncHttpParameter.out.result);
                    if (asyncHttpParameter.out.resultType != 0) {
                        SourceLog.i(LelinkCodeParser.TAG, "parsePinCodeByNet error: resultType not success");
                        if (null != LelinkCodeParser.this.mListener) {
                            LelinkCodeParser.this.callbackToApp(5, null);
                        }
                        return;
                    }
                    String string2 = asyncHttpParameter.out.result;
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        SourceLog.i(LelinkCodeParser.TAG, "parsePinCodeByNet error: response is empty");
                        if (null != LelinkCodeParser.this.mListener) {
                            LelinkCodeParser.this.callbackToApp(5, null);
                        }
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject(string2);
                        int n2 = jSONObject.optInt("status");
                        if (n2 != 200) {
                            if (null != LelinkCodeParser.this.mListener) {
                                LelinkCodeParser.this.callbackToApp(8, null);
                            }
                            SourceLog.i(LelinkCodeParser.TAG, "parsePinCodeByNet error: status not equals 200");
                            return;
                        }
                        JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                        if (jSONObject2 == null || jSONObject2.length() <= 0) {
                            if (null != LelinkCodeParser.this.mListener) {
                                LelinkCodeParser.this.callbackToApp(5, null);
                            }
                            SourceLog.i(LelinkCodeParser.TAG, "parsePinCodeByNet error: data is empty");
                            return;
                        }
                        LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getNetPinCodeInfo(jSONObject2, string);
                        if (lelinkServiceInfo == null) {
                            SourceLog.i(LelinkCodeParser.TAG, "parsePinCodeByNet error: parse info is null");
                            if (null != LelinkCodeParser.this.mListener) {
                                LelinkCodeParser.this.callbackToApp(5, null);
                            }
                        } else if (null != LelinkCodeParser.this.mListener) {
                            LelinkCodeParser.this.callbackToApp(1, lelinkServiceInfo);
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.i(LelinkCodeParser.TAG, "parsePinCodeByNet error: response not json");
                        if (null == LelinkCodeParser.this.mListener) break block15;
                        LelinkCodeParser.this.callbackToApp(5, null);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private void callbackToApp(int n2, LelinkServiceInfo lelinkServiceInfo) {
        if (null != this.mListener) {
            this.mListener.onParseResult(n2, lelinkServiceInfo);
        }
        SourceDataReport.getInstance().onPinCodeEnd(lelinkServiceInfo, sessionId, n2, System.currentTimeMillis() - startMarkTime);
    }

    @Override
    public void setCodeCallback(IServiceInfoParseListener iServiceInfoParseListener) {
        this.mListener = iServiceInfoParseListener;
    }

    @Override
    public void setConferenceFuzzyMatchingPinCodeCallback(IConferenceFuzzyMatchingPinCodeListener iConferenceFuzzyMatchingPinCodeListener) {
    }

    @Override
    public void release() {
    }
}

