/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.net.Uri;
import android.text.TextUtils;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.ModelLoader;
import java.io.File;

public class StringLoader<T>
implements ModelLoader<String, T> {
    private final ModelLoader<Uri, T> uriLoader;

    public StringLoader(ModelLoader<Uri, T> modelLoader) {
        this.uriLoader = modelLoader;
    }

    @Override
    public DataFetcher<T> getResourceFetcher(String string, int n2, int n3) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.startsWith("/")) {
            uri = StringLoader.toFileUri(string);
        } else {
            uri = Uri.parse((String)string);
            String string2 = uri.getScheme();
            if (string2 == null) {
                uri = StringLoader.toFileUri(string);
            }
        }
        return this.uriLoader.getResourceFetcher(uri, n2, n3);
    }

    private static Uri toFileUri(String string) {
        return Uri.fromFile((File)new File(string));
    }
}

