/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker.patch.protocol;

import android.util.Log;
import com.hpplay.component.modulelinker.patch.PatchUtils;
import com.hpplay.component.modulelinker.patch.protocol.IPatchHeader;
import java.io.UnsupportedEncodingException;

public class PatchHeaderImp
implements IPatchHeader {
    private static final String TAG = "PatchHeaderImp";
    private byte[] mHeader;

    public PatchHeaderImp(byte[] byArray) {
        this.mHeader = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.mHeader, 0, this.mHeader.length);
    }

    @Override
    public String getTag() {
        try {
            return new String(new byte[]{this.mHeader[0], this.mHeader[1], this.mHeader[2], this.mHeader[3], this.mHeader[4], this.mHeader[5]}, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.w((String)TAG, (Throwable)unsupportedEncodingException);
            return "";
        }
    }

    @Override
    public int getPacthID() {
        return PatchUtils.bytesToInt(this.mHeader, 12);
    }

    @Override
    public int getVersion() {
        return PatchUtils.bytesToInt(this.mHeader, 6);
    }

    @Override
    public boolean isCompress() {
        return this.mHeader[11] == 1;
    }

    @Override
    public boolean isEncypto() {
        return this.mHeader[10] == 1;
    }

    @Override
    public int getDataLength() {
        return PatchUtils.bytesToInt(this.mHeader, 16);
    }

    @Override
    public void setTag(String string) {
        try {
            System.arraycopy(string.getBytes("UTF-8"), 0, this.mHeader, 0, 6);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    @Override
    public void setCompress(boolean bl) {
        this.mHeader[11] = bl ? (byte)1 : 0;
    }

    @Override
    public void setSetDataLength(int n2) {
        System.arraycopy(PatchUtils.intToByteArray(n2), 0, this.mHeader, 16, 4);
    }

    @Override
    public int getDiffPatchLength() {
        if (this.mHeader.length == 24) {
            return PatchUtils.bytesToInt(this.mHeader, 20);
        }
        return 0;
    }

    @Override
    public byte[] getHeader() {
        return this.mHeader;
    }
}

