/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import com.hpplay.glide.Glide;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.bitmap.BitmapResource;
import com.hpplay.glide.util.Util;

public abstract class BitmapTransformation
implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;

    public BitmapTransformation(Context context) {
        this(Glide.get(context).getBitmapPool());
    }

    public BitmapTransformation(BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;
    }

    @Override
    public final Resource<Bitmap> transform(Resource<Bitmap> bitmapResource, int n2, int n3) {
        if (!Util.isValidDimensions(n2, n3)) {
            throw new IllegalArgumentException("Cannot apply transformation on width: " + n2 + " or height: " + n3 + " less than or equal to zero and not Target.SIZE_ORIGINAL");
        }
        Bitmap bitmap = bitmapResource.get();
        int n4 = n2 == Integer.MIN_VALUE ? bitmap.getWidth() : n2;
        int n5 = n3 == Integer.MIN_VALUE ? bitmap.getHeight() : n3;
        Bitmap bitmap2 = this.transform(this.bitmapPool, bitmap, n4, n5);
        BitmapResource bitmapResource2 = bitmap.equals(bitmap2) ? bitmapResource : BitmapResource.obtain(bitmap2, this.bitmapPool);
        return bitmapResource2;
    }

    protected abstract Bitmap transform(BitmapPool var1, Bitmap var2, int var3, int var4);
}

