/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSData;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public class NSSet
extends NSObject {
    private Set<NSObject> set;
    private boolean ordered = false;

    public NSSet() {
        this.set = new LinkedHashSet<NSObject>();
    }

    public NSSet(boolean bl) {
        this.ordered = bl;
        this.set = !bl ? new LinkedHashSet<NSObject>() : new TreeSet<NSObject>();
    }

    public NSSet(NSObject ... nSObjectArray) {
        this.set = new LinkedHashSet<NSObject>();
        this.set.addAll(Arrays.asList(nSObjectArray));
    }

    public NSSet(boolean bl, NSObject ... nSObjectArray) {
        this.ordered = bl;
        this.set = !bl ? new LinkedHashSet<NSObject>() : new TreeSet<NSObject>();
        this.set.addAll(Arrays.asList(nSObjectArray));
    }

    public synchronized void addObject(NSObject nSObject) {
        this.set.add(nSObject);
    }

    public synchronized void removeObject(NSObject nSObject) {
        this.set.remove(nSObject);
    }

    public synchronized NSObject[] allObjects() {
        return this.set.toArray(new NSObject[this.count()]);
    }

    public synchronized NSObject anyObject() {
        if (this.set.isEmpty()) {
            return null;
        }
        return this.set.iterator().next();
    }

    public boolean containsObject(NSObject nSObject) {
        return this.set.contains(nSObject);
    }

    public synchronized NSObject member(NSObject nSObject) {
        for (NSObject nSObject2 : this.set) {
            if (!nSObject2.equals(nSObject)) continue;
            return nSObject2;
        }
        return null;
    }

    public synchronized boolean intersectsSet(NSSet nSSet) {
        for (NSObject nSObject : this.set) {
            if (!nSSet.containsObject(nSObject)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isSubsetOfSet(NSSet nSSet) {
        for (NSObject nSObject : this.set) {
            if (nSSet.containsObject(nSObject)) continue;
            return false;
        }
        return true;
    }

    public synchronized Iterator<NSObject> objectIterator() {
        return this.set.iterator();
    }

    Set<NSObject> getSet() {
        return this.set;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 29 * n2 + (this.set != null ? this.set.hashCode() : 0);
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NSSet nSSet = (NSSet)object;
        return this.set == nSSet.set || this.set != null && this.set.equals(nSSet.set);
    }

    public synchronized int count() {
        return this.set.size();
    }

    @Override
    public NSSet clone() {
        NSObject[] nSObjectArray = new NSObject[this.set.size()];
        int n2 = 0;
        for (NSObject nSObject : this.set) {
            nSObjectArray[n2++] = nSObject != null ? nSObject.clone() : null;
        }
        return new NSSet(this.ordered, nSObjectArray);
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<array>");
        stringBuilder.append(NSObject.NEWLINE);
        for (NSObject nSObject : this.set) {
            nSObject.toXML(stringBuilder, n2 + 1);
            stringBuilder.append(NSObject.NEWLINE);
        }
        this.indent(stringBuilder, n2);
        stringBuilder.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter binaryPropertyListWriter) {
        super.assignIDs(binaryPropertyListWriter);
        for (NSObject nSObject : this.set) {
            nSObject.assignIDs(binaryPropertyListWriter);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        if (this.ordered) {
            binaryPropertyListWriter.writeIntHeader(11, this.set.size());
        } else {
            binaryPropertyListWriter.writeIntHeader(12, this.set.size());
        }
        for (NSObject nSObject : this.set) {
            binaryPropertyListWriter.writeID(binaryPropertyListWriter.getID(nSObject));
        }
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        NSObject[] nSObjectArray = this.allObjects();
        stringBuilder.append('(');
        int n3 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < nSObjectArray.length; ++i2) {
            Class<?> clazz = nSObjectArray[i2].getClass();
            if ((clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) && n3 != stringBuilder.length()) {
                stringBuilder.append(NEWLINE);
                n3 = stringBuilder.length();
                nSObjectArray[i2].toASCII(stringBuilder, n2 + 1);
            } else {
                if (i2 != 0) {
                    stringBuilder.append(' ');
                }
                nSObjectArray[i2].toASCII(stringBuilder, 0);
            }
            if (i2 != nSObjectArray.length - 1) {
                stringBuilder.append(',');
            }
            if (stringBuilder.length() - n3 <= 80) continue;
            stringBuilder.append(NEWLINE);
            n3 = stringBuilder.length();
        }
        stringBuilder.append(')');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        NSObject[] nSObjectArray = this.allObjects();
        stringBuilder.append('(');
        int n3 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < nSObjectArray.length; ++i2) {
            Class<?> clazz = nSObjectArray[i2].getClass();
            if ((clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) && n3 != stringBuilder.length()) {
                stringBuilder.append(NEWLINE);
                n3 = stringBuilder.length();
                nSObjectArray[i2].toASCIIGnuStep(stringBuilder, n2 + 1);
            } else {
                if (i2 != 0) {
                    stringBuilder.append(' ');
                }
                nSObjectArray[i2].toASCIIGnuStep(stringBuilder, 0);
            }
            if (i2 != nSObjectArray.length - 1) {
                stringBuilder.append(',');
            }
            if (stringBuilder.length() - n3 <= 80) continue;
            stringBuilder.append(NEWLINE);
            n3 = stringBuilder.length();
        }
        stringBuilder.append(')');
    }
}

