/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.imsdk;

import android.os.AsyncTask;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.log.LeLog;
import com.hpplay.imsdk.BruteForceCoding;
import com.hpplay.imsdk.IMEntrance;
import com.hpplay.imsdk.OnConnectServerListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Observable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public abstract class AbstractBlockingClient
extends Observable
implements Runnable {
    private final String TAG = "IM_AbstractBlockingClient";
    private static short DEFAULT_MESSAGE_SIZE = (short)8192;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    protected final String server;
    protected final int port;
    private final int defaultBufferSize;
    private long heartBeatTimeOut = TimeUnit.SECONDS.toMillis(50L);
    private int defaultSocketTimeOut = 180000;
    protected final String uid;
    protected final String appid;
    protected String capability;
    protected final String token;
    private final AtomicReference<DataOutputStream> out = new AtomicReference();
    private final AtomicReference<DataInputStream> in = new AtomicReference();
    private Runnable mHeartRunnable;
    private AsyncTask mHeartTask;
    private OnConnectServerListener mListener;

    public AbstractBlockingClient(String string, int n2, String string2, String string3, String string4, String string5) {
        this(string, n2, string2, string3, string4, string5, DEFAULT_MESSAGE_SIZE);
    }

    public AbstractBlockingClient(String string, int n2, String string2, String string3, String string4, String string5, int n3) {
        this.server = string;
        this.port = n2;
        this.uid = string2;
        this.capability = string3;
        this.appid = string4;
        this.token = string5;
        this.defaultBufferSize = n3;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isRunning() {
        return this.state.get() == State.RUNNING;
    }

    public boolean isStopped() {
        return this.state.get() == State.STOPPED;
    }

    public void setOnConnectListener(OnConnectServerListener onConnectServerListener) {
        this.mListener = onConnectServerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = null;
        try {
            socket = new Socket(this.server, this.port);
            socket.setSoTimeout(this.defaultSocketTimeOut);
            LeLog.i("IM_AbstractBlockingClient", "run socket:" + socket.toString());
            this.out.set(new DataOutputStream(socket.getOutputStream()));
            this.in.set(new DataInputStream(socket.getInputStream()));
            if (!this.state.compareAndSet(State.STOPPED, State.RUNNING)) {
                if (socket != null) {
                    socket.close();
                    LeLog.i("IM_AbstractBlockingClient", "state is Runing close socket");
                }
                return;
            }
            if (this.authWrite().booleanValue()) {
                if (this.mListener != null) {
                    this.mListener.onConnectSuccess();
                }
            } else if (this.mListener != null) {
                this.mListener.onConnectFailed();
            }
            byte[] byArray = new byte[DEFAULT_MESSAGE_SIZE];
            int n2 = 0;
            int n3 = 0;
            while (this.state.get() == State.RUNNING) {
                block43: {
                    int n4 = this.in.get().read(byArray, n2, byArray.length - n2);
                    n2 += n4;
                    if (n4 == -1) {
                        LeLog.w("IM_AbstractBlockingClient", "read packageLength -1");
                        this.state.set(State.STOPPED);
                        continue;
                    }
                    while (true) {
                        byte[] byArray2;
                        if (n3 <= 0 && n2 >= 4) {
                            n3 = (int)BruteForceCoding.decodeIntBigEndian(byArray, 0, 4);
                            if (n3 > 40 * DEFAULT_MESSAGE_SIZE) {
                                LeLog.w("IM_AbstractBlockingClient", "packageLength msgLength is invalid: " + n3 + ",greater than maximum");
                                n2 = 0;
                                n3 = 0;
                                byArray = new byte[DEFAULT_MESSAGE_SIZE];
                                break block43;
                            }
                            if (n3 > byArray.length) {
                                byArray2 = new byte[byArray.length];
                                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                                byArray = new byte[n3];
                                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                            }
                        }
                        if (n3 <= 0 || n2 < n3) break block43;
                        this.handlePackageBody(byArray, n3);
                        if ((n2 -= n3) <= 0) break;
                        LeLog.i("IM_AbstractBlockingClient", "packageLength handle next package,left:" + n2);
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
                        byArray = new byte[Math.max(DEFAULT_MESSAGE_SIZE, byArray2.length)];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                        n3 = 0;
                    }
                    n3 = 0;
                    byArray = new byte[DEFAULT_MESSAGE_SIZE];
                }
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {
                    LeLog.w("IM_AbstractBlockingClient", exception);
                }
            }
        }
        catch (Exception exception) {
            LeLog.w("IM_AbstractBlockingClient", "Client failure " + exception);
        }
        finally {
            try {
                this.state.set(State.STOPPED);
                this.disconnected();
            }
            catch (Exception exception) {
                LeLog.w("IM_AbstractBlockingClient", exception);
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    LeLog.w("IM_AbstractBlockingClient", exception);
                }
            }
        }
        try {
            LeLog.w("IM_AbstractBlockingClient", "restart sRetryCount " + IMEntrance.sRetryCount);
            switch (++IMEntrance.sRetryCount) {
                case 1: {
                    Thread.sleep(15000L);
                    break;
                }
                case 2: {
                    Thread.sleep(30000L);
                    break;
                }
                default: {
                    Thread.sleep(60000L);
                    break;
                }
            }
        }
        catch (Exception exception) {
            LeLog.w("IM_AbstractBlockingClient", "restart sleep interrupt");
        }
        this.restart();
    }

    private void handlePackageBody(byte[] byArray, int n2) {
        int n3 = 16;
        byte[] byArray2 = BruteForceCoding.tail(byArray, n3, n2 - n3);
        long l2 = BruteForceCoding.decodeIntBigEndian(byArray, 8, 4);
        if (3L == l2) {
            this.heartBeatReceived();
            this.updateHeartInterval(new String(byArray2));
        } else if (8L == l2) {
            if (this.mListener != null) {
                this.mListener.onAuthCallback(new String(byArray2));
            }
            this.heartBeat();
        } else if (16L == l2) {
            LeLog.i("IM_AbstractBlockingClient", "updateCapabilityWrite replay");
        } else if (l2 == 17L) {
            String string = null;
            try {
                JSONObject jSONObject = new JSONObject(new String(byArray2));
                if (jSONObject != null) {
                    string = jSONObject.getString("msgid");
                    String string2 = jSONObject.getString("msgBody");
                    this.dispatchMsg(string2);
                }
            }
            catch (Exception exception) {
                LeLog.w("IM_AbstractBlockingClient", exception);
            }
            if (!TextUtils.isEmpty(string)) {
                this.ackMsgWrite(18, string);
            }
        } else if (l2 == 19L) {
            LeLog.i("IM_AbstractBlockingClient", "ping msg");
            long l3 = BruteForceCoding.decodeIntBigEndian(byArray, 12, 4);
            this.ackPingMsgWrite(20, l3);
        } else {
            this.dispatchMsg(new String(byArray2));
        }
    }

    private void dispatchMsg(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            LeLog.w("IM_AbstractBlockingClient", "dispatchMsg,values is invalid");
            return;
        }
        String[] stringArray = string.split(",");
        try {
            long l2 = Long.valueOf(stringArray[0], 16);
            LeLog.i("IM_AbstractBlockingClient", "run action: " + l2);
            this.messageReceived(l2, string.substring(stringArray[0].length() + 1));
        }
        catch (Exception exception) {
            LeLog.w("IM_AbstractBlockingClient", "run analysis msg failed " + exception);
        }
    }

    private void restart() {
        super.setChanged();
        LeLog.i("IM_AbstractBlockingClient", "restart");
        this.stopHeartBeat();
        this.notifyObservers();
    }

    private void stopHeartBeat() {
        LeLog.i("IM_AbstractBlockingClient", "stopHeartBeat " + this.mHeartTask);
        if (this.mHeartTask != null) {
            try {
                this.mHeartTask.cancel(true);
            }
            catch (Exception exception) {
                LeLog.w("IM_AbstractBlockingClient", exception);
            }
            this.mHeartTask = null;
        }
    }

    public boolean stop() {
        if (this.state.compareAndSet(State.RUNNING, State.STOPPING)) {
            boolean bl = true;
            this.stopHeartBeat();
            try {
                this.in.get().close();
            }
            catch (Exception exception) {
                LeLog.w("IM_AbstractBlockingClient", exception);
                bl = false;
            }
            try {
                this.out.get().close();
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public synchronized Boolean ackPingMsgWrite(int n2, long l2) {
        LeLog.i("IM_AbstractBlockingClient", "ackPingMsgWrite,msgID " + l2);
        try {
            int n3 = 16;
            byte[] byArray = new byte[16];
            int n4 = BruteForceCoding.encodeIntBigEndian(byArray, n3, 0, 4);
            n4 = BruteForceCoding.encodeIntBigEndian(byArray, 16L, n4, 2);
            n4 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n4, 2);
            n4 = BruteForceCoding.encodeIntBigEndian(byArray, n2, n4, 4);
            BruteForceCoding.encodeIntBigEndian(byArray, l2, n4, 4);
            this.out.get().write(byArray);
            this.out.get().flush();
            LeLog.i("IM_AbstractBlockingClient", "ackPingMsgWrite,ok ");
            return true;
        }
        catch (Exception exception) {
            LeLog.w("IM_AbstractBlockingClient", exception);
            return false;
        }
    }

    public synchronized Boolean ackMsgWrite(int n2, String string) {
        LeLog.i("IM_AbstractBlockingClient", "ackMsgWrite,msgID " + string);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.putOpt("msgid", (Object)string);
            String string2 = jSONObject.toString();
            int n3 = string2.getBytes().length + 16;
            byte[] byArray = new byte[16];
            int n4 = BruteForceCoding.encodeIntBigEndian(byArray, n3, 0, 4);
            n4 = BruteForceCoding.encodeIntBigEndian(byArray, 16L, n4, 2);
            n4 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n4, 2);
            n4 = BruteForceCoding.encodeIntBigEndian(byArray, n2, n4, 4);
            BruteForceCoding.encodeIntBigEndian(byArray, 1L, n4, 4);
            this.out.get().write(BruteForceCoding.add(byArray, string2.getBytes()));
            this.out.get().flush();
            LeLog.i("IM_AbstractBlockingClient", "ackMsgWrite,ok ");
            return true;
        }
        catch (Exception exception) {
            LeLog.w("IM_AbstractBlockingClient", exception);
            return false;
        }
    }

    public synchronized Boolean authWrite() {
        String string = this.uid + ";" + this.capability + ";" + this.appid + ";" + this.token;
        int n2 = string.getBytes().length + 16;
        byte[] byArray = new byte[16];
        int n3 = BruteForceCoding.encodeIntBigEndian(byArray, n2, 0, 4);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 16L, n3, 2);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n3, 2);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 7L, n3, 4);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n3, 4);
        this.out.get().write(BruteForceCoding.add(byArray, string.getBytes()));
        this.out.get().flush();
        return true;
    }

    public synchronized Boolean heartBeatWrite() {
        String string = this.uid;
        int n2 = string.getBytes().length + 16;
        byte[] byArray = new byte[16];
        int n3 = BruteForceCoding.encodeIntBigEndian(byArray, n2, 0, 4);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 16L, n3, 2);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n3, 2);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 2L, n3, 4);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n3, 4);
        this.out.get().write(BruteForceCoding.add(byArray, string.getBytes()));
        this.out.get().flush();
        return true;
    }

    public synchronized Boolean updateCapabilityWrite() {
        LeLog.i("IM_AbstractBlockingClient", "updateCapabilityWrite " + this.capability);
        String string = this.uid + ";" + this.capability + ";" + this.appid + ";" + this.token;
        int n2 = string.getBytes().length + 16;
        byte[] byArray = new byte[16];
        int n3 = BruteForceCoding.encodeIntBigEndian(byArray, n2, 0, 4);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 16L, n3, 2);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n3, 2);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 15L, n3, 4);
        n3 = BruteForceCoding.encodeIntBigEndian(byArray, 1L, n3, 4);
        this.out.get().write(BruteForceCoding.add(byArray, string.getBytes()));
        this.out.get().flush();
        return true;
    }

    private int getGameCode(String string) {
        int n2 = 0;
        byte[] byArray = string.getBytes();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 += byArray[i2];
        }
        return n2;
    }

    private void updateHeartInterval(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            int n2 = jSONObject.optInt("h");
            if (n2 > 0) {
                long l2 = TimeUnit.SECONDS.toMillis(n2);
                if (this.heartBeatTimeOut != l2) {
                    LeLog.i("IM_AbstractBlockingClient", "updateHeartInterval unEqual interval,update heartBeat");
                    this.heartBeatTimeOut = l2;
                }
            } else {
                LeLog.i("IM_AbstractBlockingClient", "updateHeartInterval failed");
            }
        }
        catch (Exception exception) {
            LeLog.w("IM_AbstractBlockingClient", exception);
        }
    }

    private void heartBeat() {
        this.stopHeartBeat();
        if (this.heartBeatTimeOut <= 0L) {
            LeLog.w("IM_AbstractBlockingClient", "invalid heart interval " + this.heartBeatTimeOut + "  use default value instead");
            this.heartBeatTimeOut = TimeUnit.SECONDS.toMillis(50L);
        }
        LeLog.i("IM_AbstractBlockingClient", "heartBeat after " + this.heartBeatTimeOut);
        this.mHeartRunnable = new HeartbeatTask();
        this.mHeartTask = AsyncManager.getInstance().exeRunnable(this.mHeartRunnable, null);
    }

    protected abstract void messageReceived(Long var1, Long var2, Long var3, Long var4, Long var5, String var6);

    protected abstract void messageReceived(String var1);

    protected abstract void messageReceived(long var1, String var3);

    protected abstract void heartBeatReceived();

    protected abstract void connected(boolean var1);

    protected abstract void disconnected();

    class HeartbeatTask
    implements Runnable {
        HeartbeatTask() {
        }

        @Override
        public void run() {
            while (AbstractBlockingClient.this.state.get() == State.RUNNING) {
                try {
                    Thread.sleep(AbstractBlockingClient.this.heartBeatTimeOut);
                }
                catch (Exception exception) {
                    LeLog.w("IM_AbstractBlockingClient", "HeartbeatTask Exception " + exception);
                    break;
                }
                try {
                    AbstractBlockingClient.this.heartBeatWrite();
                }
                catch (Exception exception) {
                    LeLog.w("IM_AbstractBlockingClient", "heartBeatWrite Exception " + exception);
                    AbstractBlockingClient.this.state.set(State.STOPPED);
                }
            }
            LeLog.w("IM_AbstractBlockingClient", "heartBeatWrite end");
        }
    }

    private static enum State {
        STOPPED,
        STOPPING,
        RUNNING;

    }
}

