/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.passthrough;

import android.text.TextUtils;
import com.hpplay.component.asyncmanager.AsyncHttpParameter;
import com.hpplay.component.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.component.asyncmanager.AsyncManager;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.LelinkReverseChannel;
import com.hpplay.component.protocol.NLProtocolBuiler;
import com.hpplay.component.protocol.PlistBuilder;
import com.hpplay.component.protocol.ProtocolSender;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.plist.Base64;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.PropertyListParser;
import com.hpplay.component.utils.Encode;
import org.json.JSONArray;
import org.json.JSONObject;

public class LelinkPassthroughChannel {
    private static String TAG = "LelinkPassthroughChannel";
    private static final String SP = "Switching Protocols";
    private static final String FLAG_START = "L[[[[[";
    private static final String FLAG_END = "]]]]]L";
    private static final String DECODE_FLAG_START = "L\\[\\[\\[\\[\\[";
    private static final String DECODE_FLAG_END = "\\]\\]\\]\\]\\]L";
    private ProtocolSender mProtocolSender;
    private boolean isConnect = false;
    private LelinkReverseChannel mProtocolReceiver;
    private boolean isIMPush;
    private String mSessionId;
    private ParamsMap mMap;
    private ProtocolListener mProtocolListener;
    private int mPType;

    public LelinkPassthroughChannel(ParamsMap paramsMap, String string, int n2, ProtocolListener protocolListener) {
        this.mMap = paramsMap;
        this.mSessionId = string;
        this.mProtocolListener = protocolListener;
        this.mPType = n2;
    }

    public void startPassthroughChannel() {
        if (this.mProtocolReceiver != null) {
            this.mProtocolReceiver.stopReceive();
            this.mProtocolReceiver = null;
        }
        this.mProtocolReceiver = new LelinkReverseChannel(this.mMap.getIp(), this.mMap.getPort(), this.mSessionId);
        byte[] byArray = new NLProtocolBuiler().getPassthReverseCmd().setPlatfrom().setUserAgent("HappyCast5,0/500.0").setNewLelinkClientId(this.mMap.getMac()).setNewSessionId(this.mSessionId).setPurposeKey("event").setConnectionKey("Upgrade").setContentLength("0").getProtocal(true);
        this.mProtocolReceiver.setRecevelistenerAndProtocol(new ProtocolListener(){

            @Override
            public void onResult(int n2, String ... stringArray) {
                try {
                    CLog.i(TAG, "---------> cmd :" + n2 + " result : " + Base64.encodeBytes(stringArray[0].getBytes()));
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
                if (stringArray[0].contains(LelinkPassthroughChannel.SP)) {
                    LelinkPassthroughChannel.this.connect();
                } else if (!TextUtils.isEmpty((CharSequence)stringArray[0])) {
                    try {
                        String string;
                        NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(stringArray[0].getBytes());
                        if (nSDictionary.containsKey("data") && !TextUtils.isEmpty((CharSequence)(string = nSDictionary.objectForKey("data").toString())) && LelinkPassthroughChannel.this.mProtocolListener != null) {
                            String[] stringArray2 = LelinkPassthroughChannel.parsePassthroughData(string);
                            LelinkPassthroughChannel.this.mProtocolListener.onResult(19, stringArray2);
                            CLog.i(TAG, "---------> cmd :" + n2 + " result : " + Base64.encodeBytes(stringArray2[0].getBytes()));
                        }
                    }
                    catch (Exception exception) {
                        CLog.w(TAG, exception);
                    }
                }
            }
        }, byArray);
        this.mProtocolReceiver.startReceive();
    }

    void connect() {
        CLog.d(TAG, "connect state : " + this.isConnect + "   ");
        this.isConnect = true;
        if (this.mProtocolSender != null) {
            this.mProtocolSender.release();
        }
        this.mProtocolSender = new ProtocolSender();
        this.mProtocolSender.setConnectInfo(this.mMap.getIp(), this.mMap.getPort());
        this.mProtocolSender.startConnect(this.mSessionId, null, 1, new ProtocolListener(){

            @Override
            public void onResult(int n2, String ... stringArray) {
                if (stringArray[0].contains("successful")) {
                    if (LelinkPassthroughChannel.this.mProtocolListener != null) {
                        LelinkPassthroughChannel.this.mProtocolListener.onResult(18, "successful");
                    }
                    return;
                }
                if (LelinkPassthroughChannel.this.mProtocolListener != null) {
                    LelinkPassthroughChannel.this.mProtocolListener.onResult(18, "failed");
                }
            }
        });
        this.isIMPush = false;
    }

    public boolean sendPassthData(int n2, String string, String string2, ProtocolListener protocolListener) {
        if (!this.isConnect) {
            return false;
        }
        String string3 = this.buildPlistProtocol(string, string2);
        this.startSendData(n2, string3, protocolListener);
        return true;
    }

    String buildPlistProtocol(String string, String string2) {
        String string3 = this.buildPassthroughPtc(string, string2);
        if (this.isIMPush) {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put((Object)string3);
            return Encode.encode(jSONArray.toString(), this.mMap.getAppsecret());
        }
        String string4 = new PlistBuilder().addIntagerToRoot("length", string3.getBytes().length).addStringToRoot("data", string3).getPotocol();
        String string5 = this.buildHeader(new NLProtocolBuiler().getStreamCmd(), string4.length());
        return string5 + string4;
    }

    public String buildHeader(NLProtocolBuiler nLProtocolBuiler, int n2) {
        return nLProtocolBuiler.setPlatfrom().setUserAgent("HappyCast5,0/500.0").setContentType("application/plist+xml").setNewSessionId(ProtocolUtils.createSessionId(this.mMap.getCuid())).setContentLength(n2 + "").getString(true);
    }

    public String buildPassthroughPtc(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FLAG_START).append(string).append(FLAG_END);
        stringBuffer.append(FLAG_START).append(string2).append(FLAG_END);
        String string3 = stringBuffer.toString().trim();
        return string3;
    }

    void startSendData(int n2, String string, ProtocolListener protocolListener) {
        if (this.isIMPush) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("pc", (Object)string);
                stringBuilder.append("020017ff").append(",").append(jSONObject.toString());
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("suid", (Object)this.mMap.getCuid());
                jSONObject2.put("ruid", (Object)this.mMap.getRuid());
                jSONObject2.put("appid", (Object)this.mMap.getAppKey());
                jSONObject2.put("token", (Object)this.mMap.getToken());
                jSONObject2.put("content", (Object)stringBuilder.toString());
                CLog.d(TAG, this.mMap.getStringParam("passthurl"));
                AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(this.mMap.getStringParam("passthurl"), jSONObject2.toString());
                asyncHttpParameter.in.requestMethod = 1;
                AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                    @Override
                    public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                        if (asyncHttpParameter.out.resultType == 0) {
                            CLog.d(TAG, "send success");
                        } else {
                            CLog.d(TAG, "send failed");
                        }
                    }
                });
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        } else if (string != null) {
            ProtocolResultPaser protocolResultPaser = new ProtocolResultPaser(n2, protocolListener);
            this.mProtocolSender.protocolEnqueue(protocolResultPaser, new byte[][]{string.getBytes()});
        }
    }

    public static String[] parsePassthroughData(String string) {
        String[] stringArray = new String[2];
        try {
            String string2 = "";
            String string3 = "";
            String[] stringArray2 = string.split(DECODE_FLAG_START);
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if (stringArray2.length - 2 == i2) {
                    string2 = stringArray2[i2].split(FLAG_END)[0];
                    continue;
                }
                if (stringArray2.length - 1 != 2) continue;
                string3 = stringArray2[i2].split(DECODE_FLAG_END)[0];
            }
            stringArray[0] = string2;
            stringArray[1] = string3;
            return stringArray;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public void release() {
        CLog.d(TAG, "release SpecialChannel");
        if (this.mProtocolSender != null) {
            this.mProtocolSender.release();
        }
        if (this.mProtocolReceiver != null) {
            this.mProtocolReceiver.stopReceive();
        }
        CLog.d(TAG, "release complation");
        this.isConnect = false;
        this.mProtocolListener = null;
    }

    static class ProtocolResultPaser
    extends ProtocolListener {
        private ProtocolListener listener;

        public ProtocolResultPaser(int n2, ProtocolListener protocolListener) {
            this.listener = protocolListener;
            this.cmdType = n2;
            CLog.i("lelinkpassths", "start send data ... " + n2);
        }

        @Override
        public void onResult(int n2, String ... stringArray) {
            try {
                if (stringArray[0].contains("200")) {
                    this.listener.onResult(this.cmdType, "successful");
                    CLog.i("lelinkpassths", "cmd :   " + n2 + "  result  :  " + Base64.encodeBytes(stringArray[0].getBytes()));
                } else {
                    this.listener.onResult(this.cmdType, "failed");
                    CLog.i("lelinkpassths", "cmd :   " + n2 + " RESULT_FAILED " + Base64.encodeBytes(stringArray[0].getBytes()));
                }
            }
            catch (Exception exception) {
                CLog.w("lelinkpassths", exception);
            }
        }
    }
}

