/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.util.Log;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.IMResult;
import com.baidu.speech.utils.auth.IMemorizable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memorizer<A extends IMemorizable<A, R>, R extends IMResult> {
    private final ConcurrentMap<A, Future<R>> mCache = new ConcurrentHashMap<A, Future<R>>();
    private static final String TAG = "Memorizer";

    public R memory(A a) throws Exception {
        Object object;
        FutureTask futureTask = null;
        A a2 = this.getKey(a);
        if (a2 != null) {
            futureTask = (FutureTask)this.mCache.get(a2);
        }
        if (futureTask != null) {
            LogUtil.d(TAG, "+ get f=" + futureTask);
            object = (IMResult)futureTask.get();
            LogUtil.d(TAG, "- get f=" + futureTask);
            if (!object.isValid()) {
                Log.d((String)TAG, (String)"haowei44");
                LogUtil.d(TAG, "arg invalid r=" + object);
                this.mCache.remove(a2);
                futureTask = null;
            }
        }
        if (futureTask == null && (futureTask = (Future)this.mCache.putIfAbsent(a, (Future<R>)(object = new FutureTask(a)))) == null) {
            futureTask = object;
            LogUtil.d(TAG, "+ run f=" + futureTask);
            ((FutureTask)object).run();
            LogUtil.d(TAG, "- run f=" + futureTask);
        }
        try {
            return (R)((IMResult)futureTask.get());
        }
        catch (ExecutionException executionException) {
            this.mCache.remove(a, futureTask);
            throw (Exception)executionException.getCause();
        }
        catch (Exception exception) {
            this.mCache.remove(a, futureTask);
            throw exception;
        }
    }

    private A getKey(A a) {
        Set set = this.mCache.keySet();
        for (IMemorizable iMemorizable : set) {
            int n = a.compareTo((IMemorizable)iMemorizable);
            if (n != 0) continue;
            return (A)iMemorizable;
        }
        return null;
    }

    public void clear() {
        if (this.mCache != null) {
            this.mCache.clear();
        }
    }
}

