/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.Fresco;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import com.dcloud.android.annotation.Nullable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.MatrixDrawable;
import com.facebook.drawee.drawable.Rounded;
import com.facebook.drawee.drawable.RoundedBitmapDrawable;
import com.facebook.drawee.drawable.RoundedColorDrawable;
import com.facebook.drawee.drawable.RoundedCornersDrawable;
import com.facebook.drawee.drawable.RoundedNinePatchDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.imagepipeline.systrace.FrescoSystrace;

public class DCWrappingUtils {
    private static final String TAG = "WrappingUtils";
    private static final Drawable sEmptyDrawable = new ColorDrawable(0);

    @Nullable
    static Drawable maybeWrapWithScaleType(@Nullable Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType) {
        return DCWrappingUtils.maybeWrapWithScaleType(drawable2, scaleType, null);
    }

    @Nullable
    static Drawable maybeWrapWithScaleType(@Nullable Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType, @Nullable PointF pointF) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"WrappingUtils#maybeWrapWithScaleType");
        }
        if (drawable2 != null && scaleType != null) {
            ScaleTypeDrawable scaleTypeDrawable;
            ScaleTypeDrawable scaleTypeDrawable2 = scaleTypeDrawable;
            scaleTypeDrawable = new ScaleTypeDrawable(drawable2, scaleType);
            if (pointF != null) {
                scaleTypeDrawable2.setFocusPoint(pointF);
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return scaleTypeDrawable2;
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return drawable2;
    }

    @Nullable
    static Drawable maybeWrapWithMatrix(@Nullable Drawable drawable2, @Nullable Matrix matrix) {
        if (drawable2 != null && matrix != null) {
            return new MatrixDrawable(drawable2, matrix);
        }
        return drawable2;
    }

    static ScaleTypeDrawable wrapChildWithScaleType(DrawableParent drawableParent, ScalingUtils.ScaleType scaleType) {
        Drawable drawable2 = DCWrappingUtils.maybeWrapWithScaleType(drawableParent.setDrawable(sEmptyDrawable), scaleType);
        drawableParent.setDrawable(drawable2);
        Preconditions.checkNotNull((Object)drawable2, (Object)"Parent has no child drawable!");
        return (ScaleTypeDrawable)drawable2;
    }

    static void updateOverlayColorRounding(DrawableParent drawableParent, @Nullable RoundingParams roundingParams) {
        Drawable drawable2 = drawableParent.getDrawable();
        if (roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.OVERLAY_COLOR) {
            if (drawable2 instanceof RoundedCornersDrawable) {
                RoundedCornersDrawable roundedCornersDrawable = (RoundedCornersDrawable)drawable2;
                DCWrappingUtils.applyRoundingParams((Rounded)roundedCornersDrawable, roundingParams);
                roundedCornersDrawable.setOverlayColor(roundingParams.getOverlayColor());
            } else {
                DrawableParent drawableParent2 = drawableParent;
                drawableParent2.setDrawable(DCWrappingUtils.maybeWrapWithRoundedOverlayColor(drawableParent2.setDrawable(sEmptyDrawable), roundingParams));
            }
        } else if (drawable2 instanceof RoundedCornersDrawable) {
            roundingParams = (RoundedCornersDrawable)drawable2;
            drawable2 = sEmptyDrawable;
            drawableParent.setDrawable(roundingParams.setCurrent(drawable2));
            drawable2.setCallback(null);
        }
    }

    static void updateLeafRounding(DrawableParent drawableParent, @Nullable RoundingParams roundingParams, Resources resources) {
        drawableParent = DCWrappingUtils.findDrawableParentForLeaf(drawableParent);
        Drawable drawable2 = drawableParent.getDrawable();
        if (roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.BITMAP_ONLY) {
            if (drawable2 instanceof Rounded) {
                DCWrappingUtils.applyRoundingParams((Rounded)drawable2, roundingParams);
            } else if (drawable2 != null) {
                drawableParent.setDrawable(sEmptyDrawable);
                drawableParent.setDrawable(DCWrappingUtils.applyLeafRounding(drawable2, roundingParams, resources));
            }
        } else if (drawable2 instanceof Rounded) {
            DCWrappingUtils.resetRoundingParams((Rounded)drawable2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Drawable maybeWrapWithRoundedOverlayColor(@Nullable Drawable drawable2, @Nullable RoundingParams roundingParams) {
        Throwable throwable2;
        block9: {
            block8: {
                try {
                    if (!FrescoSystrace.isTracing()) break block8;
                    FrescoSystrace.beginSection((String)"WrappingUtils#maybeWrapWithRoundedOverlayColor");
                }
                catch (Throwable throwable2) {
                    break block9;
                }
            }
            if (drawable2 != null && roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.OVERLAY_COLOR) {
                RoundedCornersDrawable roundedCornersDrawable;
                RoundedCornersDrawable roundedCornersDrawable2 = roundedCornersDrawable;
                {
                    roundedCornersDrawable2(drawable2);
                    DCWrappingUtils.applyRoundingParams((Rounded)roundedCornersDrawable2, roundingParams);
                    roundedCornersDrawable.setOverlayColor(roundingParams.getOverlayColor());
                }
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
                return roundedCornersDrawable2;
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return drawable2;
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        throw throwable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Drawable maybeApplyLeafRounding(@Nullable Drawable drawable2, @Nullable RoundingParams roundingParams, Resources resources) {
        Throwable throwable2;
        block11: {
            block9: {
                block10: {
                    try {
                        if (FrescoSystrace.isTracing()) {
                            FrescoSystrace.beginSection((String)"WrappingUtils#maybeApplyLeafRounding");
                        }
                        if (drawable2 == null || roundingParams == null || roundingParams.getRoundingMethod() != RoundingParams.RoundingMethod.BITMAP_ONLY) break block9;
                        if (!(drawable2 instanceof ForwardingDrawable)) break block10;
                        DrawableParent drawableParent = DCWrappingUtils.findDrawableParentForLeaf((DrawableParent)((ForwardingDrawable)drawable2));
                        drawableParent.setDrawable(DCWrappingUtils.applyLeafRounding(drawableParent.setDrawable(sEmptyDrawable), roundingParams, resources));
                    }
                    catch (Throwable throwable2) {}
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.endSection();
                    }
                    return drawable2;
                }
                drawable2 = DCWrappingUtils.applyLeafRounding(drawable2, roundingParams, resources);
                break block11;
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
                return drawable2;
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return drawable2;
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        throw throwable2;
    }

    private static Drawable applyLeafRounding(Drawable drawable2, RoundingParams objectArray, Resources resources) {
        if (drawable2 instanceof BitmapDrawable) {
            Drawable drawable3 = drawable2 = (BitmapDrawable)drawable2;
            drawable2 = drawable3.getBitmap();
            Paint paint = drawable3.getPaint();
            RoundedBitmapDrawable roundedBitmapDrawable = new RoundedBitmapDrawable(resources, (Bitmap)drawable2, paint);
            DCWrappingUtils.applyRoundingParams((Rounded)roundedBitmapDrawable, (RoundingParams)objectArray);
            return roundedBitmapDrawable;
        }
        if (drawable2 instanceof NinePatchDrawable) {
            drawable2 = (NinePatchDrawable)drawable2;
            RoundedNinePatchDrawable roundedNinePatchDrawable = new RoundedNinePatchDrawable((NinePatchDrawable)drawable2);
            DCWrappingUtils.applyRoundingParams((Rounded)roundedNinePatchDrawable, (RoundingParams)objectArray);
            return roundedNinePatchDrawable;
        }
        if (drawable2 instanceof ColorDrawable && Build.VERSION.SDK_INT >= 11) {
            RoundedColorDrawable roundedColorDrawable = RoundedColorDrawable.fromColorDrawable((ColorDrawable)((ColorDrawable)drawable2));
            DCWrappingUtils.applyRoundingParams((Rounded)roundedColorDrawable, (RoundingParams)objectArray);
            return roundedColorDrawable;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = drawable2;
        FLog.w((String)TAG, (String)"Don't know how to round that drawable: %s", (Object[])objectArray);
        return drawable2;
    }

    static void applyRoundingParams(Rounded rounded, RoundingParams roundingParams) {
        RoundingParams roundingParams2 = roundingParams;
        rounded.setCircle(roundingParams.getRoundAsCircle());
        rounded.setRadii(roundingParams.getCornersRadii());
        int n = roundingParams2.getBorderColor();
        rounded.setBorder(n, roundingParams2.getBorderWidth());
        rounded.setPadding(roundingParams.getPadding());
        rounded.setScaleDownInsideBorders(roundingParams.getScaleDownInsideBorders());
    }

    static void resetRoundingParams(Rounded rounded) {
        Rounded rounded2 = rounded;
        rounded2.setCircle(false);
        rounded2.setRadius(0.0f);
        rounded2.setBorder(0, 0.0f);
        rounded2.setPadding(0.0f);
        rounded2.setScaleDownInsideBorders(false);
    }

    static DrawableParent findDrawableParentForLeaf(DrawableParent drawableParent) {
        Drawable drawable2;
        while ((drawable2 = drawableParent.getDrawable()) != drawableParent && drawable2 instanceof DrawableParent) {
            drawableParent = (DrawableParent)drawable2;
        }
        return drawableParent;
    }
}

