/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.uniapp.ui.shadow.UniBoxShadowData;
import io.dcloud.feature.uniapp.ui.shadow.UniBoxShadowOptions;
import io.dcloud.feature.uniapp.ui.shadow.UniInsetBoxShadowDrawable;
import io.dcloud.feature.uniapp.ui.shadow.UniInsetBoxShadowLayer;
import io.dcloud.feature.uniapp.ui.shadow.UniNormalBoxShadowDrawable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class UniBoxShadowUtil {
    private static final String TAG = "UniBoxShadowUtil";
    private static boolean sBoxShadowEnabled = true;
    private static Pattern sColorPattern;

    public static void setBoxShadowEnabled(boolean bl) {
        sBoxShadowEnabled = bl;
        WXLogUtils.w(TAG, "Switch box-shadow status: " + bl);
    }

    public static boolean isBoxShadowEnabled() {
        return sBoxShadowEnabled;
    }

    public static UniBoxShadowData parseBoxShadow(int n, int n2, String string2, float[] fArray, float f, float f2) {
        if (!sBoxShadowEnabled) {
            WXLogUtils.w(TAG, "box-shadow was disabled by config");
            return null;
        }
        Object object = UniBoxShadowUtil.parseBoxShadows(string2, f);
        if (object != null && ((UniBoxShadowOptions[])object).length != 0) {
            UniBoxShadowData uniBoxShadowData;
            ArrayList<UniBoxShadowOptions> arrayList;
            ArrayList<UniBoxShadowOptions> arrayList2;
            Object object2 = arrayList2;
            arrayList2 = new ArrayList<UniBoxShadowOptions>();
            Object object3 = arrayList;
            arrayList = new ArrayList<UniBoxShadowOptions>();
            for (UniBoxShadowOptions uniBoxShadowOptions : object) {
                if (uniBoxShadowOptions == null) continue;
                if (uniBoxShadowOptions.isInset) {
                    object3.add(0, uniBoxShadowOptions);
                    continue;
                }
                object2.add(0, uniBoxShadowOptions);
            }
            if (fArray != null && fArray.length != 8) {
                WXLogUtils.w(TAG, "Length of radii must be 8");
            }
            object = uniBoxShadowData;
            ((UniBoxShadowData)object)((List<UniBoxShadowOptions>)object2, (List<UniBoxShadowOptions>)object3, fArray, f2);
            uniBoxShadowData.setStyle(string2);
            if (object2.size() > 0) {
                int n3 = 0;
                int n4 = 0;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    object3 = (UniBoxShadowOptions)object2.next();
                    ((UniBoxShadowOptions)object3).viewWidth = n;
                    ((UniBoxShadowOptions)object3).viewHeight = n2;
                    ((UniBoxShadowOptions)object3).radii = fArray;
                    if (n3 < (object3 = ((UniBoxShadowOptions)object3).getTargetCanvasRect()).width()) {
                        n3 = object3.width();
                    }
                    if (n4 >= object3.height()) continue;
                    n4 = object3.height();
                }
                ((UniBoxShadowData)object).setNormalMaxWidth(n3);
                ((UniBoxShadowData)object).setNormalMaxHeight(n4);
                ((UniBoxShadowData)object).setNormalLeft(n3 - n);
                ((UniBoxShadowData)object).setNormalTop(n4 - n2);
            }
            Object object4 = object;
            ((UniBoxShadowData)object4).setContentHeight(n2);
            ((UniBoxShadowData)object4).setContentWidth(n);
            return object4;
        }
        WXLogUtils.w(TAG, "Failed to parse box-shadow: " + string2);
        return null;
    }

    public static UniBoxShadowOptions[] parseBoxShadows(String object, float f) {
        if (sColorPattern == null) {
            sColorPattern = Pattern.compile("([rR][gG][bB][aA]?)\\((\\d+\\s*),\\s*(\\d+\\s*),\\s*(\\d+\\s*)(?:,\\s*(\\d+(?:\\.\\d+)?))?\\)");
        }
        UniBoxShadowOptions[] uniBoxShadowOptionsArray = sColorPattern.matcher((CharSequence)object);
        while (uniBoxShadowOptionsArray.find()) {
            String[] stringArray = object;
            String string2 = uniBoxShadowOptionsArray.group();
            object = Integer.toHexString(WXResourceUtils.getColor(string2, -16777216));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            object = stringArray.replace(string2, "#" + StringUtil.format((String)"%8s", (Object[])objectArray2).replaceAll("\\s", "0"));
        }
        if ((object = object.split(",")) != null && ((String[])object).length > 0) {
            uniBoxShadowOptionsArray = new UniBoxShadowOptions[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                uniBoxShadowOptionsArray[i] = UniBoxShadowUtil.parseBoxShadow(object[i], f);
            }
            return uniBoxShadowOptionsArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UniBoxShadowOptions parseBoxShadow(String string2, float f) {
        ArrayList<String> arrayList;
        UniBoxShadowOptions uniBoxShadowOptions;
        block9: {
            ArrayList<String> arrayList2;
            UniBoxShadowOptions uniBoxShadowOptions2;
            uniBoxShadowOptions = uniBoxShadowOptions2;
            uniBoxShadowOptions2 = new UniBoxShadowOptions(f);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            if ((string2 = string2.replaceAll("\\s*,\\s+", ",")).contains("inset")) {
                uniBoxShadowOptions.isInset = true;
                string2 = string2.replace("inset", "");
            }
            string2 = string2.trim();
            arrayList = arrayList2;
            if (!TextUtils.isEmpty((CharSequence)(string2 = (String)arrayList.get(new ArrayList<String>(Arrays.asList(string2.split("\\s+"))).size() - 1))) && (string2.startsWith("#") || string2.startsWith("rgb") || WXResourceUtils.isNamedColor(string2))) {
                ArrayList<String> arrayList3 = arrayList;
                uniBoxShadowOptions.color = WXResourceUtils.getColor(string2, -16777216);
                arrayList3.remove(arrayList3.size() - 1);
            }
            try {
                if (arrayList.size() < 2) {
                    return null;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)arrayList.get(0)))) {
                    uniBoxShadowOptions.hShadow = WXViewUtils.getRealSubPxByWidth(WXUtils.getFloat(((String)arrayList.get(0)).trim(), Float.valueOf(0.0f)).floatValue(), f);
                }
                if (TextUtils.isEmpty((CharSequence)((CharSequence)arrayList.get(1)))) break block9;
                uniBoxShadowOptions.vShadow = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(((String)arrayList.get(1)).trim(), Float.valueOf(0.0f)).floatValue(), f);
                break block9;
            }
            catch (Throwable throwable) {}
            throwable.printStackTrace();
            return uniBoxShadowOptions;
        }
        for (int i = 2; i < arrayList.size(); ++i) {
            int n = i - 2;
            uniBoxShadowOptions.optionParamParsers.get(n).parse((String)arrayList.get(i));
        }
        return uniBoxShadowOptions;
    }

    public static UniNormalBoxShadowDrawable getNormalBoxShadowDrawable(UniBoxShadowData uniBoxShadowData, Resources resources) {
        Canvas canvas;
        if (uniBoxShadowData.getNormalShadows().size() <= 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)uniBoxShadowData.getCanvasWidth(), (int)uniBoxShadowData.getCanvasHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        if (Build.VERSION.SDK_INT >= 19) {
            Logger.e((String)TAG, (String)("Allocation memory for box-shadow: " + bitmap.getAllocationByteCount() / 1024 + " KB"));
        }
        Canvas canvas2 = canvas;
        new Canvas(bitmap).setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        Iterator<UniBoxShadowOptions> iterator = uniBoxShadowData.getNormalShadows().iterator();
        while (iterator.hasNext()) {
            UniBoxShadowData uniBoxShadowData2 = uniBoxShadowData;
            UniBoxShadowOptions uniBoxShadowOptions = iterator.next().scale(uniBoxShadowData.getQuality());
            float f = uniBoxShadowData2.getNormalTop();
            float f2 = uniBoxShadowData2.getNormalLeft();
            float f3 = uniBoxShadowData2.getQuality();
            UniBoxShadowUtil.drawShadow(canvas2, uniBoxShadowOptions, f, f2, f3);
        }
        return new UniNormalBoxShadowDrawable(resources, bitmap);
    }

    private static void drawShadow(Canvas canvas, UniBoxShadowOptions uniBoxShadowOptions, float f, float f2, float f3) {
        Object object;
        Paint paint;
        Paint paint2;
        RectF rectF;
        Path path;
        float f4;
        float f5;
        RectF rectF2;
        UniBoxShadowOptions uniBoxShadowOptions2 = uniBoxShadowOptions;
        RectF rectF3 = rectF2;
        UniBoxShadowOptions uniBoxShadowOptions3 = uniBoxShadowOptions;
        float f6 = uniBoxShadowOptions.spread;
        float f7 = (float)uniBoxShadowOptions3.viewWidth + f6 * 2.0f;
        f6 = (float)uniBoxShadowOptions3.viewHeight + f6 * 2.0f;
        rectF2 = new RectF(0.0f, 0.0f, f7, f6);
        f6 = uniBoxShadowOptions2.blur;
        f7 = uniBoxShadowOptions2.hShadow;
        f7 = f5 >= 0.0f ? f6 + f7 * 2.0f : 0.0f;
        float f8 = uniBoxShadowOptions.vShadow;
        f6 = f4 >= 0.0f ? (f6 += f8 * 2.0f) : 0.0f;
        rectF3.offset(f7, f6);
        Path path2 = path;
        path = new Path();
        RectF rectF4 = rectF;
        UniBoxShadowOptions uniBoxShadowOptions4 = uniBoxShadowOptions;
        f8 = uniBoxShadowOptions4.viewWidth;
        float f9 = uniBoxShadowOptions4.viewHeight;
        rectF = new RectF(0.0f, 0.0f, f8, f9);
        f8 = 0.0f;
        f9 = 0.0f;
        if (f > 0.0f) {
            f8 = f * f3 / 2.0f;
        }
        if (f2 > 0.0f) {
            f9 = f2 * f3 / 2.0f;
        }
        Path path3 = path2;
        RectF rectF5 = rectF4;
        rectF5.offset(f9, f8);
        rectF5.inset(1.0f, 1.0f);
        path3.addRoundRect(rectF4, uniBoxShadowOptions.radii, Path.Direction.CCW);
        canvas.clipPath(path3, Region.Op.DIFFERENCE);
        Paint paint3 = paint2 = paint;
        paint3();
        paint3.setAntiAlias(true);
        paint.setColor(uniBoxShadowOptions.color);
        paint.setStyle(Paint.Style.FILL);
        if (uniBoxShadowOptions.blur > 0.0f) {
            BlurMaskFilter blurMaskFilter;
            BlurMaskFilter blurMaskFilter2 = blurMaskFilter;
            blurMaskFilter = new BlurMaskFilter(uniBoxShadowOptions.blur, BlurMaskFilter.Blur.NORMAL);
            paint2.setMaskFilter((MaskFilter)blurMaskFilter2);
        }
        if ((f3 = uniBoxShadowOptions.radii[0]) == (object = uniBoxShadowOptions.radii)[2] && f3 == object[4] && f3 == object[6]) {
            float f10 = f3;
            canvas.drawRoundRect(rectF3, f10, f10, paint2);
        } else {
            Path path4;
            object = path4;
            path4 = new Path();
            float[] fArray = new float[8];
            int n = 0;
            while (true) {
                float[] fArray2 = uniBoxShadowOptions.radii;
                if (n >= uniBoxShadowOptions.radii.length) break;
                float f11 = fArray2[n];
                fArray[n] = f11 == 0.0f ? 0.0f : f11 + uniBoxShadowOptions.spread;
                ++n;
            }
            Canvas canvas2 = canvas;
            canvas = Path.Direction.CW;
            object.addRoundRect(rectF3, fArray, (Path.Direction)canvas);
            canvas2.drawPath((Path)object, paint2);
        }
    }

    public static UniInsetBoxShadowLayer getInsetBoxShadowDrawable(UniBoxShadowData object) {
        if (((UniBoxShadowData)object).getInsetShadows().size() <= 0) {
            return null;
        }
        Object object2 = null;
        if (Build.VERSION.SDK_INT >= 18) {
            UniInsetBoxShadowLayer uniInsetBoxShadowLayer;
            object2 = new Drawable[((UniBoxShadowData)object).getInsetShadows().size()];
            for (int i = 0; i < ((UniBoxShadowData)object).getInsetShadows().size(); ++i) {
                UniInsetBoxShadowDrawable uniInsetBoxShadowDrawable;
                UniBoxShadowOptions uniBoxShadowOptions = ((UniBoxShadowData)object).getInsetShadows().get(i);
                UniInsetBoxShadowDrawable uniInsetBoxShadowDrawable2 = uniInsetBoxShadowDrawable;
                UniBoxShadowOptions uniBoxShadowOptions2 = uniBoxShadowOptions;
                Object object3 = object;
                int n = ((UniBoxShadowData)object3).getContentWidth();
                int n2 = ((UniBoxShadowData)object3).getContentHeight();
                float f = uniBoxShadowOptions2.hShadow;
                float f2 = uniBoxShadowOptions2.vShadow;
                float f3 = uniBoxShadowOptions2.blur;
                float f4 = uniBoxShadowOptions2.spread;
                int n3 = uniBoxShadowOptions2.color;
                float[] fArray = ((UniBoxShadowData)object).getRadii();
                uniInsetBoxShadowDrawable = new UniInsetBoxShadowDrawable(n, n2, f, f2, f3, f4, n3, fArray);
                object2[i] = uniInsetBoxShadowDrawable2;
            }
            object = uniInsetBoxShadowLayer;
            uniInsetBoxShadowLayer = new UniInsetBoxShadowLayer((Drawable[])object2);
            object2 = object;
        } else {
            WXLogUtils.w(TAG, "Call setInsetBoxShadow() requires API level 18 or higher.");
        }
        return object2;
    }
}

