/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.font.FontAdapter;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypefaceUtil {
    public static final String FONT_CACHE_DIR_NAME = "font-family";
    private static final String TAG = "TypefaceUtil";
    private static final Map<String, FontDO> sCacheMap = new HashMap<String, FontDO>();
    public static final String ACTION_TYPE_FACE_AVAILABLE = "type_face_available";

    public static void putFontDO(FontDO fontDO) {
        if (fontDO != null && !TextUtils.isEmpty((CharSequence)fontDO.getFontFamilyName())) {
            sCacheMap.put(fontDO.getFontFamilyName(), fontDO);
        }
    }

    public static void registerNativeFont(Map<String, Typeface> object) {
        if (object != null && object.size() > 0) {
            for (Map.Entry entry : object.entrySet()) {
                TypefaceUtil.putFontDO(new FontDO((String)entry.getKey(), (Typeface)entry.getValue()));
                if (!WXEnvironment.isApkDebugable()) continue;
                WXLogUtils.d(TAG, "register new typeface: " + (String)entry.getKey());
            }
        }
    }

    public static FontDO getFontDO(String string2) {
        return sCacheMap.get(string2);
    }

    public static void removeFontDO(String string2) {
        sCacheMap.remove(string2);
    }

    public static void applyFontStyle(Paint paint, int n, int n2, String string2) {
        Typeface typeface = paint.getTypeface();
        int n3 = typeface == null ? 0 : typeface.getStyle();
        int n4 = 0;
        if (n2 == 1 || (n3 & 1) != 0 && n2 == -1) {
            n4 = 1;
        }
        if (n == 2 || (n3 & 2) != 0 && n == -1) {
            n4 |= 2;
        }
        if (string2 != null) {
            typeface = TypefaceUtil.getOrCreateTypeface(string2, n4);
        }
        if (typeface != null) {
            paint.setTypeface(Typeface.create((Typeface)typeface, (int)n4));
        } else {
            paint.setTypeface(Typeface.defaultFromStyle((int)n4));
        }
        if (n >= 0) {
            float f = (n & ~(paint.getTypeface() != null ? paint.getTypeface().getStyle() : 0) & 2) != 0 ? -0.2f : 0.0f;
            paint.setTextSkewX(f);
        }
    }

    public static Typeface getOrCreateTypeface(String string2, int n) {
        FontDO fontDO = sCacheMap.get(string2);
        if (fontDO != null && fontDO.getTypeface() != null) {
            return fontDO.getTypeface();
        }
        return Typeface.create((String)string2, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFromAsset(FontDO fontDO, String string2) {
        Exception exception2;
        block5: {
            block4: {
                try {
                    string2 = Typeface.createFromAsset((AssetManager)WXEnvironment.getApplication().getAssets(), (String)string2);
                    if (string2 == null) break block4;
                }
                catch (Exception exception2) {
                    break block5;
                }
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TAG, "load asset file success");
                }
                FontDO fontDO2 = fontDO;
                fontDO2.setState(2);
                fontDO2.setTypeface((Typeface)string2);
                return;
            }
            WXLogUtils.e(TAG, "Font asset file not found " + fontDO.getUrl());
            return;
        }
        WXLogUtils.e(TAG, ((Object)exception2).toString());
    }

    public static void loadTypeface(FontDO object, boolean bl) {
        if (object != null && ((FontDO)object).getTypeface() == null && (((FontDO)object).getState() == 3 || ((FontDO)object).getState() == 0)) {
            FontDO fontDO = object;
            fontDO.setState(1);
            if (fontDO.getType() == 3) {
                FontDO fontDO2 = object;
                TypefaceUtil.loadFromAsset(fontDO2, Uri.parse((String)fontDO2.getUrl()).getPath().substring(1));
            } else if (((FontDO)object).getType() == 1) {
                File file;
                String string2 = ((FontDO)object).getUrl();
                object = ((FontDO)object).getFontFamilyName();
                String string3 = WXFileUtils.md5(string2);
                File file2 = file;
                if (!new File(TypefaceUtil.getFontCacheDir()).exists()) {
                    file2.mkdirs();
                }
                if (!TypefaceUtil.loadLocalFontFile(string3 = file2.getAbsolutePath() + File.separator + string3, (String)object, false)) {
                    TypefaceUtil.downloadFontByNetwork(string2, string3, (String)object);
                }
            } else if (!(((FontDO)object).getType() != 2 && ((FontDO)object).getType() != 5 || TypefaceUtil.loadLocalFontFile(((FontDO)object).getUrl(), ((FontDO)object).getFontFamilyName(), false))) {
                ((FontDO)object).setState(3);
            }
            return;
        }
        if (bl) {
            TypefaceUtil.notifyFontAvailable(false, (FontDO)object);
        }
    }

    private static void downloadFontByNetwork(final String string2, final String string3, final String string4) {
        IWXHttpAdapter.OnHttpListener onHttpListener;
        WXRequest wXRequest;
        Object object = WXSDKManager.getInstance().getIWXHttpAdapter();
        if (object == null) {
            WXLogUtils.e(TAG, "downloadFontByNetwork() IWXHttpAdapter == null");
            return;
        }
        IWXHttpAdapter iWXHttpAdapter = object;
        object = wXRequest;
        new WXRequest().url = string2;
        new WXRequest().method = "GET";
        IWXHttpAdapter.OnHttpListener onHttpListener2 = onHttpListener;
        onHttpListener = new IWXHttpAdapter.OnHttpListener(){

            @Override
            public void onHttpStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TypefaceUtil.TAG, "downloadFontByNetwork begin url:" + string2);
                }
            }

            @Override
            public void onHeadersReceived(int n, Map<String, List<String>> map) {
            }

            @Override
            public void onHttpUploadProgress(int n) {
            }

            @Override
            public void onHttpResponseProgress(int n) {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onHttpFinish(WXResponse object) {
                boolean bl;
                block8: {
                    block7: {
                        int n = 0;
                        if (!TextUtils.isEmpty((CharSequence)((WXResponse)object).statusCode)) {
                            try {
                                n = Integer.parseInt(((WXResponse)object).statusCode);
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = 0;
                                WXLogUtils.e(TypefaceUtil.TAG, "IWXHttpAdapter onHttpFinish statusCode:" + ((WXResponse)object).statusCode);
                            }
                        }
                        if (n < 200 || n > 299) break block7;
                        object = ((WXResponse)object).originalData;
                        if (((WXResponse)object).originalData == null) break block7;
                        bl = WXFileUtils.saveFile(string3, (byte[])object, (Context)WXEnvironment.getApplication());
                        if (bl) {
                            bl = TypefaceUtil.loadLocalFontFile(string3, string4, true);
                            break block8;
                        } else if (WXEnvironment.isApkDebugable()) {
                            WXLogUtils.d(TypefaceUtil.TAG, "downloadFontByNetwork() onHttpFinish success, but save file failed.");
                        }
                        break block8;
                    }
                    bl = false;
                }
                if (!bl && (this = (FontDO)sCacheMap.get(string4)) != null) {
                    ((FontDO)this).setState(3);
                }
            }
        };
        iWXHttpAdapter.sendRequest((WXRequest)object, onHttpListener2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadLocalFontFile(String string2, String object, boolean bl) {
        Exception exception2;
        block9: {
            block8: {
                Typeface typeface;
                if (TextUtils.isEmpty((CharSequence)string2)) return false;
                if (TextUtils.isEmpty((CharSequence)object)) {
                    return false;
                }
                try {
                    if (!new File(string2).exists()) {
                        return false;
                    }
                    typeface = Typeface.createFromFile((String)string2);
                    if (typeface == null) break block8;
                }
                catch (Exception exception2) {
                    break block9;
                }
                {
                    object = sCacheMap.get(object);
                    if (object == null) return false;
                }
                ((FontDO)object).setState(2);
                ((FontDO)object).setTypeface(typeface);
                ((FontDO)object).setFilePath(string2);
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TAG, "load local font file success");
                }
                if (bl) {
                    WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable((FontDO)object){
                        final /* synthetic */ FontDO val$fontDo;
                        {
                            this.val$fontDo = fontDO;
                        }

                        @Override
                        public void run() {
                            TypefaceUtil.notifyFontAvailable(true, this.val$fontDo);
                        }
                    }, 100L);
                    return true;
                }
                TypefaceUtil.notifyFontAvailable(true, (FontDO)object);
                return true;
            }
            WXLogUtils.e(TAG, "load local font file failed, can't create font.");
            return false;
        }
        WXLogUtils.e(TAG, ((Object)exception2).toString());
        return false;
    }

    private static void notifyFontAvailable(boolean bl, FontDO object) {
        Object object2;
        if (bl) {
            Intent intent;
            Intent intent2 = intent;
            intent2(ACTION_TYPE_FACE_AVAILABLE);
            intent2.putExtra("fontFamily", ((FontDO)object).getFontFamilyName());
            intent2.putExtra("filePath", ((FontDO)object).getFilePath());
            intent.putExtra("fontUrl", ((FontDO)object).getUrl());
            LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).sendBroadcast(intent2);
        }
        if ((object2 = WXSDKManager.getInstance().getFontAdapter()) != null) {
            FontAdapter fontAdapter = object2;
            FontDO fontDO = object;
            object2 = fontDO.getFontFamilyName();
            object = fontDO.getUrl();
            String string2 = fontDO.getFilePath();
            fontAdapter.onFontLoad((String)object2, (String)object, string2);
        }
    }

    private static String getFontCacheDir() {
        return WXEnvironment.getApplication().getCacheDir() + "/" + FONT_CACHE_DIR_NAME;
    }
}

