/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ImageDrawable
extends PaintDrawable {
    private float[] radii;
    private int bitmapHeight;
    private int bitmapWidth;

    public static Drawable createImageDrawable(@Nullable Drawable object, @NonNull ImageView.ScaleType scaleType, @Nullable float[] object2, int n, int n2, boolean bl) {
        if (!bl && n > 0 && n2 > 0) {
            if (object instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)object).getBitmap();
                object2 = bitmap;
                if (bitmap != null) {
                    BitmapShader bitmapShader;
                    ImageDrawable imageDrawable;
                    object = imageDrawable;
                    ImageView.ScaleType scaleType2 = scaleType;
                    Object object3 = object;
                    object3();
                    object3.getPaint().setFilterBitmap(true);
                    object.bitmapWidth = object2.getWidth();
                    object.bitmapHeight = object2.getHeight();
                    scaleType = bitmapShader;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    bitmapShader = new BitmapShader((Bitmap)object2, tileMode, tileMode);
                    ImageDrawable.updateShaderAndSize(scaleType2, n, n2, (ImageDrawable)((Object)object), (BitmapShader)scaleType);
                    imageDrawable.getPaint().setShader((Shader)scaleType);
                    return imageDrawable;
                }
            }
            if (object instanceof ImageDrawable) {
                ImageDrawable imageDrawable = (ImageDrawable)((Object)object);
                object2 = (Object)imageDrawable;
                if (imageDrawable.getPaint() != null && object2.getPaint().getShader() instanceof BitmapShader) {
                    object = (BitmapShader)object2.getPaint().getShader();
                    ImageDrawable.updateShaderAndSize(scaleType, n, n2, (ImageDrawable)((Object)object2), (BitmapShader)object);
                    return object2;
                }
            }
        }
        return object;
    }

    private static void updateShaderAndSize(@NonNull ImageView.ScaleType scaleType, int n, int n2, ImageDrawable imageDrawable, BitmapShader bitmapShader) {
        ImageView.ScaleType scaleType2 = scaleType;
        ImageDrawable imageDrawable2 = imageDrawable;
        int n3 = imageDrawable2.bitmapWidth;
        int n4 = imageDrawable2.bitmapHeight;
        Matrix matrix = ImageDrawable.createShaderMatrix(scaleType2, n, n2, n3, n4);
        if (scaleType2 == ImageView.ScaleType.FIT_CENTER) {
            RectF rectF;
            RectF rectF2;
            ImageView.ScaleType scaleType3 = scaleType;
            ImageDrawable imageDrawable3 = imageDrawable;
            scaleType = rectF2;
            ImageDrawable imageDrawable4 = imageDrawable;
            float f = imageDrawable4.bitmapWidth;
            float f2 = imageDrawable4.bitmapHeight;
            rectF2 = new RectF(0.0f, 0.0f, f, f2);
            RectF rectF3 = rectF;
            matrix.mapRect(new RectF(), (RectF)scaleType);
            RectF rectF4 = rectF3;
            n = (int)rectF4.width();
            n2 = (int)rectF4.height();
            int n5 = imageDrawable3.bitmapWidth;
            int n6 = imageDrawable3.bitmapHeight;
            matrix = ImageDrawable.createShaderMatrix(scaleType3, n, n2, n5, n6);
        }
        ImageDrawable imageDrawable5 = imageDrawable;
        imageDrawable5.setIntrinsicWidth(n);
        imageDrawable5.setIntrinsicHeight(n2);
        bitmapShader.setLocalMatrix(matrix);
    }

    @NonNull
    private static Matrix createShaderMatrix(@NonNull ImageView.ScaleType scaleType, int n, int n2, int n3, int n4) {
        Matrix matrix;
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (n3 * n2 > n4 * n) {
            f2 = (float)n2 / (float)n4;
            float f4 = f = ((float)n - (float)n3 * f2) * 0.5f;
            f = f3;
            f3 = f4;
        } else {
            f3 = (float)n / (float)n3;
            f = ((float)n2 - (float)n4 * f3) * 0.5f;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            matrix2.setScale((float)n / (float)n3, (float)n2 / (float)n4);
        } else if (scaleType == ImageView.ScaleType.FIT_CENTER) {
            RectF rectF;
            RectF rectF2;
            scaleType = rectF2;
            float f6 = n3;
            float f7 = n4;
            rectF2 = new RectF(0.0f, 0.0f, f6, f7);
            RectF rectF3 = rectF;
            float f8 = n;
            float f9 = n2;
            rectF = new RectF(0.0f, 0.0f, f8, f9);
            Matrix.ScaleToFit scaleToFit = Matrix.ScaleToFit.CENTER;
            matrix2.setRectToRect((RectF)scaleType, rectF3, scaleToFit);
        } else if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            float f10 = f2;
            matrix2.setScale(f10, f10);
            float f11 = f3 + 0.5f;
            matrix2.postTranslate(f11, f + 0.5f);
        }
        return matrix2;
    }

    private ImageDrawable() {
    }

    public void setCornerRadii(float[] fArray) {
        this.radii = fArray;
        super.setCornerRadii(fArray);
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        if (Build.VERSION.SDK_INT == 21) {
            paint.setAntiAlias(false);
        }
        super.onDraw(shape, canvas, paint);
    }

    @Nullable
    public float[] getCornerRadii() {
        return this.radii;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }
}

