/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.JsPromptResult;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ui.view.IWebView;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.common.adapter.ui.webview.WebViewFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WXWebView
implements IWebView {
    private static final int POST_MESSAGE = 1;
    private static final String BRIDGE_NAME = "__WEEX_WEB_VIEW_BRIDGE";
    private static final int SDK_VERSION = Build.VERSION.SDK_INT;
    private static final boolean DOWNGRADE_JS_INTERFACE = SDK_VERSION < 17;
    private Context mContext;
    private String mOrigin;
    private WebView mWebView;
    private ProgressBar mProgressBar;
    private boolean mShowLoading = true;
    private Handler mMessageHandler;
    private IWebView.OnErrorListener mOnErrorListener;
    private IWebView.OnPageListener mOnPageListener;
    private IWebView.OnMessageListener mOnMessageListener;

    public WXWebView(Context context, String string2) {
        this.mContext = context;
        this.mOrigin = string2;
    }

    private void showProgressBar(boolean n) {
        if (wXWebView.mShowLoading) {
            WXWebView wXWebView = wXWebView.mProgressBar;
            n = n != 0 ? 0 : 8;
            wXWebView.setVisibility(n);
        }
    }

    private void showWebView(boolean n) {
        WXWebView wXWebView = wXWebView.mWebView;
        n = n != 0 ? 0 : 4;
        wXWebView.setVisibility(n);
    }

    @Nullable
    private WebView getWebView() {
        return this.mWebView;
    }

    private void initWebView(WebView object) {
        WebView webView = object;
        WebSettings webSettings = webView.getSettings();
        WebViewFactory.openJSEnabled((Object)webSettings, null);
        webSettings.setUseWideViewPort(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportZoom(false);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setAllowFileAccess(false);
        webSettings.setSavePassword(false);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
                webView.loadUrl(string2);
                WXLogUtils.v("tag", "onPageOverride " + string2);
                return true;
            }

            public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
                1 v0 = this;
                super.onPageStarted(webView, string2, bitmap);
                WXLogUtils.v("tag", "onPageStarted " + string2);
                if (v0.WXWebView.this.mOnPageListener != null) {
                    WXWebView.this.mOnPageListener.onPageStart(string2);
                }
            }

            public void onPageFinished(WebView object, String string2) {
                1 v0 = object2;
                super.onPageFinished((WebView)object, string2);
                WXLogUtils.v("tag", "onPageFinished " + string2);
                if (v0.WXWebView.this.mOnPageListener != null) {
                    WebView webView = object;
                    boolean bl = webView.canGoBack();
                    object2.WXWebView.this.mOnPageListener.onPageFinish(string2, bl, webView.canGoForward());
                }
                if (object2.WXWebView.this.mOnMessageListener != null) {
                    Object object2 = object2.WXWebView.this;
                    object = new StringBuilder().append("javascript:(window.postMessage = function(message, targetOrigin) {if (message == null || !targetOrigin) return;");
                    string2 = DOWNGRADE_JS_INTERFACE ? "prompt('__WEEX_WEB_VIEW_BRIDGE://postMessage?message=' + JSON.stringify(message) + '&targetOrigin=' + targetOrigin)" : "__WEEX_WEB_VIEW_BRIDGE.postMessage(JSON.stringify(message), targetOrigin);";
                    ((WXWebView)object2).evaluateJS(((StringBuilder)object).append(string2).append("})").toString());
                }
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                1 v0 = this;
                super.onReceivedError(webView, webResourceRequest, webResourceError);
                if (v0.WXWebView.this.mOnErrorListener != null) {
                    WXWebView.this.mOnErrorListener.onError("error", "page error");
                }
            }

            public void onReceivedHttpError(WebView webView, WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
                1 v0 = this;
                super.onReceivedHttpError(webView, webResourceRequest, webResourceResponse);
                if (v0.WXWebView.this.mOnErrorListener != null) {
                    WXWebView.this.mOnErrorListener.onError("error", "http error");
                }
            }

            public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
                1 v0 = this;
                super.onReceivedSslError(webView, sslErrorHandler, sslError);
                if (v0.WXWebView.this.mOnErrorListener != null) {
                    WXWebView.this.mOnErrorListener.onError("error", "ssl error");
                }
            }
        });
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView object, int n) {
                2 v0 = object2;
                super.onProgressChanged(object, n);
                object = v0.WXWebView.this;
                boolean bl = n == 100;
                ((WXWebView)object).showWebView(bl);
                Object object2 = object2.WXWebView.this;
                boolean bl2 = n != 100;
                ((WXWebView)object2).showProgressBar(bl2);
                WXLogUtils.v("tag", "onPageProgressChanged " + n);
            }

            public void onReceivedTitle(WebView webView, String string2) {
                2 v0 = this;
                super.onReceivedTitle(webView, string2);
                if (v0.WXWebView.this.mOnPageListener != null) {
                    WXWebView.this.mOnPageListener.onReceivedTitle(webView.getTitle());
                }
            }

            public boolean onJsPrompt(WebView object, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
                Uri uri = Uri.parse((String)string3);
                if (TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)WXWebView.BRIDGE_NAME)) {
                    if (TextUtils.equals((CharSequence)uri.getAuthority(), (CharSequence)"postMessage")) {
                        2 v0 = object2;
                        Uri uri2 = uri;
                        Object object2 = uri2.getQueryParameter("message");
                        object = uri2.getQueryParameter("targetOrigin");
                        v0.WXWebView.this.onMessage((String)object2, (String)object);
                        jsPromptResult.confirm("success");
                    } else {
                        jsPromptResult.confirm("fail");
                    }
                    return true;
                }
                return super.onJsPrompt(object, string2, string3, string4, jsPromptResult);
            }
        });
        if (!DOWNGRADE_JS_INTERFACE) {
            Object object2;
            WebView webView2 = object;
            object = object2;
            object2 = new Object(){

                @JavascriptInterface
                public void postMessage(String string2, String string3) {
                    WXWebView.this.onMessage(string2, string3);
                }
            };
            webView2.addJavascriptInterface(object, BRIDGE_NAME);
        }
    }

    private void onMessage(String string2, String string3) {
        if (string2 != null && string3 != null && ((WXWebView)((Object)hashMap2)).mOnMessageListener != null) {
            Message message;
            HashMap hashMap;
            WXWebView wXWebView;
            try {
                wXWebView = hashMap2;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
            HashMap hashMap2 = hashMap;
            String string4 = string2;
            hashMap2();
            string2 = "data";
            hashMap.put(string2, JSON.parse((String)string4));
            hashMap.put("origin", string3);
            hashMap.put("type", "message");
            string2 = message;
            string2();
            ((Message)string2).what = 1;
            message.obj = hashMap2;
            wXWebView.mMessageHandler.sendMessage((Message)string2);
        }
    }

    private void evaluateJS(String string2) {
        if (SDK_VERSION < 19) {
            this.mWebView.loadUrl(string2);
        } else {
            this.mWebView.evaluateJavascript(string2, null);
        }
    }

    @Override
    public View getView() {
        FrameLayout.LayoutParams layoutParams;
        FrameLayout.LayoutParams layoutParams2;
        FrameLayout frameLayout;
        FrameLayout frameLayout2;
        FrameLayout frameLayout3 = frameLayout2 = frameLayout;
        WXWebView wXWebView = this;
        FrameLayout frameLayout4 = frameLayout2;
        WXWebView wXWebView2 = this;
        FrameLayout frameLayout5 = frameLayout2;
        frameLayout5(this.mContext);
        frameLayout5.setBackgroundColor(-1);
        wXWebView2.mWebView = new WebView(this.mContext);
        frameLayout2 = layoutParams2;
        new FrameLayout.LayoutParams((int)-1, (int)-1).gravity = 17;
        wXWebView2.mWebView.setLayoutParams((ViewGroup.LayoutParams)frameLayout2);
        frameLayout4.addView((View)wXWebView2.mWebView);
        wXWebView.initWebView(wXWebView.mWebView);
        wXWebView.mProgressBar = new ProgressBar(this.mContext);
        wXWebView.showProgressBar(false);
        frameLayout2 = layoutParams;
        frameLayout2(-2, -2);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)frameLayout2);
        layoutParams.gravity = 17;
        frameLayout3.addView((View)wXWebView.mProgressBar);
        this.mMessageHandler = new MessageHandler(this);
        return frameLayout;
    }

    @Override
    public void destroy() {
        if (this.getWebView() != null) {
            WXWebView wXWebView = this;
            wXWebView.getWebView().setWebViewClient(null);
            wXWebView.getWebView().setWebChromeClient(null);
            wXWebView.getWebView().removeAllViews();
            wXWebView.getWebView().destroy();
            wXWebView.mWebView = null;
            wXWebView.mOnMessageListener = null;
            wXWebView.mOnPageListener = null;
            wXWebView.mOnErrorListener = null;
        }
    }

    @Override
    public void loadUrl(String string2) {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().loadUrl(string2);
    }

    @Override
    public void loadDataWithBaseURL(String string2) {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().loadDataWithBaseURL(this.mOrigin, string2, "text/html", "utf-8", null);
    }

    @Override
    public void reload() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().reload();
    }

    @Override
    public void goBack() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().goBack();
    }

    @Override
    public void goForward() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().goForward();
    }

    @Override
    public void postMessage(Object object) {
        JSONObject jSONObject;
        WXWebView wXWebView;
        if (((WXWebView)((Object)string2)).getWebView() == null) {
            return;
        }
        try {
            wXWebView = string2;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        JSONObject jSONObject2 = jSONObject;
        WXWebView wXWebView2 = string2;
        JSONObject jSONObject3 = jSONObject2;
        JSONObject jSONObject4 = jSONObject3;
        jSONObject3();
        jSONObject3.put("type", (Object)"message");
        jSONObject4.put("data", object);
        String string2 = "origin";
        jSONObject.put(string2, (Object)wXWebView2.mOrigin);
        wXWebView.evaluateJS("javascript:(function () {var initData = " + jSONObject2.toString() + ";try {var event = new MessageEvent('message', initData);window.dispatchEvent(event);} catch (e) {}})();");
    }

    @Override
    public void setShowLoading(boolean bl) {
        this.mShowLoading = bl;
    }

    @Override
    public void setOnErrorListener(IWebView.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    @Override
    public void setOnPageListener(IWebView.OnPageListener onPageListener) {
        this.mOnPageListener = onPageListener;
    }

    @Override
    public void setOnMessageListener(IWebView.OnMessageListener onMessageListener) {
        this.mOnMessageListener = onMessageListener;
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<WXWebView> mWv;

        private MessageHandler(WXWebView wXWebView) {
            WeakReference<WXWebView> weakReference;
            Object object = weakReference;
            weakReference = new WeakReference<WXWebView>(wXWebView);
            v1.mWv = object;
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            if (message.what == 1 && this.mWv.get() != null && ((WXWebView)this.mWv.get()).mOnMessageListener != null) {
                ((WXWebView)this.mWv.get()).mOnMessageListener.onMessage((Map)message.obj);
            }
        }
    }
}

