/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WXScrollView
extends ScrollView
implements Handler.Callback,
IWXScroller,
WXGestureObservable,
NestedScrollingChild {
    private NestedScrollingChildHelper childHelper;
    private float ox;
    private float oy;
    private int[] consumed;
    private int[] offsetInWindow;
    int mScrollX;
    int mScrollY;
    private WXGesture wxGesture;
    private List<WXScrollViewListener> mScrollViewListeners;
    private WXBaseScroller mWAScroller;
    private View mCurrentStickyView;
    private boolean mRedirectTouchToStickyView;
    private int mStickyOffset;
    private boolean mHasNotDoneActionDown;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mScrollerTask;
    private int mInitialPosition;
    private int mCheckTime;
    private int[] mStickyP;
    private Rect mScrollRect;
    private int[] stickyScrollerP;
    private int[] stickyViewP;
    private boolean scrollable;

    public WXScrollView(Context context) {
        WXScrollView wXScrollView = this;
        super(context);
        wXScrollView.consumed = new int[2];
        wXScrollView.offsetInWindow = new int[2];
        wXScrollView.mHasNotDoneActionDown = true;
        wXScrollView.mCheckTime = 100;
        wXScrollView.mStickyP = new int[2];
        wXScrollView.stickyScrollerP = new int[2];
        wXScrollView.stickyViewP = new int[2];
        wXScrollView.scrollable = true;
        wXScrollView.mScrollViewListeners = new ArrayList<WXScrollViewListener>();
        wXScrollView.init();
        try {
            WXReflectionUtils.setValue(wXScrollView, "mMinimumVelocity", 5);
        }
        catch (Exception exception) {
            WXLogUtils.e("[WXScrollView] WXScrollView: ", exception);
        }
    }

    private void init() {
        NestedScrollingChildHelper nestedScrollingChildHelper;
        WXScrollView wXScrollView = this;
        wXScrollView.setWillNotDraw(false);
        wXScrollView.startScrollerTask();
        wXScrollView.setOverScrollMode(2);
        NestedScrollingChildHelper nestedScrollingChildHelper2 = nestedScrollingChildHelper;
        nestedScrollingChildHelper2((View)this);
        this.childHelper = nestedScrollingChildHelper2;
        nestedScrollingChildHelper.setNestedScrollingEnabled(true);
    }

    public WXScrollView(Context context, AttributeSet attributeSet) {
        WXScrollView wXScrollView = this;
        super(context, attributeSet);
        wXScrollView.consumed = new int[2];
        wXScrollView.offsetInWindow = new int[2];
        wXScrollView.mHasNotDoneActionDown = true;
        wXScrollView.mCheckTime = 100;
        wXScrollView.mStickyP = new int[2];
        wXScrollView.stickyScrollerP = new int[2];
        wXScrollView.stickyViewP = new int[2];
        wXScrollView.scrollable = true;
        wXScrollView.init();
    }

    public WXScrollView(Context context, AttributeSet attributeSet, int n) {
        WXScrollView wXScrollView = this;
        super(context, attributeSet, n);
        wXScrollView.consumed = new int[2];
        wXScrollView.offsetInWindow = new int[2];
        wXScrollView.mHasNotDoneActionDown = true;
        wXScrollView.mCheckTime = 100;
        wXScrollView.mStickyP = new int[2];
        wXScrollView.stickyScrollerP = new int[2];
        wXScrollView.stickyViewP = new int[2];
        wXScrollView.scrollable = true;
        wXScrollView.setOverScrollMode(2);
    }

    private void showStickyView() {
        WXBaseScroller wXBaseScroller = this.mWAScroller;
        if (wXBaseScroller == null) {
            return;
        }
        this.mCurrentStickyView = (wXBaseScroller = this.procSticky(wXBaseScroller.getStickMap())) != null ? wXBaseScroller : null;
    }

    private View procSticky(Map<String, Map<String, WXComponent>> object) {
        if (object == null) {
            return null;
        }
        if ((object = object.get(this.mWAScroller.getRef())) == null) {
            return null;
        }
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            WXScrollView wXScrollView = this;
            WXComponent wXComponent = (WXComponent)((Map.Entry)object.next()).getValue();
            wXScrollView.getLocationOnScreen(wXScrollView.stickyScrollerP);
            WXComponent wXComponent2 = wXComponent;
            wXComponent2.getHostView().getLocationOnScreen(this.stickyViewP);
            int n = 0;
            if (wXComponent2.getParent() != null && wXComponent.getParent().getRealView() != null) {
                n = wXComponent.getParent().getRealView().getHeight();
            }
            int n2 = n;
            n = wXComponent.getHostView().getHeight();
            int n3 = this.stickyScrollerP[1];
            int n4 = -n2 + n3 + n;
            int n5 = this.stickyViewP[1];
            if (n5 <= n3 && n5 >= n4 - n) {
                WXComponent wXComponent3 = wXComponent;
                this.mStickyOffset = n5 - n4;
                wXComponent3.setStickyOffset(n5 - n3);
                return wXComponent3.getHostView();
            }
            wXComponent.setStickyOffset(0);
        }
        return null;
    }

    public void startScrollerTask() {
        if (this.mScrollerTask == null) {
            this.mScrollerTask = new Handler(WXThread.secure(this));
        }
        WXScrollView wXScrollView = this;
        wXScrollView.mInitialPosition = wXScrollView.getScrollY();
        long l = this.mCheckTime;
        wXScrollView.mScrollerTask.sendEmptyMessageDelayed(0, l);
    }

    public void addScrollViewListener(WXScrollViewListener wXScrollViewListener) {
        if (!this.mScrollViewListeners.contains(wXScrollViewListener)) {
            this.mScrollViewListeners.add(wXScrollViewListener);
        }
    }

    public void removeScrollViewListener(WXScrollViewListener wXScrollViewListener) {
        this.mScrollViewListeners.remove(wXScrollViewListener);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.mRedirectTouchToStickyView = true;
        }
        if (this.mRedirectTouchToStickyView) {
            boolean bl = this.mCurrentStickyView != null;
            this.mRedirectTouchToStickyView = bl;
            if (bl) {
                bl = motionEvent.getY() <= (float)this.mCurrentStickyView.getHeight() && motionEvent.getX() >= (float)this.mCurrentStickyView.getLeft() && motionEvent.getX() <= (float)this.mCurrentStickyView.getRight();
                this.mRedirectTouchToStickyView = bl;
            }
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                Rect rect;
                Rect rect2 = rect;
                rect = new Rect();
                this.mScrollRect = rect2;
                this.getGlobalVisibleRect(rect2);
            }
            WXScrollView wXScrollView = this;
            wXScrollView.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            motionEvent.offsetLocation(0.0f, (float)(wXScrollView.stickyViewP[1] - this.mScrollRect.top));
        }
        WXScrollView wXScrollView = this;
        boolean bl = super.dispatchTouchEvent(motionEvent);
        WXGesture wXGesture = wXScrollView.wxGesture;
        if (wXGesture != null) {
            bl |= wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    protected void dispatchDraw(Canvas canvas) {
        WXScrollView wXScrollView = this;
        super.dispatchDraw(canvas);
        if (wXScrollView.mCurrentStickyView != null) {
            WXScrollView wXScrollView2 = this;
            canvas.save();
            wXScrollView2.mCurrentStickyView.getLocationOnScreen(this.mStickyP);
            int n = wXScrollView2.mStickyOffset;
            if (n > 0) {
                n = 0;
            }
            WXScrollView wXScrollView3 = this;
            canvas.translate((float)this.mStickyP[0], (float)(this.getScrollY() + n));
            int n2 = wXScrollView3.mCurrentStickyView.getWidth();
            int n3 = wXScrollView3.mCurrentStickyView.getHeight();
            canvas.clipRect(0, n, n2, n3);
            this.mCurrentStickyView.draw(canvas);
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.scrollable) {
            return true;
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                Rect rect;
                Rect rect2 = rect;
                rect = new Rect();
                this.mScrollRect = rect2;
                this.getGlobalVisibleRect(rect2);
            }
            this.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            motionEvent.offsetLocation(0.0f, (float)(-(this.stickyViewP[1] - this.mScrollRect.top)));
        }
        if (motionEvent.getAction() == 0) {
            this.mHasNotDoneActionDown = false;
        }
        if (this.mHasNotDoneActionDown) {
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setAction(0);
            this.mHasNotDoneActionDown = false;
            motionEvent2.recycle();
        }
        if (motionEvent.getAction() == 0) {
            MotionEvent motionEvent3 = motionEvent;
            this.ox = motionEvent3.getX();
            this.oy = motionEvent3.getY();
            this.startNestedScroll(3);
        }
        if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
            this.mHasNotDoneActionDown = true;
            this.stopNestedScroll();
        }
        if (motionEvent.getAction() == 2) {
            int[] nArray;
            int[] nArray2;
            float f;
            int n;
            MotionEvent motionEvent4 = motionEvent;
            float f2 = motionEvent4.getX();
            if (this.dispatchNestedPreScroll((int)(this.ox - f2), n = (int)(this.oy - (f = motionEvent4.getY())), nArray2 = this.consumed, nArray = this.offsetInWindow)) {
                motionEvent.setLocation(f2 += (float)this.consumed[0], f + (float)this.consumed[1]);
            }
            MotionEvent motionEvent5 = motionEvent;
            this.ox = motionEvent5.getX();
            this.oy = motionEvent5.getY();
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.childHelper.setNestedScrollingEnabled(bl);
    }

    public boolean isNestedScrollingEnabled() {
        return this.childHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int n) {
        return this.childHelper.startNestedScroll(n);
    }

    public void stopNestedScroll() {
        this.childHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.childHelper.hasNestedScrollingParent();
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray) {
        return this.childHelper.dispatchNestedScroll(n, n2, n3, n4, nArray);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2) {
        return this.childHelper.dispatchNestedPreScroll(n, n2, nArray, nArray2);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean bl) {
        return this.childHelper.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.childHelper.dispatchNestedPreFling(f, f2);
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return this.dispatchNestedPreFling(f, f2);
    }

    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return this.dispatchNestedFling(f, f2, bl);
    }

    public void fling(int n) {
        WXScrollView wXScrollView = this;
        super.fling(n);
        Handler handler = wXScrollView.mScrollerTask;
        if (handler != null) {
            handler.removeMessages(0);
        }
        this.startScrollerTask();
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        List<WXScrollViewListener> list;
        int n5;
        WXScrollView wXScrollView = this;
        wXScrollView.mScrollX = wXScrollView.getScrollX();
        wXScrollView.mScrollY = n5 = wXScrollView.getScrollY();
        wXScrollView.onScroll(wXScrollView, wXScrollView.mScrollX, n5);
        View view = wXScrollView.getChildAt(wXScrollView.getChildCount() - 1);
        if (view == null) {
            return;
        }
        int n6 = this.mScrollY;
        if (view.getBottom() - (this.getHeight() + n6) == 0) {
            WXScrollView wXScrollView2 = this;
            wXScrollView2.onScrollToBottom(wXScrollView2.mScrollX, n6);
        }
        int n7 = (list = this.mScrollViewListeners) == null ? 0 : list.size();
        for (int i = 0; i < n7; ++i) {
            this.mScrollViewListeners.get(i).onScrollChanged(this, n, n2, n3, n4);
        }
        this.showStickyView();
    }

    protected void onScroll(WXScrollView list, int n, int n2) {
        list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScroll(this, n, n2);
        }
    }

    protected void onScrollToBottom(int n, int n2) {
        List<WXScrollViewListener> list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScrollToBottom(this, n, n2);
        }
    }

    public boolean handleMessage(Message message) {
        if (message.what == 0) {
            message = this.mScrollerTask;
            if (message != null) {
                message.removeMessages(0);
            }
            WXScrollView wXScrollView = this;
            int n = wXScrollView.getScrollY();
            if (wXScrollView.mInitialPosition - n == 0) {
                WXScrollView wXScrollView2 = this;
                n = wXScrollView2.getScrollX();
                int n2 = wXScrollView2.getScrollY();
                wXScrollView2.onScrollStopped(this, n, n2);
            } else {
                WXScrollView wXScrollView3 = this;
                n = wXScrollView3.getScrollX();
                wXScrollView3.onScroll(wXScrollView3, n, wXScrollView3.getScrollY());
                wXScrollView3.mInitialPosition = wXScrollView3.getScrollY();
                Handler handler = wXScrollView3.mScrollerTask;
                if (handler != null) {
                    long l = this.mCheckTime;
                    handler.sendEmptyMessageDelayed(0, l);
                }
            }
        }
        return true;
    }

    protected void onScrollStopped(WXScrollView list, int n, int n2) {
        list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScrollStopped(this, n, n2);
        }
    }

    @Override
    public void destroy() {
        WXScrollView wXScrollView = wXScrollView.mScrollerTask;
        if (wXScrollView != null) {
            wXScrollView.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public Rect getContentFrame() {
        WXScrollView wXScrollView = this;
        int n = wXScrollView.computeHorizontalScrollRange();
        int n2 = wXScrollView.computeVerticalScrollRange();
        return new Rect(0, 0, n, n2);
    }

    public void setWAScroller(WXBaseScroller wXBaseScroller) {
        this.mWAScroller = wXBaseScroller;
    }

    public static interface WXScrollViewListener {
        public void onScrollChanged(WXScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrollToBottom(WXScrollView var1, int var2, int var3);

        public void onScrollStopped(WXScrollView var1, int var2, int var3);

        public void onScroll(WXScrollView var1, int var2, int var3);
    }
}

