/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.ImageDrawable;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public class WXImageView
extends ImageView
implements WXGestureObservable,
IRenderStatus<WXImage>,
IRenderResult<WXImage>,
WXImage.Measurable {
    private WeakReference<WXImage> mWeakReference;
    private WXGesture wxGesture;
    private float[] borderRadius;
    private boolean gif;
    private boolean isBitmapReleased = false;
    private boolean enableBitmapAutoManage = true;
    private boolean mOutWindowVisibilityChangedReally;

    public WXImageView(Context context) {
        super(context);
    }

    public void setImageResource(int n) {
        WXImageView wXImageView = this;
        wXImageView.setImageDrawable(wXImageView.getResources().getDrawable(n));
    }

    public void setImageDrawable(@Nullable Drawable drawable2, boolean bl) {
        ((WXImageView)object).gif = bl;
        ViewGroup.LayoutParams layoutParams = object.getLayoutParams();
        if (layoutParams != null) {
            ImageDrawable imageDrawable;
            int n;
            Drawable drawable3 = drawable2;
            WXImageView wXImageView = object;
            drawable2 = wXImageView.getScaleType();
            float[] fArray = wXImageView.borderRadius;
            ViewGroup.LayoutParams layoutParams2 = layoutParams;
            int n2 = layoutParams2.width - object.getPaddingLeft() - object.getPaddingRight();
            Drawable drawable4 = ImageDrawable.createImageDrawable(drawable3, (ImageView.ScaleType)drawable2, fArray, n2, n = layoutParams2.height - object.getPaddingTop() - object.getPaddingBottom(), bl);
            if (drawable4 instanceof ImageDrawable && !Arrays.equals((imageDrawable = (ImageDrawable)drawable4).getCornerRadii(), ((WXImageView)object).borderRadius)) {
                imageDrawable.setCornerRadii(((WXImageView)object).borderRadius);
            }
            WXImageView wXImageView2 = object;
            super.setImageDrawable(drawable4);
            Object object = wXImageView2.mWeakReference;
            if (object != null && (object = (WXImage)((Reference)object).get()) != null) {
                ((WXComponent)object).readyToRender();
            }
        }
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        WXImageView wXImageView = this;
        wXImageView.setImageDrawable(drawable2, wXImageView.gif);
    }

    public void setImageBitmap(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            bitmap = null;
        } else {
            BitmapDrawable bitmapDrawable;
            BitmapDrawable bitmapDrawable2 = bitmapDrawable;
            bitmapDrawable = new BitmapDrawable(this.getResources(), bitmap);
            bitmap = bitmapDrawable2;
        }
        this.setImageDrawable((Drawable)bitmap);
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        WXImageView wXImageView = this;
        boolean bl = super.onTouchEvent(motionEvent);
        WXGesture wXGesture = wXImageView.wxGesture;
        if (wXGesture != null) {
            bl |= wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    public void setBorderRadius(@NonNull float[] fArray) {
        this.borderRadius = fArray;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (bl) {
            WXImageView wXImageView = wXImageView2;
            WXImageView wXImageView2 = wXImageView.getDrawable();
            wXImageView.setImageDrawable((Drawable)wXImageView2, wXImageView.gif);
        }
    }

    @Override
    public void holdComponent(WXImage wXImage) {
        WeakReference<WXImage> weakReference;
        WXImageView wXImageView = weakReference2;
        WeakReference<WXImage> weakReference2 = weakReference;
        weakReference = new WeakReference<WXImage>(wXImage);
        wXImageView.mWeakReference = weakReference2;
    }

    @Override
    @Nullable
    public WXImage getComponent() {
        WeakReference<WXImage> weakReference = ((WXImageView)((Object)weakReference)).mWeakReference;
        return weakReference != null ? (WXImage)weakReference.get() : null;
    }

    @Override
    public int getNaturalWidth() {
        if ((this = this.getDrawable()) != null) {
            if (this instanceof ImageDrawable) {
                return ((ImageDrawable)((Object)this)).getBitmapWidth();
            }
            if (this instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)this).getBitmap();
                if (bitmap != null) {
                    return bitmap.getWidth();
                }
                WXLogUtils.w("WXImageView", "Bitmap on " + this.toString() + " is null");
            } else {
                WXLogUtils.w("WXImageView", "Not supported drawable type: " + this.getClass().getSimpleName());
            }
        }
        return -1;
    }

    @Override
    public int getNaturalHeight() {
        if ((this = this.getDrawable()) != null) {
            if (this instanceof ImageDrawable) {
                return ((ImageDrawable)((Object)this)).getBitmapHeight();
            }
            if (this instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)this).getBitmap();
                if (bitmap != null) {
                    return bitmap.getHeight();
                }
                WXLogUtils.w("WXImageView", "Bitmap on " + this.toString() + " is null");
            } else {
                WXLogUtils.w("WXImageView", "Not supported drawable type: " + this.getClass().getSimpleName());
            }
        }
        return -1;
    }

    public void dispatchWindowVisibilityChanged(int n) {
        this.mOutWindowVisibilityChangedReally = true;
        super.dispatchWindowVisibilityChanged(n);
        this.mOutWindowVisibilityChangedReally = false;
    }

    protected void onWindowVisibilityChanged(int n) {
        WXImageView wXImageView = this;
        super.onWindowVisibilityChanged(n);
        if (wXImageView.mOutWindowVisibilityChangedReally) {
            if (n == 0) {
                this.autoRecoverImage();
            } else {
                this.autoReleaseImage();
            }
        }
    }

    protected void onAttachedToWindow() {
        WXImageView wXImageView = this;
        super.onAttachedToWindow();
        wXImageView.autoRecoverImage();
    }

    protected void onDetachedFromWindow() {
        WXImageView wXImageView = this;
        super.onDetachedFromWindow();
        wXImageView.autoReleaseImage();
    }

    public void onStartTemporaryDetach() {
        WXImageView wXImageView = this;
        super.onStartTemporaryDetach();
        wXImageView.autoReleaseImage();
    }

    public void onFinishTemporaryDetach() {
        WXImageView wXImageView = this;
        super.onFinishTemporaryDetach();
        wXImageView.autoRecoverImage();
    }

    public void setEnableBitmapAutoManage(boolean bl) {
        this.enableBitmapAutoManage = bl;
    }

    public void autoReleaseImage() {
        if (((WXImageView)this).enableBitmapAutoManage && !((WXImageView)this).isBitmapReleased) {
            ((WXImageView)this).isBitmapReleased = true;
            if ((this = ((WXImageView)this).getComponent()) != null) {
                ((WXImage)this).autoReleaseImage();
            }
        }
    }

    public void autoRecoverImage() {
        if (this.enableBitmapAutoManage && this.isBitmapReleased) {
            WXImage wXImage = this.getComponent();
            if (wXImage != null) {
                wXImage.autoRecoverImage();
            }
            this.isBitmapReleased = false;
        }
    }
}

