/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WXHorizontalScrollView
extends HorizontalScrollView
implements IWXScroller,
WXGestureObservable {
    private WXGesture wxGesture;
    private ScrollViewListener mScrollViewListener;
    private List<ScrollViewListener> mScrollViewListeners;
    private boolean scrollable;

    public WXHorizontalScrollView(Context context) {
        WXHorizontalScrollView wXHorizontalScrollView = this;
        super(context);
        wXHorizontalScrollView.scrollable = true;
        wXHorizontalScrollView.init();
    }

    private void init() {
        WXHorizontalScrollView wXHorizontalScrollView = this;
        wXHorizontalScrollView.setWillNotDraw(false);
        wXHorizontalScrollView.setOverScrollMode(2);
    }

    public WXHorizontalScrollView(Context context, AttributeSet attributeSet) {
        WXHorizontalScrollView wXHorizontalScrollView = this;
        super(context, attributeSet);
        wXHorizontalScrollView.scrollable = true;
        wXHorizontalScrollView.init();
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        WXHorizontalScrollView wXHorizontalScrollView = this;
        super.onScrollChanged(n, n2, n3, n4);
        Iterator iterator = wXHorizontalScrollView.mScrollViewListener;
        if (iterator != null) {
            iterator.onScrollChanged(this, n, n2, n3, n4);
        }
        if ((iterator = this.mScrollViewListeners) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((ScrollViewListener)iterator.next()).onScrollChanged(this, n, n2, n3, n4);
            }
        }
    }

    public void setScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListener = scrollViewListener;
    }

    @Override
    public void destroy() {
    }

    public void addScrollViewListener(ScrollViewListener scrollViewListener) {
        if (this.mScrollViewListeners == null) {
            CopyOnWriteArrayList<ScrollViewListener> copyOnWriteArrayList;
            CopyOnWriteArrayList<ScrollViewListener> copyOnWriteArrayList2 = copyOnWriteArrayList;
            copyOnWriteArrayList = new CopyOnWriteArrayList<ScrollViewListener>();
            this.mScrollViewListeners = copyOnWriteArrayList2;
        }
        if (!this.mScrollViewListeners.contains(scrollViewListener)) {
            this.mScrollViewListeners.add(scrollViewListener);
        }
    }

    public void removeScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListeners.remove(scrollViewListener);
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        WXHorizontalScrollView wXHorizontalScrollView = this;
        boolean bl = super.dispatchTouchEvent(motionEvent);
        WXGesture wXGesture = wXHorizontalScrollView.wxGesture;
        if (wXGesture != null) {
            bl |= wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.scrollable) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public Rect getContentFrame() {
        WXHorizontalScrollView wXHorizontalScrollView = this;
        int n = wXHorizontalScrollView.computeHorizontalScrollRange();
        int n2 = wXHorizontalScrollView.computeVerticalScrollRange();
        return new Rect(0, 0, n, n2);
    }

    public static interface ScrollViewListener {
        public void onScrollChanged(WXHorizontalScrollView var1, int var2, int var3, int var4, int var5);
    }
}

