/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.os.Build;
import android.text.method.BaseMovementMethod;
import android.text.method.MovementMethod;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import io.dcloud.common.core.ui.keyboard.DCEditText;

public class WXEditText
extends DCEditText
implements WXGestureObservable {
    private WXGesture wxGesture;
    private int mLines = 1;
    private boolean mAllowDisableMovement = true;
    private boolean mAllowCopyPaste = true;

    public WXEditText(Context context, String string2) {
        super(context, string2);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public void setLines(int n) {
        super.setLines(n);
        this.mLines = n;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        WXEditText wXEditText = this;
        boolean bl = super.onTouchEvent(motionEvent);
        WXGesture wXGesture = wXEditText.wxGesture;
        if (wXGesture != null) {
            bl |= wXGesture.onTouch((View)this, motionEvent);
        }
        if ((wXGesture = this.getParent()) != null) {
            int n = motionEvent.getAction() & 0xFF;
            if (n != 0) {
                if (n == 1 || n == 3) {
                    wXGesture.requestDisallowInterceptTouchEvent(false);
                }
            } else if (this.mLines < this.getLineCount()) {
                wXGesture.requestDisallowInterceptTouchEvent(true);
            }
        }
        return bl;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        WXEditText wXEditText = wXEditText4;
        super.onSizeChanged(n, n2, n3, n4);
        if (wXEditText.getLayout() != null) {
            WXEditText wXEditText2 = wXEditText4;
            n = wXEditText2.getLayout().getHeight();
            if (wXEditText2.mAllowDisableMovement && n2 < n) {
                BaseMovementMethod baseMovementMethod;
                WXEditText wXEditText3 = wXEditText4;
                WXEditText wXEditText4 = baseMovementMethod;
                baseMovementMethod = new BaseMovementMethod();
                wXEditText3.setMovementMethod((MovementMethod)wXEditText4);
            } else {
                WXEditText wXEditText5 = wXEditText4;
                wXEditText5.setMovementMethod(wXEditText5.getDefaultMovementMethod());
            }
        }
    }

    public void setAllowDisableMovement(boolean bl) {
        this.mAllowDisableMovement = bl;
    }

    public void setAllowCopyPaste(boolean bl) {
        this.mAllowCopyPaste = bl;
        if (bl) {
            WXEditText wXEditText = this;
            wXEditText.setLongClickable(true);
            wXEditText.setCustomSelectionActionModeCallback(null);
            if (Build.VERSION.SDK_INT >= 23) {
                this.setCustomInsertionActionModeCallback(null);
            }
        } else {
            ActionMode.Callback callback;
            this.setLongClickable(false);
            ActionMode.Callback callback2 = callback;
            callback = new ActionMode.Callback(){

                public boolean onCreateActionMode(ActionMode actionMode, Menu menu) {
                    return false;
                }

                public boolean onPrepareActionMode(ActionMode actionMode, Menu menu) {
                    return false;
                }

                public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
                    return false;
                }

                public void onDestroyActionMode(ActionMode actionMode) {
                }
            };
            if (Build.VERSION.SDK_INT >= 23) {
                this.setCustomInsertionActionModeCallback(callback2);
            }
            this.setCustomSelectionActionModeCallback(callback2);
        }
    }

    public boolean onTextContextMenuItem(int n) {
        return !this.mAllowCopyPaste || super.onTextContextMenuItem(n);
    }
}

