/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.flat.widget;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXViewUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
abstract class BaseWidget
implements Widget {
    private BorderDrawable backgroundBorder;
    private int leftOffset;
    private int topOffset;
    private int rightOffset;
    private int bottomOffset;
    private Rect borderBox;
    private Point offsetOfContainer;
    @NonNull
    private final FlatGUIContext context;

    BaseWidget(@NonNull FlatGUIContext flatGUIContext) {
        Point point;
        Rect rect;
        BaseWidget baseWidget = rect;
        rect = new Rect();
        v1.borderBox = baseWidget;
        baseWidget = point;
        point = new Point();
        v1.offsetOfContainer = baseWidget;
        v1.context = flatGUIContext;
    }

    @Override
    public void setLayout(int n, int n2, int n3, int n4, int n5, int n6, Point point) {
        BaseWidget baseWidget = this;
        baseWidget.offsetOfContainer = point;
        n = n3 + n;
        n2 = n5 + n2;
        baseWidget.borderBox.set(n3, n5, n, n2);
        BorderDrawable borderDrawable = baseWidget.backgroundBorder;
        if (borderDrawable != null) {
            this.setBackgroundAndBorder(borderDrawable);
        }
        this.invalidate();
    }

    @Override
    public void setContentBox(int n, int n2, int n3, int n4) {
        this.leftOffset = n;
        this.topOffset = n2;
        this.rightOffset = n3;
        this.bottomOffset = n4;
        this.invalidate();
    }

    @Override
    public void setBackgroundAndBorder(@NonNull BorderDrawable borderDrawable) {
        BaseWidget baseWidget = baseWidget2;
        BorderDrawable borderDrawable2 = baseWidget2.backgroundBorder = borderDrawable;
        Rect rect = new Rect(baseWidget2.borderBox);
        BaseWidget baseWidget2 = baseWidget2.borderBox;
        rect.offset(-((Rect)baseWidget2).left, -((Rect)baseWidget2).top);
        borderDrawable2.setBounds(rect);
        baseWidget.setCallback(borderDrawable2);
        baseWidget.invalidate();
    }

    @Override
    @NonNull
    public final Point getLocInFlatContainer() {
        return this.offsetOfContainer;
    }

    @Override
    @Nullable
    public final BorderDrawable getBackgroundAndBorder() {
        return this.backgroundBorder;
    }

    @Override
    @NonNull
    public final Rect getBorderBox() {
        return this.borderBox;
    }

    @Override
    public final void draw(@NonNull Canvas canvas) {
        BaseWidget baseWidget = this;
        Canvas canvas2 = canvas;
        canvas2.save();
        WXViewUtils.clipCanvasWithinBorderBox(baseWidget, canvas2);
        Object object = baseWidget.borderBox;
        canvas.translate((float)((Rect)object).left, (float)((Rect)object).top);
        object = this.backgroundBorder;
        if (object != null) {
            ((BorderDrawable)((Object)object)).draw(canvas);
        }
        Canvas canvas3 = canvas;
        BaseWidget baseWidget2 = this;
        int n = baseWidget2.leftOffset;
        BaseWidget baseWidget3 = this;
        n = baseWidget3.borderBox.width() - this.rightOffset;
        canvas.clipRect(n, baseWidget2.topOffset, n, baseWidget3.borderBox.height() - this.bottomOffset);
        canvas3.translate((float)this.leftOffset, (float)this.topOffset);
        this.onDraw(canvas3);
        canvas.restore();
    }

    protected void invalidate() {
        Rect rect;
        Rect rect2 = rect;
        rect2(this.borderBox);
        Point point = this.offsetOfContainer;
        int n = point.x;
        rect.offset(n, point.y);
        FlatGUIContext flatGUIContext = this.context;
        if (flatGUIContext != null && (this = flatGUIContext.getWidgetContainerView(this)) != null) {
            this.invalidate(rect2);
        }
    }

    protected void setCallback(@NonNull Drawable drawable2) {
        FlatGUIContext flatGUIContext = this.context;
        if (flatGUIContext != null && (this = flatGUIContext.getWidgetContainerView(this)) != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
    }
}

