/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.flat;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.flat.widget.AndroidViewWidget;
import com.taobao.weex.ui.flat.widget.Widget;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class FlatGUIContext
implements Destroyable {
    private Map<WXComponent, WidgetContainer> mWidgetRegistry;
    private Map<WXComponent, AndroidViewWidget> mViewWidgetRegistry;
    private Map<Widget, WXComponent> widgetToComponent;

    public FlatGUIContext() {
        ArrayMap arrayMap;
        ArrayMap arrayMap2;
        ArrayMap arrayMap3;
        FlatGUIContext flatGUIContext = arrayMap3;
        arrayMap3 = new ArrayMap();
        v1.mWidgetRegistry = flatGUIContext;
        flatGUIContext = arrayMap2;
        arrayMap2 = new ArrayMap();
        v1.mViewWidgetRegistry = flatGUIContext;
        flatGUIContext = arrayMap;
        arrayMap = new ArrayMap();
        v1.widgetToComponent = flatGUIContext;
    }

    @Nullable
    private WXComponent getComponent(@NonNull Widget widget) {
        return this.widgetToComponent.get(widget);
    }

    private boolean checkComponent(@NonNull WXComponent wXComponent) {
        boolean bl = false;
        if (wXComponent != null) {
            WXStyle wXStyle = wXComponent.getStyles();
            WXAttr wXAttr = wXComponent.getAttrs();
            if (wXStyle.containsKey("opacity") || wXStyle.containsKey("transform") || wXStyle.containsKey("visibility") || wXAttr.containsKey("elevation") || wXAttr.containsKey("ariaHidden") || wXAttr.containsKey("ariaLabel") || wXAttr.containsKey("fixedSize") || wXAttr.containsKey("disabled") || wXStyle.isFixed() || wXStyle.isSticky() || !wXStyle.getPesudoStyles().isEmpty() || ((AbstractCollection)wXComponent.getEvents()).size() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isFlatUIEnabled(WXComponent wXComponent) {
        return false;
    }

    public void register(@NonNull WXComponent wXComponent, @NonNull WidgetContainer widgetContainer) {
        if (!(widgetContainer instanceof FlatComponent) || ((FlatComponent)((Object)widgetContainer)).promoteToView(true)) {
            this.mWidgetRegistry.put(wXComponent, widgetContainer);
        }
    }

    public void register(@NonNull WXComponent wXComponent, @NonNull AndroidViewWidget androidViewWidget) {
        this.mViewWidgetRegistry.put(wXComponent, androidViewWidget);
    }

    public void register(@NonNull Widget widget, @NonNull WXComponent wXComponent) {
        this.widgetToComponent.put(widget, wXComponent);
    }

    @Nullable
    public WidgetContainer getFlatComponentAncestor(@NonNull WXComponent wXComponent) {
        return this.mWidgetRegistry.get(wXComponent);
    }

    @Nullable
    public AndroidViewWidget getAndroidViewWidget(@NonNull WXComponent wXComponent) {
        return this.mViewWidgetRegistry.get(wXComponent);
    }

    public boolean promoteToView(@NonNull WXComponent wXComponent, boolean bl, @NonNull Class<? extends WXComponent<?>> clazz) {
        return !this.isFlatUIEnabled(wXComponent) || !clazz.equals(wXComponent.getClass()) || TextUtils.equals((CharSequence)wXComponent.getRef(), (CharSequence)"_root") || bl && this.getFlatComponentAncestor(wXComponent) == null || this.checkComponent(wXComponent);
    }

    @Nullable
    public View getWidgetContainerView(Widget object) {
        View view = null;
        if ((object = ((FlatGUIContext)this).getComponent((Widget)object)) != null && (this = ((FlatGUIContext)this).getFlatComponentAncestor((WXComponent)object)) != null) {
            view = (View)((WXComponent)this).getHostView();
        }
        return view;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void destroy() {
        FlatGUIContext flatGUIContext = this;
        flatGUIContext.widgetToComponent.clear();
        Iterator<Map.Entry<WXComponent, Object>> iterator = flatGUIContext.mViewWidgetRegistry.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().destroy();
        }
        FlatGUIContext flatGUIContext2 = this;
        flatGUIContext2.mViewWidgetRegistry.clear();
        iterator = flatGUIContext2.mWidgetRegistry.entrySet().iterator();
        while (iterator.hasNext()) {
            ((WidgetContainer)iterator.next().getValue()).unmountFlatGUI();
        }
        this.mWidgetRegistry.clear();
    }
}

