/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXHeader;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.uniapp.dom.AbsAttr;
import java.util.LinkedList;

@Component(lazyload=false)
public class WXCell
extends WidgetContainer<WXFrameLayout> {
    private int mLastLocationY;
    private ViewGroup mRealView;
    private View mTempStickyView;
    private View mHeadView;
    private int mScrollPosition;
    private boolean mFlatUIEnabled;
    private Object renderData;
    private boolean isSourceUsed;
    private boolean isAppendTreeDone;
    private CellAppendTreeListener cellAppendTreeListener;

    @Deprecated
    public WXCell(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String string2, boolean bl, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        this.mLastLocationY = 0;
        this.mScrollPosition = -1;
        this.mFlatUIEnabled = false;
        this.isSourceUsed = false;
    }

    public WXCell(WXSDKInstance wXSDKInstance, WXVContainer object, boolean bl, BasicComponentData basicComponentData) {
        block7: {
            WXCell wXCell = this;
            super(wXSDKInstance, (WXVContainer)object, basicComponentData);
            wXCell.mLastLocationY = 0;
            wXCell.mScrollPosition = -1;
            wXCell.mFlatUIEnabled = false;
            wXCell.isSourceUsed = false;
            wXCell.lazy(true);
            wXCell.setContentBoxMeasurement(new ContentBoxMeasurement(){

                @Override
                public void measureInternal(float f, float f2, int n, int n2) {
                    if (n2 == 0) {
                        this.mMeasureHeight = 1.0f;
                    }
                }

                @Override
                public void layoutBefore() {
                }

                @Override
                public void layoutAfter(float f, float f2) {
                }
            });
            if (Build.VERSION.SDK_INT < 21) {
                object = this.getAttrs();
                if (!((AbsAttr)object).containsKey("flat")) break block7;
                try {
                    this.mFlatUIEnabled = WXUtils.getBoolean(((AbsAttr)object).get("flat"), Boolean.FALSE);
                }
                catch (NullPointerException nullPointerException) {
                    WXLogUtils.e("Cell", WXLogUtils.getStackTrace(nullPointerException));
                }
            }
        }
        if (!this.canRecycled()) {
            wXSDKInstance.getApmForInstance().updateDiffStats("wxCellDataUnRecycleCount", 1.0);
        }
        if (TextUtils.isEmpty((CharSequence)this.getAttrs().getScope())) {
            wXSDKInstance.getApmForInstance().updateDiffStats("wxCellUnReUseCount", 1.0);
        }
    }

    @Override
    public boolean isLazy() {
        return super.isLazy() && !this.isFixed();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFlatUIEnabled() {
        return this.mFlatUIEnabled;
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        WXFrameLayout wXFrameLayout;
        WXFrameLayout wXFrameLayout2;
        Object object;
        if (!((WXComponent)object).isSticky() && !(object instanceof WXHeader)) {
            WXFrameLayout wXFrameLayout3;
            WXCell wXCell = object;
            object = wXFrameLayout3;
            wXCell.mRealView = new WXFrameLayout(context);
            if (wXCell.isFlatUIEnabled()) {
                object.setLayerType(2, null);
            }
            return object;
        }
        WXCell wXCell = object;
        WXFrameLayout wXFrameLayout4 = wXFrameLayout2;
        WXCell wXCell2 = object;
        wXFrameLayout4(context);
        object = wXFrameLayout;
        wXCell2.mRealView = new WXFrameLayout(context);
        wXFrameLayout2.addView((View)object);
        if (wXCell.isFlatUIEnabled()) {
            wXFrameLayout4.setLayerType(2, null);
        }
        return wXFrameLayout4;
    }

    public int getLocationFromStart() {
        return this.mLastLocationY;
    }

    public void setLocationFromStart(int n) {
        this.mLastLocationY = n;
    }

    void setScrollPositon(int n) {
        this.mScrollPosition = n;
    }

    public int getScrollPositon() {
        return this.mScrollPosition;
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    public void removeSticky() {
        if (((WXFrameLayout)this.getHostView()).getChildCount() > 0) {
            FrameLayout.LayoutParams layoutParams;
            WXCell wXCell = this;
            wXCell.mHeadView = ((WXFrameLayout)wXCell.getHostView()).getChildAt(0);
            int[] nArray = new int[2];
            WXCell wXCell2 = this;
            int[] nArray2 = new int[2];
            ((WXFrameLayout)wXCell2.getHostView()).getLocationOnScreen(nArray);
            wXCell2.getParentScroller().getView().getLocationOnScreen(nArray2);
            int n = nArray[0] - nArray2[0];
            int n2 = wXCell.getParent().getHostView().getTop();
            ((WXFrameLayout)wXCell.getHostView()).removeView(this.mHeadView);
            wXCell.mRealView = (ViewGroup)wXCell.mHeadView;
            wXCell.mTempStickyView = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams layoutParams2 = layoutParams;
            layoutParams = new FrameLayout.LayoutParams((int)this.getLayoutWidth(), (int)this.getLayoutHeight());
            ((WXFrameLayout)wXCell.getHostView()).addView(this.mTempStickyView, (ViewGroup.LayoutParams)layoutParams2);
            wXCell.mHeadView.setTranslationX((float)n);
            wXCell.mHeadView.setTranslationY((float)n2);
        }
    }

    public void recoverySticky() {
        View view = this.mHeadView;
        if (view != null) {
            if (view.getLayoutParams() != null) {
                view = (ViewGroup.MarginLayoutParams)this.mHeadView.getLayoutParams();
                if (view.topMargin > 0) {
                    view.topMargin = 0;
                }
            }
            if (this.mHeadView.getVisibility() != 0) {
                this.mHeadView.setVisibility(0);
            }
            if (this.mHeadView.getParent() != null) {
                ((ViewGroup)this.mHeadView.getParent()).removeView(this.mHeadView);
            }
            WXCell wXCell = this;
            ((WXFrameLayout)wXCell.getHostView()).removeView(this.mTempStickyView);
            ((WXFrameLayout)wXCell.getHostView()).addView(this.mHeadView);
            wXCell.mHeadView.setTranslationX(0.0f);
            wXCell.mHeadView.setTranslationY(0.0f);
        }
    }

    @Override
    protected void mountFlatGUI() {
        if (this.getHostView() != null) {
            if (this.widgets == null) {
                LinkedList<Widget> linkedList;
                LinkedList<Widget> linkedList2 = linkedList;
                linkedList = new LinkedList<Widget>();
                this.widgets = linkedList2;
            }
            ((WXFrameLayout)this.getHostView()).mountFlatGUI(this.widgets);
        }
    }

    @Override
    public void unmountFlatGUI() {
        if (this.getHostView() != null) {
            ((WXFrameLayout)this.getHostView()).unmountFlatGUI();
        }
    }

    @Override
    public boolean intendToBeFlatContainer() {
        return this.getInstance().getFlatUIContext().isFlatUIEnabled(this) && WXCell.class.equals(this.getClass()) && !this.isSticky();
    }

    @Override
    public int getStickyOffset() {
        if (this.getAttrs().get("stickyOffset") == null) {
            return 0;
        }
        return (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(this.getAttrs().get("stickyOffset")), this.getViewPortWidthForFloat());
    }

    public Object getRenderData() {
        return this.renderData;
    }

    public void setRenderData(Object object) {
        this.renderData = object;
    }

    public boolean isSourceUsed() {
        return this.isSourceUsed;
    }

    public void setSourceUsed(boolean bl) {
        this.isSourceUsed = bl;
    }

    public boolean isAppendTreeDone() {
        return this.isAppendTreeDone;
    }

    @Override
    public void appendTreeCreateFinish() {
        WXCell wXCell = cellAppendTreeListener;
        super.appendTreeCreateFinish();
        wXCell.isAppendTreeDone = true;
        CellAppendTreeListener cellAppendTreeListener = wXCell.cellAppendTreeListener;
        if (cellAppendTreeListener != null) {
            cellAppendTreeListener.onAppendTreeDone();
        }
    }

    public void setCellAppendTreeListener(CellAppendTreeListener cellAppendTreeListener) {
        this.cellAppendTreeListener = cellAppendTreeListener;
        if (this.isAppendTreeDone) {
            cellAppendTreeListener.onAppendTreeDone();
        }
    }

    @Override
    public void createViewImpl() {
        if (this.getRealView() != null && this.getRealView().getParent() != null) {
            return;
        }
        super.createViewImpl();
    }

    public static interface CellAppendTreeListener {
        public void onAppendTreeDone();
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
            return new WXCell(wXSDKInstance, wXVContainer, true, basicComponentData);
        }
    }
}

