/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.utils.WXViewUtils;

public class GapItemDecoration
extends RecyclerView.ItemDecoration {
    private WXListComponent listComponent;

    public GapItemDecoration(WXListComponent wXListComponent) {
        this.listComponent = wXListComponent;
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State floatArray) {
        floatArray = this.listComponent.getSpanOffsets();
        if (floatArray == null) {
            return;
        }
        int n = recyclerView.getChildAdapterPosition(view);
        if (n < 0) {
            return;
        }
        if (view.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            if ((view = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).isFullSpan()) {
                return;
            }
            IWXObject iWXObject = this.listComponent.getListChild(n);
            if (iWXObject instanceof WXCell) {
                if (!((WXComponent)(iWXObject = (WXCell)iWXObject)).isFixed() && !((WXComponent)iWXObject).isSticky()) {
                    if (view.getSpanIndex() >= floatArray.length) {
                        return;
                    }
                    int n2 = this.listComponent.isLayoutRTL() ? floatArray.length - view.getSpanIndex() - 1 : view.getSpanIndex();
                    GapItemDecoration gapItemDecoration = this;
                    int n3 = Math.round(WXViewUtils.getRealPxByWidth(gapItemDecoration.listComponent.getSpanOffsets()[n2].floatValue(), this.listComponent.getViewPortWidthForFloat()));
                    if (gapItemDecoration.listComponent.isLayoutRTL()) {
                        rect.left = -n3;
                        rect.right = n3;
                    } else {
                        rect.left = n3;
                        rect.right = -n3;
                    }
                } else {
                    return;
                }
            }
        }
    }
}

