/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Paint;
import android.text.Editable;
import android.text.InputFilter;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.core.ui.DCKeyboardManager;
import io.dcloud.common.core.ui.keyboard.DCEditText;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.dom.AbsStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DCWXInput
extends WXComponent<WXEditText> {
    private static final int MAX_TEXT_FORMAT_REPEAT = 3;
    private final InputMethodManager mInputMethodManager;
    private String mBeforeText = "";
    protected String mType = "text";
    private boolean isPassword = false;
    private int mEditorAction = 6;
    private String mReturnKeyType = null;
    private List<TextView.OnEditorActionListener> mEditorActionListeners;
    private boolean mListeningConfirm = false;
    private boolean mIgnoreNextOnInputEvent = false;
    private TextFormatter mFormatter = null;
    private List<TextWatcher> mTextChangedListeners;
    private TextWatcher mTextChangedEventDispatcher;
    private int mFormatRepeatCount = 0;
    private TextPaint mPaint;
    private int mLineHeight;
    final String ADJUST_POSITION;
    final String PASSWORD;
    float keyboardHeight;
    boolean isConfirmHold;
    public boolean isNeedConfirm;
    private int cursor;
    private String placeholderTextAlign;
    private int selectionStart;
    private int selectionEnd;
    private String textAlign;
    private JSONObject placeholderStyle;
    private float measureHeight;
    private float measureWidht;
    private WXComponent.OnFocusChangeListener mOnFocusChangeListener;
    private BroadcastReceiver mTypefaceObserver;
    private String mFontFamily;
    private AtomicBoolean isLayoutFinished;
    private WXSDKInstance.FrameViewEventListener mFrameViewEventListener;

    public DCWXInput(WXSDKInstance object, WXVContainer wXVContainer, boolean bl, BasicComponentData basicComponentData) {
        super((WXSDKInstance)object, wXVContainer, bl, basicComponentData);
        ContentBoxMeasurement contentBoxMeasurement;
        AtomicBoolean atomicBoolean;
        WXComponent.OnFocusChangeListener onFocusChangeListener;
        JSONObject jSONObject;
        TextPaint textPaint;
        object = textPaint;
        textPaint = new TextPaint();
        this.mPaint = object;
        this.mLineHeight = -1;
        this.ADJUST_POSITION = "adjustPosition";
        this.PASSWORD = "password";
        this.keyboardHeight = 0.0f;
        this.isConfirmHold = false;
        this.isNeedConfirm = true;
        this.cursor = -1;
        this.selectionStart = Integer.MAX_VALUE;
        this.selectionEnd = Integer.MAX_VALUE;
        this.textAlign = "left";
        object = jSONObject;
        jSONObject = new JSONObject();
        this.placeholderStyle = object;
        this.measureHeight = -1.0f;
        this.measureWidht = -1.0f;
        object = onFocusChangeListener;
        onFocusChangeListener = new WXComponent.OnFocusChangeListener(){
            int count = 0;

            private void fireEventForFocus(final TextView textView) {
                ((WXEditText)DCWXInput.this.getHostView()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Object object = this;
                        if (object.DCWXInput.this.keyboardHeight == 0.0f) {
                            if (++object.count > 3) {
                                HashMap<String, Object> hashMap;
                                HashMap hashMap2;
                                object = hashMap2;
                                hashMap2 = new HashMap(1);
                                HashMap<String, Object> hashMap3 = hashMap;
                                hashMap3(1);
                                hashMap3.put("value", textView.getText().toString());
                                hashMap.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                                hashMap2.put("detail", hashMap3);
                                DCWXInput.this.fireEvent("focus", (Map<String, Object>)object);
                                return;
                            }
                            (object).fireEventForFocus(textView);
                        } else {
                            HashMap<String, Object> hashMap;
                            HashMap hashMap4;
                            object.count = 0;
                            object = hashMap4;
                            hashMap4 = new HashMap(1);
                            HashMap<String, Object> hashMap5 = hashMap;
                            hashMap5(1);
                            hashMap5.put("value", textView.getText().toString());
                            hashMap.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                            hashMap4.put("detail", hashMap5);
                            DCWXInput.this.fireEvent("focus", (Map<String, Object>)object);
                        }
                    }
                }, 200L);
            }

            @Override
            public void onFocusChange(boolean bl) {
                HashMap<String, Object> hashMap;
                HashMap<String, Object> hashMap2;
                TextView textView = (TextView)DCWXInput.this.getHostView();
                if (textView == null) {
                    return;
                }
                HashMap<String, Object> hashMap3 = hashMap2;
                hashMap2 = new HashMap<String, Object>(1);
                HashMap<String, Object> hashMap4 = hashMap;
                hashMap4(1);
                hashMap.put("value", textView.getText().toString());
                if (bl) {
                    float f = DCWXInput.this.keyboardHeight;
                    if (f == 0.0f) {
                        this.fireEventForFocus(textView);
                    } else {
                        hashMap4.put("height", Float.valueOf(f));
                        hashMap4.put("value", textView.getText().toString());
                        hashMap3.put("detail", hashMap4);
                        DCWXInput.this.fireEvent("focus", hashMap3);
                    }
                } else {
                    hashMap3.put("detail", hashMap4);
                    DCWXInput.this.fireEvent("blur", hashMap3);
                }
            }
        };
        this.mOnFocusChangeListener = object;
        object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.isLayoutFinished = object;
        this.interceptFocusAndBlurEvent();
        this.mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        object = contentBoxMeasurement;
        contentBoxMeasurement = new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float f, float f2, int n, int n2) {
                if (DCWXInput.this.getBasicComponentData().getStyles() == null || DCWXInput.this.getBasicComponentData().getStyles().size() == 0) {
                    DCWXInput.access$002(DCWXInput.this, f);
                }
                if (CSSConstants.isUndefined(f2)) {
                    float f3;
                    1 v0 = this;
                    v0.mMeasureHeight = f3 = WXViewUtils.getRealPxByWidth((float)v0.DCWXInput.this.getInstance().getDefaultFontSize() * 1.4f, DCWXInput.this.getInstance().getInstanceViewPortWidthWithFloat());
                    DCWXInput.access$102(v0.DCWXInput.this, f3);
                }
            }

            @Override
            public void layoutBefore() {
                DCWXInput.this.updateStyleAndAttrs();
            }

            @Override
            public void layoutAfter(float f, float f2) {
            }
        };
        this.setContentBoxMeasurement((ContentBoxMeasurement)object);
    }

    private void updateStyleAndAttrs() {
        if (this.getStyles().size() > 0) {
            int n;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            String string2 = null;
            if (this.getStyles().containsKey("fontSize")) {
                n2 = AbsStyle.getFontSize(this.getStyles(), this.getInstance().getDefaultFontSize(), this.getViewPortWidth());
            }
            if (this.getStyles().containsKey("fontFamily")) {
                string2 = AbsStyle.getFontFamily(this.getStyles());
            }
            if (this.getStyles().containsKey("fontStyle")) {
                n3 = AbsStyle.getFontStyle(this.getStyles());
            }
            if (this.getStyles().containsKey("fontWeight")) {
                n4 = AbsStyle.getFontWeight(this.getStyles());
            }
            if ((n = AbsStyle.getLineHeight(this.getStyles(), this.getViewPortWidth())) != -1) {
                this.mLineHeight = n;
            }
            if (n2 != -1) {
                this.mPaint.setTextSize((float)n2);
            }
            if (string2 != null) {
                TypefaceUtil.applyFontStyle((Paint)this.mPaint, n3, n4, string2);
            }
        }
    }

    private void addEditorChangeListener() {
        TextView.OnEditorActionListener onEditorActionListener;
        TextView.OnEditorActionListener onEditorActionListener2 = onEditorActionListener;
        onEditorActionListener = new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                if (object.DCWXInput.this.mListeningConfirm && n == object.DCWXInput.this.mEditorAction) {
                    HashMap<String, String> hashMap;
                    HashMap hashMap2;
                    3 v0 = object;
                    Object object = hashMap2;
                    hashMap2 = new HashMap(1);
                    HashMap<String, String> hashMap3 = hashMap;
                    hashMap3(1);
                    hashMap.put("value", textView.getText().toString());
                    hashMap2.put("detail", hashMap3);
                    v0.DCWXInput.this.fireEvent("confirm", (Map<String, Object>)object);
                    object = v0.DCWXInput.this;
                    if (!((DCWXInput)object).isConfirmHold) {
                        ((DCWXInput)object).blur();
                    }
                    return true;
                }
                return object.DCWXInput.this.isConfirmHold;
            }
        };
        this.addEditorActionListener(onEditorActionListener2);
    }

    private void registerTypefaceObserver(String string2) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = string2;
        if (this.mTypefaceObserver != null) {
            return;
        }
        this.mTypefaceObserver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getStringExtra("fontFamily");
                if (!DCWXInput.this.mFontFamily.equals(object)) {
                    return;
                }
                if ((object = TypefaceUtil.getFontDO((String)object)) != null && ((FontDO)object).getTypeface() != null && DCWXInput.this.getHostView() != null) {
                    ((WXEditText)DCWXInput.this.getHostView()).setTypeface(((FontDO)object).getTypeface());
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter("type_face_available"));
    }

    private void hostViewFocus(EditText editText) {
        EditText editText2 = editText;
        editText2.setFocusable(true);
        editText2.setFocusableInTouchMode(true);
        editText2.setCursorVisible(true);
        editText2.requestFocus();
        this.showSoftKeyboard();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getInputType(String string2) {
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1793702779: {
                if (!string2.equals("datetime")) break;
                n = 9;
                break;
            }
            case 1216985755: {
                if (!string2.equals("password")) break;
                n = 8;
                break;
            }
            case 96619420: {
                if (!string2.equals("email")) break;
                n = 7;
                break;
            }
            case 95582509: {
                if (!string2.equals("digit")) break;
                n = 6;
                break;
            }
            case 3560141: {
                if (!string2.equals("time")) break;
                n = 5;
                break;
            }
            case 3556653: {
                if (!string2.equals("text")) break;
                n = 4;
                break;
            }
            case 3076014: {
                if (!string2.equals("date")) break;
                n = 3;
                break;
            }
            case 116079: {
                if (!string2.equals("url")) break;
                n = 2;
                break;
            }
            case 114715: {
                if (!string2.equals("tel")) break;
                n = 1;
                break;
            }
            case -1034364087: {
                if (!string2.equals("number")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return 1;
            }
            case 9: {
                return 4;
            }
            case 8: {
                int n2 = 129;
                if (this.getHostView() == null) return n2;
                ((WXEditText)this.getHostView()).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                return n2;
            }
            case 7: {
                return 33;
            }
            case 6: {
                return 8194;
            }
            case 5: {
                int n2 = 0;
                if (this.getHostView() == null) return n2;
                ((WXEditText)this.getHostView()).setFocusable(false);
                return n2;
            }
            case 3: {
                int n3 = 0;
                ((WXEditText)this.getHostView()).setFocusable(false);
                return n3;
            }
            case 2: {
                return 17;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 2;
            }
        }
    }

    private void showSoftKeyboard() {
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    DCWXInput.this.mInputMethodManager.showSoftInput(DCWXInput.this.getHostView(), 1);
                }
            }), 100L);
        }
    }

    private int getTextAlign(String string2) {
        int n = this.isLayoutRTL() ? 0x800005 : 0x800003;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return n;
        }
        String string3 = string2;
        string3.hashCode();
        int n2 = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 108511772: {
                if (!string2.equals("right")) break;
                n2 = 2;
                break;
            }
            case 3317767: {
                if (!string2.equals("left")) break;
                n2 = 1;
                break;
            }
            case -1364013995: {
                if (!string2.equals("center")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                n = 0x800005;
                break;
            }
            case 1: {
                n = 0x800003;
                break;
            }
            case 0: {
                n = 17;
            }
        }
        return n;
    }

    private void decideSoftKeyboard() {
        Context context;
        Object t = this.getHostView();
        if (t != null && (context = this.getContext()) instanceof Activity) {
            t.postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    View view = ((Activity)context).getCurrentFocus();
                    if (view != null && !(view instanceof EditText) && !view.isFocused()) {
                        DCWXInput.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)DCWXInput.this.getHostView()).getWindowToken(), 0);
                    }
                }
            }), 16L);
        }
    }

    private void setSelectionRange(int n, int n2) {
        EditText editText;
        if (n2 != Integer.MAX_VALUE && n != Integer.MAX_VALUE && (editText = (EditText)this.getHostView()) != null) {
            int n3 = ((WXEditText)this.getHostView()).length();
            if (n > n2) {
                return;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            editText.setSelection(n, n2);
        }
    }

    private final void addEditorActionListener(TextView.OnEditorActionListener onEditorActionListener) {
        Object object;
        if (onEditorActionListener != null && (object = (TextView)this.getHostView()) != null) {
            if (this.mEditorActionListeners == null) {
                TextView.OnEditorActionListener onEditorActionListener2;
                ArrayList arrayList;
                TextView textView = object;
                object = arrayList;
                arrayList = new ArrayList();
                this.mEditorActionListeners = object;
                object = onEditorActionListener2;
                onEditorActionListener2 = new TextView.OnEditorActionListener(){
                    private boolean handled = true;

                    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                        for (TextView.OnEditorActionListener onEditorActionListener : DCWXInput.this.mEditorActionListeners) {
                            if (onEditorActionListener == null) continue;
                            this.handled &= onEditorActionListener.onEditorAction(textView, n, keyEvent);
                        }
                        return this.handled;
                    }
                };
                textView.setOnEditorActionListener((TextView.OnEditorActionListener)object);
            }
            this.mEditorActionListeners.add(onEditorActionListener);
        }
    }

    private void addKeyboardListener(final WXEditText wXEditText) {
        if (wXEditText == null) {
            return;
        }
        if (wXEditText.getContext() instanceof Activity) {
            ((WXEditText)this.getHostView()).setkeyBoardHeightChangeListener(new DCEditText.OnKeyboardHeightChangeListener(){

                public void onChange(boolean bl, int n) {
                    if (DCWXInput.this.getInstance() != null && !DCWXInput.this.getInstance().isDestroy() && wXEditText != null) {
                        HashMap<String, Object> hashMap;
                        HashMap<String, Number> hashMap2;
                        14 v0 = this;
                        v0.DCWXInput.this.keyboardHeight = (int)WXViewUtils.getWebPxByWidth((float)n, v0.DCWXInput.this.getInstance().getInstanceViewPortWidthWithFloat());
                        Object object = hashMap2;
                        ((HashMap)object)(2);
                        hashMap2.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                        hashMap2.put("duration", 0);
                        HashMap<String, Object> hashMap3 = hashMap;
                        new HashMap<String, Object>(1).put("detail", object);
                        v0.DCWXInput.this.fireEvent("keyboardheightchange", hashMap3);
                        if (v0.wXEditText.isFocused()) {
                            object = DCWXInput.this.isPassword ? "password" : DCWXInput.this.mType;
                            if (!(bl || DCWXInput.this.isConfirmHold || ((String)object).equalsIgnoreCase("password") || DCKeyboardManager.getInstance().getFrontInputType().equals("password"))) {
                                DCWXInput.this.blur();
                            }
                            if (bl) {
                                DCKeyboardManager.getInstance().setFrontInputType((String)object);
                            }
                        }
                        if (bl) {
                            DCWXInput.this.keyboardHeight = DCWXInput.this.keyboardHeight;
                        }
                        return;
                    }
                }
            });
        }
    }

    private PatternWrapper parseToPattern(String string2, String string3) {
        if (string2 != null && string3 != null) {
            if (!Pattern.compile("/[\\S]+/[i]?[m]?[g]?").matcher(string2).matches()) {
                WXLogUtils.w("WXInput", "Illegal js pattern syntax: " + string2);
                return null;
            }
            String string4 = string2;
            int n = 0;
            String string5 = string4.substring(string4.lastIndexOf("/") + 1);
            String string6 = string2;
            int n2 = string6.indexOf("/") + 1;
            String string7 = string6.substring(n2, string6.lastIndexOf("/"));
            if (string5.contains("i")) {
                n = 2;
            }
            if (string5.contains("m")) {
                n |= 0x20;
            }
            boolean bl = string5.contains("g");
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(string7, n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                WXLogUtils.w("WXInput", "Pattern syntax error: " + string7);
            }
            if (pattern == null) {
                return null;
            }
            PatternWrapper patternWrapper = new PatternWrapper();
            PatternWrapper.access$2702(patternWrapper, bl);
            PatternWrapper.access$2802(patternWrapper, pattern);
            PatternWrapper.access$2902(patternWrapper, string3);
            return patternWrapper;
        }
        return null;
    }

    static /* synthetic */ float access$002(DCWXInput dCWXInput, float f) {
        dCWXInput.measureWidht = f;
        return f;
    }

    static /* synthetic */ float access$102(DCWXInput dCWXInput, float f) {
        dCWXInput.measureHeight = f;
        return f;
    }

    static /* synthetic */ int access$1102(DCWXInput dCWXInput, int n) {
        dCWXInput.mFormatRepeatCount = n;
        return n;
    }

    static /* synthetic */ boolean access$1202(DCWXInput dCWXInput, boolean bl) {
        dCWXInput.mIgnoreNextOnInputEvent = bl;
        return bl;
    }

    static /* synthetic */ String access$1302(DCWXInput dCWXInput, String string2) {
        dCWXInput.mBeforeText = string2;
        return string2;
    }

    static /* synthetic */ WXSDKInstance.FrameViewEventListener access$2102(DCWXInput dCWXInput, WXSDKInstance.FrameViewEventListener frameViewEventListener) {
        dCWXInput.mFrameViewEventListener = frameViewEventListener;
        return frameViewEventListener;
    }

    @Override
    protected void setHostLayoutParams(WXEditText wXEditText, int n, int n2, int n3, int n4, int n5, int n6) {
        super.setHostLayoutParams(wXEditText, n, n2, n3, n4, n5, n6);
    }

    @Override
    protected void setLayoutSize(GraphicSize graphicSize) {
        super.setLayoutSize(graphicSize);
    }

    @Override
    protected void layoutDirectionDidChanged(boolean n) {
        DCWXInput dCWXInput = this;
        n = dCWXInput.getTextAlign((String)dCWXInput.getStyles().get("textAlign"));
        if (n <= 0) {
            n = 0x800003;
        }
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).setGravity(n | this.getVerticalGravity());
        }
    }

    final float getMeasuredLineHeight() {
        int n = this.mLineHeight;
        return n != -1 && n > 0 ? (float)n : this.mPaint.getFontMetrics(null);
    }

    protected float getMeasureHeight() {
        return WXViewUtils.getRealPxByWidth(this.getMeasuredLineHeight() < 50.0f ? 50.0f : this.getMeasureHeight(), this.getInstance().getInstanceViewPortWidthWithFloat());
    }

    @Override
    protected WXEditText initComponentHostView(@NonNull Context context) {
        WXEditText wXEditText;
        WXEditText wXEditText2 = wXEditText;
        wXEditText2(context, this.getInstanceId());
        this.appleStyleAfterCreated(wXEditText2);
        wXEditText.setImeOptions(6);
        return wXEditText;
    }

    @Override
    protected void onHostViewInitialized(WXEditText wXEditText) {
        float f;
        String string2;
        String string3;
        DCWXInput dCWXInput = this;
        super.onHostViewInitialized(wXEditText);
        if (dCWXInput.measureWidht > 0.0f) {
            DCWXInput dCWXInput2 = this;
            string3 = dCWXInput2.getInstanceId();
            string2 = dCWXInput2.getRef();
            f = dCWXInput2.measureWidht;
            WXBridgeManager.getInstance().setStyleWidth(string3, string2, f);
        }
        if (this.measureHeight > 0.0f) {
            DCWXInput dCWXInput3 = this;
            string3 = dCWXInput3.getInstanceId();
            string2 = dCWXInput3.getRef();
            f = dCWXInput3.measureHeight;
            WXBridgeManager.getInstance().setStyleHeight(string3, string2, f);
        }
        DCWXInput dCWXInput4 = this;
        this.addFocusChangeListener(new WXComponent.OnFocusChangeListener(){

            @Override
            public void onFocusChange(boolean bl) {
                String string2;
                DCWXInput dCWXInput;
                int n;
                if (!bl) {
                    DCWXInput.this.decideSoftKeyboard();
                }
                DCWXInput.this.setPseudoClassStatus(":focus", bl);
                if (bl) {
                    DCWXInput dCWXInput2 = DCWXInput.this;
                    dCWXInput2.setTextAlign(dCWXInput2.textAlign);
                } else if (DCWXInput.this.getHostView() != null && PdrUtil.isEmpty((Object)((WXEditText)DCWXInput.this.getHostView()).getText().toString()) && (n = dCWXInput.getTextAlign(string2 = (dCWXInput = DCWXInput.this).placeholderTextAlign == null ? DCWXInput.this.textAlign : DCWXInput.this.placeholderTextAlign)) > 0) {
                    ((WXEditText)DCWXInput.this.getHostView()).setGravity(n | DCWXInput.this.getVerticalGravity());
                }
            }
        });
        dCWXInput4.addKeyboardListener(wXEditText);
        if (dCWXInput4.isNeedConfirm) {
            this.addEditorChangeListener();
        }
    }

    @Override
    protected boolean isConsumeTouch() {
        return this.isDisabled() ^ true;
    }

    protected int getVerticalGravity() {
        return 16;
    }

    protected void appleStyleAfterCreated(final WXEditText wXEditText) {
        TextWatcher textWatcher;
        DCWXInput dCWXInput = this;
        int n = dCWXInput.getTextAlign((String)dCWXInput.getStyles().get("textAlign"));
        if (n <= 0) {
            n = 0x800003;
        }
        wXEditText.setGravity(n | this.getVerticalGravity());
        n = WXResourceUtils.getColor("#999999");
        if (n != Integer.MIN_VALUE) {
            wXEditText.setHintTextColor(n);
        }
        WXEditText wXEditText2 = wXEditText;
        TextWatcher textWatcher2 = textWatcher;
        this.mTextChangedEventDispatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                if (iterator.DCWXInput.this.mTextChangedListeners != null) {
                    Iterator iterator = iterator.DCWXInput.this.mTextChangedListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TextWatcher)iterator.next()).beforeTextChanged(charSequence, n, n2, n3);
                    }
                }
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                if (iterator.DCWXInput.this.mFormatter != null) {
                    4 v0 = iterator;
                    String string2 = v0.DCWXInput.this.mFormatter.recover(charSequence.toString());
                    string2 = v0.DCWXInput.this.mFormatter.format(string2);
                    if (!string2.equals(charSequence.toString()) && iterator.DCWXInput.this.mFormatRepeatCount < 3) {
                        Iterator iterator = iterator;
                        DCWXInput dCWXInput = iterator.DCWXInput.this;
                        DCWXInput.access$1102(dCWXInput, dCWXInput.mFormatRepeatCount + 1);
                        n = iterator.wXEditText.getSelectionStart();
                        int n4 = iterator.DCWXInput.this.mFormatter.format(iterator.DCWXInput.this.mFormatter.recover(charSequence.subSequence(0, n).toString())).length();
                        iterator.wXEditText.setText(string2);
                        iterator.wXEditText.setSelection(n4);
                        return;
                    }
                    DCWXInput.access$1102(iterator.DCWXInput.this, 0);
                }
                if (iterator.DCWXInput.this.mTextChangedListeners != null) {
                    Iterator iterator = iterator.DCWXInput.this.mTextChangedListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TextWatcher)iterator.next()).onTextChanged(charSequence, n, n2, n3);
                    }
                }
            }

            public void afterTextChanged(Editable editable) {
                if (iterator.DCWXInput.this.mTextChangedListeners != null) {
                    Iterator iterator = iterator.DCWXInput.this.mTextChangedListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TextWatcher)iterator.next()).afterTextChanged(editable);
                    }
                }
            }
        };
        wXEditText.addTextChangedListener(textWatcher2);
        wXEditText2.setTextSize(0, AbsStyle.getFontSize(this.getStyles(), this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()));
        wXEditText2.setSingleLine(true);
    }

    @Override
    public void addEvent(String string2) {
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)string2)) {
            if (string2.equals("input")) {
                TextWatcher textWatcher;
                TextWatcher textWatcher2 = textWatcher;
                textWatcher = new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                        HashMap<String, Object> hashMap;
                        HashMap<String, Object> hashMap2;
                        block8: {
                            int n4;
                            String string2;
                            HashMap<String, Object> hashMap3;
                            Integer n5;
                            HashMap<String, Object> hashMap4;
                            HashMap<String, Object> hashMap5;
                            if (DCWXInput.this.mIgnoreNextOnInputEvent) {
                                5 v0 = this;
                                DCWXInput.access$1202(v0.DCWXInput.this, false);
                                DCWXInput.access$1302(v0.DCWXInput.this, charSequence.toString());
                                return;
                            }
                            hashMap2 = hashMap5;
                            hashMap5 = new HashMap<String, Object>(1);
                            hashMap = hashMap4;
                            hashMap(3);
                            hashMap.put("value", charSequence.toString());
                            hashMap4.put("cursor", ((WXEditText)DCWXInput.this.getHostView()).getSelectionEnd());
                            if (n2 == 0 && n3 != 0) {
                                int n6 = n;
                                String string3 = charSequence.subSequence(n6, n6 + n3).toString();
                                String string4 = "keyCode";
                                n5 = hashMap.put(string4, Character.codePointAt(string3, string3.length() - 1));
                                break block8;
                            }
                            if (n2 == 0 || n3 != 0) break block8;
                            try {
                                hashMap3 = hashMap;
                                string2 = DCWXInput.this.mBeforeText;
                                n4 = n;
                            }
                            catch (Exception exception) {}
                            String string5 = string2.subSequence(n4, n4 + n2).toString();
                            String string6 = string5;
                            String string7 = "keyCode";
                            int n7 = string5.length();
                            n5 = hashMap3.put(string7, Character.codePointAt(string6, n7 - 1));
                            break block8;
                            hashMap.put("keyCode", "0");
                        }
                        DCWXInput.access$1302(DCWXInput.this, charSequence.toString());
                        hashMap2.put("detail", hashMap);
                        DCWXInput.this.fireEvent("input", hashMap2);
                    }

                    public void afterTextChanged(Editable editable) {
                    }
                };
                this.addTextChangedListener(textWatcher2);
            }
            if ("confirm".equals(string2)) {
                this.mListeningConfirm = true;
            }
            if ("focus".equals(string2) || "blur".equals(string2)) {
                this.setFocusAndBlur();
            }
            super.addEvent(string2);
            return;
        }
    }

    protected void setFocusAndBlur() {
        DCWXInput dCWXInput = this;
        if (!dCWXInput.ismHasFocusChangeListener(dCWXInput.mOnFocusChangeListener)) {
            DCWXInput dCWXInput2 = this;
            dCWXInput2.addFocusChangeListener(dCWXInput2.mOnFocusChangeListener);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setProperty(String object, Object object2) {
        int n;
        block76: {
            int n2;
            ((String)object).hashCode();
            n = -1;
            int n3 = -1;
            switch (((String)object).hashCode()) {
                case 1638055017: {
                    if (!((String)object).equals("autoFocus")) break;
                    n3 = 1;
                    break;
                }
                case 1625554645: {
                    if (!((String)object).equals("allowCopyPaste")) break;
                    n3 = 2;
                    break;
                }
                case 947486441: {
                    if (!((String)object).equals("returnKeyType")) break;
                    n3 = 3;
                    break;
                }
                case 914346044: {
                    if (!((String)object).equals("singleline")) break;
                    n3 = 4;
                    break;
                }
                case 598246771: {
                    if (!((String)object).equals("placeholder")) break;
                    n3 = 5;
                    break;
                }
                case 365601008: {
                    if (!((String)object).equals("fontSize")) break;
                    n3 = 6;
                    break;
                }
                case 344059807: {
                    if (!((String)object).equals("confirmHold")) break;
                    n3 = 7;
                    break;
                }
                case 270940796: {
                    if (!((String)object).equals("disabled")) break;
                    n3 = 8;
                    break;
                }
                case 124732746: {
                    if (!((String)object).equals("maxlength")) break;
                    n3 = 9;
                    break;
                }
                case 102977279: {
                    if (!((String)object).equals("lines")) break;
                    n3 = 10;
                    break;
                }
                case 97604824: {
                    if (!((String)object).equals("focus")) break;
                    n3 = 11;
                    break;
                }
                case 94842723: {
                    if (!((String)object).equals("color")) break;
                    n3 = 12;
                    break;
                }
                case 108114: {
                    if (!((String)object).equals("min")) break;
                    n3 = 13;
                    break;
                }
                case 107876: {
                    if (!((String)object).equals("max")) break;
                    n3 = 14;
                    break;
                }
                case -791400086: {
                    if (!((String)object).equals("maxLength")) break;
                    n3 = 15;
                    break;
                }
                case -1065511464: {
                    if (!((String)object).equals("textAlign")) break;
                    n3 = 16;
                    break;
                }
                case -1224696685: {
                    if (!((String)object).equals("fontFamily")) break;
                    n3 = 17;
                    break;
                }
                case -1349119146: {
                    if (!((String)object).equals("cursor")) break;
                    n3 = 18;
                    break;
                }
                case -1576785488: {
                    if (!((String)object).equals("placeholderColor")) break;
                    n3 = 19;
                    break;
                }
                case -1629051985: {
                    if (!((String)object).equals("selectionEnd")) break;
                    n3 = 20;
                    break;
                }
                case -1898657397: {
                    if (!((String)object).equals("keepSelectionIndex")) break;
                    n3 = 21;
                    break;
                }
                case -2137753034: {
                    if (!((String)object).equals("selectionStart")) break;
                    n3 = 22;
                    break;
                }
            }
            switch (n3) {
                default: {
                    break block76;
                }
                case 1: {
                    n2 = 21;
                    break;
                }
                case 2: {
                    n2 = 20;
                    break;
                }
                case 3: {
                    n2 = 19;
                    break;
                }
                case 4: {
                    n2 = 18;
                    break;
                }
                case 5: {
                    n2 = 17;
                    break;
                }
                case 6: {
                    n2 = 16;
                    break;
                }
                case 7: {
                    n2 = 15;
                    break;
                }
                case 8: {
                    n2 = 14;
                    break;
                }
                case 9: {
                    n2 = 13;
                    break;
                }
                case 10: {
                    n2 = 12;
                    break;
                }
                case 11: {
                    n2 = 11;
                    break;
                }
                case 12: {
                    n2 = 10;
                    break;
                }
                case 13: {
                    n2 = 9;
                    break;
                }
                case 14: {
                    n2 = 8;
                    break;
                }
                case 15: {
                    n2 = 7;
                    break;
                }
                case 16: {
                    n2 = 6;
                    break;
                }
                case 17: {
                    n2 = 5;
                    break;
                }
                case 18: {
                    n2 = 4;
                    break;
                }
                case 19: {
                    n2 = 3;
                    break;
                }
                case 20: {
                    n2 = 2;
                    break;
                }
                case 21: {
                    n2 = 1;
                    break;
                }
                case 22: {
                    n2 = 0;
                }
            }
            n = n2;
        }
        switch (n) {
            default: {
                return super.setProperty((String)object, object2);
            }
            case 20: {
                boolean bl = WXUtils.getBoolean(object2, Boolean.TRUE);
                if (this.getHostView() == null) return true;
                ((WXEditText)this.getHostView()).setAllowCopyPaste(bl);
                return true;
            }
            case 19: {
                this.setReturnKeyType(String.valueOf(object2));
                return true;
            }
            case 18: {
                object = WXUtils.getBoolean(object2, null);
                if (object == null) return true;
                this.setSingleLine((Boolean)object);
                return true;
            }
            case 17: {
                return true;
            }
            case 16: {
                object = WXUtils.getString(object2, null);
                if (object == null) return true;
                this.setFontSize((String)object);
                return true;
            }
            case 15: {
                this.isConfirmHold = WXUtils.getBoolean(object2, Boolean.FALSE);
                return super.setProperty((String)object, object2);
            }
            case 14: {
                object = WXUtils.getBoolean(object2, Boolean.FALSE);
                ((WXEditText)this.getHostView()).setFocusable((Boolean)object ^ true);
                ((WXEditText)this.getHostView()).setFocusableInTouchMode((Boolean)object ^ true);
                ((WXEditText)this.getHostView()).setCursorVisible((Boolean)object ^ true);
                return true;
            }
            case 13: {
                object = WXUtils.getInteger(object2, null);
                if (object == null) return true;
                this.setMaxLength((Integer)object);
                return true;
            }
            case 12: {
                object = WXUtils.getInteger(object2, null);
                if (object == null) return true;
                this.setLines((Integer)object);
                return true;
            }
            case 11: 
            case 21: {
                this.setAutofocus(WXUtils.getBoolean(object2, Boolean.FALSE));
                return true;
            }
            case 10: {
                object = WXUtils.getString(object2, null);
                if (object == null) return true;
                this.setColor((String)object);
                return true;
            }
            case 9: {
                return true;
            }
            case 8: {
                return true;
            }
            case 7: {
                object = WXUtils.getInteger(object2, null);
                if (object == null) return true;
                this.setMaxLength((Integer)object);
                return true;
            }
            case 6: {
                object = WXUtils.getString(object2, null);
                if (object == null) return true;
                this.setTextAlign((String)object);
                return true;
            }
            case 5: {
                if (object2 == null) return true;
                try {
                    object = TypefaceUtil.getFontDO(object2.toString());
                    if (object != null && ((FontDO)object).getTypeface() != null && this.getHostView() != null) {
                        ((WXEditText)this.getHostView()).setTypeface(((FontDO)object).getTypeface());
                        return true;
                    }
                    this.registerTypefaceObserver(object2.toString());
                    return true;
                }
                catch (Exception exception) {}
                exception.printStackTrace();
                return true;
            }
            case 4: {
                int n4 = WXUtils.getInt(object2);
                if (n4 > 0 && n4 <= ((WXEditText)this.getHostView()).getText().length()) {
                    ((WXEditText)this.getHostView()).setSelection(n4);
                    return true;
                }
                if (n4 <= ((WXEditText)this.getHostView()).getText().length()) return true;
                ((WXEditText)this.getHostView()).setSelection(((WXEditText)this.getHostView()).getText().length());
                return true;
            }
            case 3: {
                object = WXUtils.getString(object2, null);
                if (object == null) return true;
                this.setPlaceholderColor((String)object);
                return true;
            }
            case 2: {
                this.selectionEnd = n = WXUtils.getInteger(object2, Integer.MAX_VALUE).intValue();
                this.setSelectionRange(this.selectionStart, n);
                return super.setProperty((String)object, object2);
            }
            case 1: {
                return true;
            }
            case 0: 
        }
        this.selectionStart = n = WXUtils.getInteger(object2, Integer.MAX_VALUE).intValue();
        int n5 = this.selectionEnd;
        this.setSelectionRange(n, n5);
        return super.setProperty((String)object, object2);
    }

    @WXComponentProp(name="returnKeyType")
    public void setReturnKeyType(String string2) {
        if (this.getHostView() != null && !string2.equals(this.mReturnKeyType)) {
            this.mReturnKeyType = string2;
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1544803905: {
                    if (!string2.equals("default")) break;
                    n = 5;
                    break;
                }
                case 3526536: {
                    if (!string2.equals("send")) break;
                    n = 4;
                    break;
                }
                case 3377907: {
                    if (!string2.equals("next")) break;
                    n = 3;
                    break;
                }
                case 3089282: {
                    if (!string2.equals("done")) break;
                    n = 2;
                    break;
                }
                case 3304: {
                    if (!string2.equals("go")) break;
                    n = 1;
                    break;
                }
                case -906336856: {
                    if (!string2.equals("search")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 5: {
                    this.mEditorAction = 0;
                    break;
                }
                case 4: {
                    this.mEditorAction = 4;
                    break;
                }
                case 3: {
                    this.mEditorAction = 5;
                    break;
                }
                case 2: {
                    this.mEditorAction = 6;
                    break;
                }
                case 1: {
                    this.mEditorAction = 2;
                    break;
                }
                case 0: {
                    this.mEditorAction = 3;
                }
            }
            DCWXInput dCWXInput = this;
            dCWXInput.blur();
            ((WXEditText)dCWXInput.getHostView()).setImeOptions(this.mEditorAction);
            return;
        }
    }

    public void setPlaceholder(String string2) {
        if (string2 != null && this.getHostView() != null) {
            DCWXInput dCWXInput = this;
            ((WXEditText)dCWXInput.getHostView()).setHint(string2);
            dCWXInput.setPlaceholderStyle(dCWXInput.placeholderStyle);
            return;
        }
    }

    @WXComponentProp(name="placeholderColor")
    public void setPlaceholderColor(String string2) {
        int n;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)string2) && (n = WXResourceUtils.getColor(string2)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setHintTextColor(n);
        }
    }

    public void setType(String string2) {
        Log.e((String)"weex", (String)("setType=" + string2));
        if (string2 != null && this.getHostView() != null && !this.mType.equals(string2)) {
            this.mType = string2;
            DCWXInput dCWXInput = this;
            ((EditText)this.getHostView()).setInputType(dCWXInput.getInputType(dCWXInput.mType));
            return;
        }
    }

    @WXComponentProp(name="autofocus")
    public void setAutofocus(final boolean bl) {
        if (this.getHostView() == null) {
            return;
        }
        DCWXInput dCWXInput = this;
        final EditText editText = (EditText)dCWXInput.getHostView();
        if (!dCWXInput.isLayoutFinished.get()) {
            if (this.getInstance().isFrameViewShow()) {
                ((WXEditText)this.getHostView()).getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        if (DCWXInput.this.getInstance() == null) {
                            return;
                        }
                        if (bl) {
                            8 v0 = this;
                            v0.DCWXInput.this.isLayoutFinished.set(true);
                            v0.DCWXInput.this.hostViewFocus(editText);
                            DCWXInput dCWXInput = v0.DCWXInput.this;
                            dCWXInput.setSelectionRange(dCWXInput.selectionStart, DCWXInput.this.selectionEnd);
                        } else {
                            editText.clearFocus();
                        }
                        ((WXEditText)DCWXInput.this.getHostView()).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                });
            } else {
                if (this.mFrameViewEventListener != null) {
                    this.getInstance().removeFrameViewEventListener(this.mFrameViewEventListener);
                }
                this.mFrameViewEventListener = new WXSDKInstance.FrameViewEventListener(){

                    @Override
                    public void onShowAnimationEnd() {
                        if (DCWXInput.this.getInstance() == null) {
                            return;
                        }
                        if (bl) {
                            9 v0 = this;
                            v0.DCWXInput.this.isLayoutFinished.set(true);
                            v0.DCWXInput.this.hostViewFocus(editText);
                            DCWXInput dCWXInput = v0.DCWXInput.this;
                            dCWXInput.setSelectionRange(dCWXInput.selectionStart, DCWXInput.this.selectionEnd);
                        } else {
                            editText.clearFocus();
                        }
                        9 v2 = this;
                        v2.DCWXInput.this.getInstance().removeFrameViewEventListener(this);
                        DCWXInput.access$2102(v2.DCWXInput.this, null);
                    }
                };
                this.getInstance().addFrameViewEventListener(this.mFrameViewEventListener);
            }
        } else {
            if (bl) {
                this.hostViewFocus(editText);
            } else {
                this.hideSoftKeyboard();
            }
            editText.clearFocus();
        }
    }

    @WXComponentProp(name="adjustPosition")
    public void setAdjustPosition(Object object) {
        if (this.getHostView() != null) {
            object = WXUtils.getBoolean(object, Boolean.TRUE) != false ? DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_PAN : DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_NOTHING;
            ((WXEditText)this.getHostView()).setInputSoftMode((String)object);
        }
    }

    @WXComponentProp(name="value")
    public void setText(String string2) {
        WXEditText wXEditText = (WXEditText)this.getHostView();
        if (wXEditText == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)wXEditText.getText(), (CharSequence)string2)) {
            return;
        }
        this.mIgnoreNextOnInputEvent = true;
        wXEditText.setText(string2);
        int n = this.cursor;
        if (n <= 0) {
            n = string2.length();
        }
        if (string2 == null) {
            n = 0;
        }
        wXEditText.setSelection(n);
    }

    @WXComponentProp(name="color")
    public void setColor(String string2) {
        int n;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)string2) && (n = WXResourceUtils.getColor(string2)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setTextColor(n);
        }
    }

    @WXComponentProp(name="fontSize")
    public void setFontSize(String string2) {
        if (this.getHostView() != null && string2 != null) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            new HashMap<String, Object>(1).put("fontSize", string2);
            ((WXEditText)this.getHostView()).setTextSize(0, AbsStyle.getFontSize(hashMap2, this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()));
        }
    }

    @WXComponentProp(name="placeholderStyle")
    public void setPlaceholderStyle(JSONObject object) {
        object = this.placeholderStyle;
        if (object != null && !object.isEmpty()) {
            ForegroundColorSpan foregroundColorSpan;
            AbsoluteSizeSpan absoluteSizeSpan;
            SpannableString spannableString;
            object = ((WXEditText)this.getHostView()).getHint();
            if (object == null && this.getAttrs().containsKey("placeholder")) {
                object = WXUtils.getString(this.getAttrs().get("placeholder"), "");
            }
            SpannableString spannableString2 = spannableString;
            spannableString = new SpannableString((CharSequence)object);
            object = absoluteSizeSpan;
            absoluteSizeSpan = new AbsoluteSizeSpan((int)((WXEditText)this.getHostView()).getTextSize());
            ForegroundColorSpan foregroundColorSpan2 = foregroundColorSpan;
            foregroundColorSpan = new ForegroundColorSpan(((WXEditText)this.getHostView()).getCurrentHintTextColor());
            BackgroundColorSpan backgroundColorSpan = null;
            String string2 = null;
            block28: for (Object object2 : this.placeholderStyle.entrySet()) {
                AbsoluteSizeSpan absoluteSizeSpan2;
                HashMap<String, Object> hashMap;
                String string3 = (String)object2.getKey();
                string3.hashCode();
                int n = -1;
                switch (string3.hashCode()) {
                    default: {
                        break;
                    }
                    case 1287124693: {
                        if (!string3.equals("backgroundColor")) break;
                        n = 8;
                        break;
                    }
                    case 746232421: {
                        if (!string3.equals("text-align")) break;
                        n = 7;
                        break;
                    }
                    case 605322756: {
                        if (!string3.equals("background-color")) break;
                        n = 6;
                        break;
                    }
                    case 598800822: {
                        if (!string3.equals("font-weight")) break;
                        n = 5;
                        break;
                    }
                    case 365601008: {
                        if (!string3.equals("fontSize")) break;
                        n = 4;
                        break;
                    }
                    case 94842723: {
                        if (!string3.equals("color")) break;
                        n = 3;
                        break;
                    }
                    case -734428249: {
                        if (!string3.equals("fontWeight")) break;
                        n = 2;
                        break;
                    }
                    case -1065511464: {
                        if (!string3.equals("textAlign")) break;
                        n = 1;
                        break;
                    }
                    case -1586082113: {
                        if (!string3.equals("font-size")) break;
                        n = 0;
                    }
                }
                switch (n) {
                    default: {
                        continue block28;
                    }
                    case 6: 
                    case 8: {
                        BackgroundColorSpan backgroundColorSpan2;
                        int n2 = WXResourceUtils.getColor(String.valueOf(object2.getValue()));
                        if (n2 == Integer.MIN_VALUE) continue block28;
                        backgroundColorSpan = backgroundColorSpan2;
                        backgroundColorSpan2 = new BackgroundColorSpan(n2);
                        continue block28;
                    }
                    case 3: {
                        ForegroundColorSpan foregroundColorSpan3;
                        int n3 = WXResourceUtils.getColor(String.valueOf(object2.getValue()));
                        if (n3 == Integer.MIN_VALUE) continue block28;
                        foregroundColorSpan2 = foregroundColorSpan3;
                        foregroundColorSpan3 = new ForegroundColorSpan(n3);
                        continue block28;
                    }
                    case 2: 
                    case 5: {
                        StyleSpan styleSpan;
                        string2 = String.valueOf(object2.getValue());
                        int n4 = -1;
                        switch (string2.hashCode()) {
                            default: {
                                break;
                            }
                            case 3029637: {
                                if (!string2.equals("bold")) break;
                                n4 = 4;
                                break;
                            }
                            case 56313: {
                                if (!string2.equals("900")) break;
                                n4 = 3;
                                break;
                            }
                            case 55352: {
                                if (!string2.equals("800")) break;
                                n4 = 2;
                                break;
                            }
                            case 54391: {
                                if (!string2.equals("700")) break;
                                n4 = 1;
                                break;
                            }
                            case 53430: {
                                if (!string2.equals("600")) break;
                                n4 = 0;
                            }
                        }
                        switch (n4) {
                            default: {
                                StyleSpan styleSpan2;
                                string2 = styleSpan2;
                                styleSpan2 = new StyleSpan(0);
                                continue block28;
                            }
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                        }
                        string2 = styleSpan;
                        styleSpan = new StyleSpan(1);
                        continue block28;
                    }
                    case 1: 
                    case 7: {
                        this.placeholderTextAlign = String.valueOf(object2.getValue());
                        int n5 = this.getTextAlign(String.valueOf(object2.getValue()));
                        if (n5 <= 0) continue block28;
                        ((WXEditText)this.getHostView()).setGravity(n5 | this.getVerticalGravity());
                        continue block28;
                    }
                    case 0: 
                    case 4: 
                }
                object = String.valueOf(object2.getValue());
                if (((String)object).endsWith("px")) {
                    object = ((String)object).replaceAll("px", "");
                } else if (((String)object).endsWith("wx")) {
                    object = ((String)object).replaceAll("wx", "");
                }
                object2 = hashMap;
                new HashMap<String, Object>(1).put("fontSize", object);
                object = absoluteSizeSpan2;
                absoluteSizeSpan2 = new AbsoluteSizeSpan(WXUtils.getInteger(AbsStyle.getFontSize((Map<String, Object>)object2, this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()), this.getInstance().getDefaultFontSize()).intValue());
            }
            SpannableString spannableString3 = spannableString2;
            int n = spannableString3.length();
            spannableString3.setSpan(object, 0, n, 33);
            if (backgroundColorSpan != null) {
                SpannableString spannableString4 = spannableString2;
                int n6 = spannableString4.length();
                spannableString4.setSpan(backgroundColorSpan, 0, n6, 33);
            }
            if (string2 != null) {
                SpannableString spannableString5 = spannableString2;
                int n7 = spannableString5.length();
                spannableString5.setSpan(string2, 0, n7, 33);
            }
            spannableString2.setSpan((Object)foregroundColorSpan2, 0, spannableString2.length(), 33);
            ((WXEditText)this.getHostView()).setHint((CharSequence)spannableString2);
            return;
        }
    }

    @WXComponentProp(name="placeholderClass")
    public void setPlaceholderClass(JSONObject jSONObject) {
        this.setPlaceholderStyle(jSONObject);
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String string2) {
        this.textAlign = string2;
        int n = this.getTextAlign(string2);
        if (n > 0) {
            ((WXEditText)this.getHostView()).setGravity(n | this.getVerticalGravity());
        }
    }

    @WXComponentProp(name="singleline")
    public void setSingleLine(boolean bl) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setSingleLine(bl);
    }

    @WXComponentProp(name="lines")
    public void setLines(int n) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setLines(n);
    }

    @WXComponentProp(name="maxLength")
    public void setMaxLength(int n) {
        InputFilter.LengthFilter lengthFilter;
        if (dCWXInput.getHostView() == null) {
            return;
        }
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        WXEditText wXEditText = (WXEditText)dCWXInput.getHostView();
        DCWXInput dCWXInput = lengthFilter;
        lengthFilter = new InputFilter.LengthFilter(n);
        wXEditText.setFilters(new InputFilter[]{dCWXInput});
    }

    @WXComponentProp(name="maxlength")
    @Deprecated
    public void setMaxlength(int n) {
        this.setMaxLength(n);
    }

    @WXComponentProp(name="cursorSpacing")
    public void setCursorSpacing(String string2) {
        if (this.getHostView() != null) {
            float f = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(string2), this.getInstance().getInstanceViewPortWidthWithFloat());
            ((WXEditText)this.getHostView()).setCursorSpacing(f);
        }
    }

    void hideSoftKeyboard() {
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    DCWXInput.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)DCWXInput.this.getHostView()).getWindowToken(), 0);
                }
            }), 16L);
        }
    }

    @JSMethod
    public void blur() {
        WXEditText wXEditText = (WXEditText)this.getHostView();
        if (wXEditText != null && wXEditText.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().interceptFocus();
            }
            wXEditText.clearFocus();
            this.hideSoftKeyboard();
        }
    }

    public String getValue() {
        return ((WXEditText)this.getHostView()).getText().toString();
    }

    @JSMethod
    public void setValue(String string2) {
        ((WXEditText)this.getHostView()).setText(string2);
    }

    @JSMethod
    public void focus() {
        WXEditText wXEditText = (WXEditText)this.getHostView();
        if (wXEditText != null && !wXEditText.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().ignoreFocus();
            }
            WXEditText wXEditText2 = wXEditText;
            wXEditText2.requestFocus();
            wXEditText2.setFocusable(true);
            wXEditText2.setFocusableInTouchMode(true);
            this.showSoftKeyboard();
        }
    }

    @Override
    protected Object convertEmptyProperty(String string2, Object object) {
        String string3 = string2;
        string3.hashCode();
        if (!string3.equals("color")) {
            if (!string2.equals("fontSize")) {
                return super.convertEmptyProperty(string2, object);
            }
            return this.getInstance().getDefaultFontSize();
        }
        return "black";
    }

    @UniJSMethod
    public void getSelectionRange(String string2) {
        HashMap<String, Integer> hashMap;
        HashMap<String, Integer> hashMap2 = hashMap;
        hashMap = new HashMap<String, Integer>(2);
        EditText editText = (EditText)this.getHostView();
        if (editText != null) {
            EditText editText2 = editText;
            int n = editText2.getSelectionStart();
            int n2 = editText2.getSelectionEnd();
            if (!editText2.hasFocus()) {
                n = 0;
                n2 = 0;
            }
            hashMap2.put("selectionStart", n);
            hashMap2.put("selectionEnd", n2);
        }
        WXBridgeManager.getInstance().callback(this.getInstanceId(), string2, hashMap2, false);
    }

    @UniJSMethod
    public void getCursor(JSCallback jSCallback) {
        HashMap<String, Integer> hashMap;
        HashMap<String, Integer> hashMap2 = hashMap;
        hashMap = new HashMap<String, Integer>(1);
        if (this.getHostView() != null && ((WXEditText)this.getHostView()).isFocused()) {
            hashMap2.put("cursor", ((WXEditText)this.getHostView()).getSelectionEnd());
        } else {
            hashMap2.put("cursor", 0);
        }
        jSCallback.invoke(hashMap2);
    }

    @JSMethod
    public void setTextFormatter(JSONObject object) {
        block9: {
            TextFormatter textFormatter;
            DCWXInput dCWXInput = textFormatter2;
            JSONObject jSONObject = object;
            JSONObject jSONObject2 = jSONObject;
            JSONObject jSONObject3 = jSONObject;
            JSONObject jSONObject4 = jSONObject;
            object = jSONObject.getString("formatRule");
            Object object2 = jSONObject2.getString("formatReplace");
            String string2 = jSONObject3.getString("recoverRule");
            String string3 = jSONObject4.getString("recoverReplace");
            object = dCWXInput.parseToPattern((String)object, (String)object2);
            object2 = ((DCWXInput)((Object)textFormatter2)).parseToPattern(string2, string3);
            if (object == null || object2 == null) break block9;
            DCWXInput dCWXInput2 = textFormatter2;
            TextFormatter textFormatter2 = textFormatter;
            try {
                textFormatter = new TextFormatter((PatternWrapper)object, (PatternWrapper)object2);
                dCWXInput2.mFormatter = textFormatter2;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    void addTextChangedListener(TextWatcher textWatcher) {
        if (this.mTextChangedListeners == null) {
            ArrayList<TextWatcher> arrayList;
            ArrayList<TextWatcher> arrayList2 = arrayList;
            arrayList = new ArrayList<TextWatcher>();
            this.mTextChangedListeners = arrayList2;
        }
        this.mTextChangedListeners.add(textWatcher);
    }

    @Override
    public void updateProperties(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            String string2 = map.containsKey("type") ? String.valueOf(map.get("type")) : this.mType;
            DCWXInput dCWXInput = this;
            dCWXInput.setType(string2);
            string2 = dCWXInput.mType;
            if (string2 != null && string2.equals("text") && map.containsKey("confirmType")) {
                if (map.containsKey("confirmType")) {
                    string2 = String.valueOf(map.get("confirmType"));
                } else {
                    string2 = this.mReturnKeyType;
                    if (string2 == null) {
                        string2 = "done";
                    }
                }
                this.setReturnKeyType(string2);
            }
            if (this.getAttrs().containsKey("password")) {
                this.isPassword = WXUtils.getBoolean(this.getAttrs().get("password"), Boolean.FALSE);
                string2 = this.isPassword ? "password" : this.mType;
                if (string2 != null && this.getHostView() != null) {
                    ((EditText)this.getHostView()).setInputType(this.getInputType(string2));
                } else {
                    return;
                }
            }
            if (map.containsKey("cursor")) {
                this.cursor = WXUtils.getInteger(map.get("cursor"), 0);
            }
            if (map.containsKey("selectionStart")) {
                this.selectionStart = WXUtils.getInteger(map.get("selectionStart"), Integer.MAX_VALUE);
            }
            if (map.containsKey("selectionEnd")) {
                this.selectionEnd = WXUtils.getInteger(map.get("selectionEnd"), Integer.MAX_VALUE);
            }
            if (map.containsKey("placeholder")) {
                this.setPlaceholder(WXUtils.getString(map.get("placeholder"), ""));
            }
            if (map.containsKey("placeholderClass")) {
                this.placeholderStyle.putAll((Map)((JSONObject)JSONObject.parse((String)WXUtils.getString(map.get("placeholderClass"), "{}"))));
            }
            if (map.containsKey("placeholderStyle")) {
                this.placeholderStyle.putAll((Map)((JSONObject)JSONObject.parse((String)WXUtils.getString(map.get("placeholderStyle"), "{}"))));
            }
            if (map.containsKey("adjustPosition")) {
                this.setAdjustPosition(map.get("adjustPosition"));
            }
        }
        super.updateProperties(map);
    }

    @Override
    public void destroy() {
        DCWXInput dCWXInput = this;
        super.destroy();
        List<TextView.OnEditorActionListener> list = dCWXInput.mEditorActionListeners;
        if (list != null) {
            list.clear();
        }
        if ((list = this.mTextChangedListeners) != null) {
            list.clear();
        }
        if (this.mTextChangedEventDispatcher != null) {
            this.mTextChangedEventDispatcher = null;
        }
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).destroy();
        }
    }

    public static class TextFormatter {
        private PatternWrapper format;
        private PatternWrapper recover;

        private TextFormatter(PatternWrapper patternWrapper, PatternWrapper patternWrapper2) {
            this.format = patternWrapper;
            this.recover = patternWrapper2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String format(String string2) {
            block4: {
                Throwable throwable2;
                block5: {
                    PatternWrapper patternWrapper;
                    try {
                        patternWrapper = this.format;
                        if (patternWrapper == null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    if (patternWrapper.global) {
                        return this.format.matcher.matcher(string2).replaceAll(this.format.replace);
                    }
                    return this.format.matcher.matcher(string2).replaceFirst(this.format.replace);
                }
                WXLogUtils.w("WXInput", "[format] " + throwable2.getMessage());
            }
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String recover(String string2) {
            block4: {
                Throwable throwable2;
                block5: {
                    PatternWrapper patternWrapper;
                    try {
                        patternWrapper = this.recover;
                        if (patternWrapper == null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    if (patternWrapper.global) {
                        return this.recover.matcher.matcher(string2).replaceAll(this.recover.replace);
                    }
                    return this.recover.matcher.matcher(string2).replaceFirst(this.recover.replace);
                }
                WXLogUtils.w("WXInput", "[formatted] " + throwable2.getMessage());
            }
            return string2;
        }
    }

    private static class PatternWrapper {
        private boolean global = false;
        private Pattern matcher;
        private String replace;

        private PatternWrapper() {
        }

        static /* synthetic */ boolean access$2702(PatternWrapper patternWrapper, boolean bl) {
            patternWrapper.global = bl;
            return bl;
        }

        static /* synthetic */ Pattern access$2802(PatternWrapper patternWrapper, Pattern pattern) {
            patternWrapper.matcher = pattern;
            return pattern;
        }

        static /* synthetic */ String access$2902(PatternWrapper patternWrapper, String string2) {
            patternWrapper.replace = string2;
            return string2;
        }
    }

    private static interface ReturnTypes {
        public static final String DEFAULT = "default";
        public static final String GO = "go";
        public static final String NEXT = "next";
        public static final String SEARCH = "search";
        public static final String SEND = "send";
        public static final String DONE = "done";
    }
}

