/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.performance.IWXApmMonitorAdapter;
import com.taobao.weex.performance.WXAnalyzerDataTransfer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.basic.WXBasicComponent;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import io.dcloud.feature.uniapp.ui.component.AbsBasicComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class WXInstanceApm {
    public static final String WEEX_PAGE_TOPIC = "weex_page";
    public static final String KEY_PROPERTIES_ERROR_CODE = "wxErrorCode";
    public static final String KEY_PAGE_PROPERTIES_BIZ_ID = "wxBizID";
    public static final String KEY_PAGE_PROPERTIES_BUBDLE_URL = "wxBundleUrl";
    public static final String KEY_PAGE_PROPERTIES_JSLIB_VERSION = "wxJSLibVersion";
    public static final String KEY_PAGE_PROPERTIES_WEEX_VERSION = "wxSDKVersion";
    public static final String KEY_PAGE_PROPERTIES_REQUEST_TYPE = "wxRequestType";
    public static final String KEY_PAGE_PROPERTIES_CACHE_TYPE = "wxCacheType";
    public static final String KEY_PAGE_PROPERTIES_CACHE_INFO = "wxZCacheInfo";
    public static final String KEY_PAGE_PROPERTIES_JS_FM_INI = "wxJsFrameworkInit";
    public static final String KEY_PAGE_PROPERTIES_CONTAINER_NAME = "wxContainerName";
    public static final String KEY_PAGE_PROPERTIES_INSTANCE_TYPE = "wxInstanceType";
    public static final String KEY_PAGE_PROPERTIES_PARENT_PAGE = "wxParentPage";
    public static final String KEY_PAGE_PROPERTIES_BUNDLE_TYPE = "wxBundleType";
    public static final String KEY_PAGE_PROPERTIES_RENDER_TYPE = "wxRenderType";
    public static final String KEY_PAGE_PROPERTIES_UIKIT_TYPE = "wxUIKitType";
    public static final String KEY_PAGE_STAGES_CONTAINER_READY = "wxContainerReady";
    public static final String KEY_PAGE_STAGES_DOWN_BUNDLE_START = "wxStartDownLoadBundle";
    public static final String KEY_PAGE_STAGES_DOWN_BUNDLE_END = "wxEndDownLoadBundle";
    public static final String KEY_PAGE_STAGES_RENDER_ORGIGIN = "wxRenderTimeOrigin";
    public static final String KEY_PAGE_STAGES_LOAD_BUNDLE_START = "wxStartLoadBundle";
    public static final String KEY_PAGE_STAGES_LOAD_BUNDLE_END = "wxEndLoadBundle";
    public static final String KEY_PAGE_STAGES_FIRST_INTERACTION_VIEW = "wxFirstInteractionView";
    public static final String KEY_PAGE_STAGES_CREATE_FINISH = "wxJSBundleCreateFinish";
    public static final String KEY_PAGE_STAGES_FSRENDER = "wxFsRender";
    public static final String KEY_PAGE_STAGES_NEW_FSRENDER = "wxNewFsRender";
    public static final String KEY_PAGE_STAGES_END_EXCUTE_BUNDLE = "wxEndExecuteBundle";
    public static final String KEY_PAGE_STAGES_INTERACTION = "wxInteraction";
    public static final String KEY_PAGE_STAGES_DESTROY = "wxDestroy";
    public static final String KEY_PAGE_STAGES_CUSTOM_PREPROCESS_START = "wxCustomPreprocessStart";
    public static final String KEY_PAGE_STAGES_CUSTOM_PREPROCESS_END = "wxCustomPreprocessEnd";
    public static final String KEY_PAGE_STATS_BUNDLE_SIZE = "wxBundleSize";
    public static final String KEY_PAGE_STATS_FS_CALL_JS_TIME = "wxFSCallJsTotalTime";
    public static final String KEY_PAGE_STATS_FS_CALL_JS_NUM = "wxFSCallJsTotalNum";
    public static final String KEY_PAGE_STATS_FS_TIMER_NUM = "wxFSTimerCount";
    public static final String KEY_PAGE_STATS_FS_CALL_NATIVE_TIME = "wxFSCallNativeTotalTime";
    public static final String KEY_PAGE_STATS_FS_CALL_NATIVE_NUM = "wxFSCallNativeTotalNum";
    public static final String KEY_PAGE_STATS_FS_CALL_EVENT_NUM = "wxFSCallEventTotalNum";
    public static final String KEY_PAGE_STATS_FS_REQUEST_NUM = "wxFSRequestNum";
    public static final String KEY_PAGE_STATS_CELL_EXCEED_NUM = "wxCellExceedNum";
    public static final String KEY_PAGE_STATS_MAX_DEEP_VIEW = "wxMaxDeepViewLayer";
    public static final String KEY_PAGE_STATS_MAX_DEEP_DOM = "wxMaxDeepVDomLayer";
    public static final String KEY_PAGE_STATS_MAX_COMPONENT_NUM = "wxMaxComponentCount";
    public static final String KEY_PAGE_STATS_WRONG_IMG_SIZE_COUNT = "wxWrongImgSizeCount";
    public static final String KEY_PAGE_STATS_EMBED_COUNT = "wxEmbedCount";
    public static final String KEY_PAGE_STATS_LARGE_IMG_COUNT = "wxLargeImgMaxCount";
    public static final String KEY_PAGE_STATS_BODY_RATIO = "wxBodyRatio";
    public static final String KEY_PAGE_STATS_SCROLLER_NUM = "wxScrollerCount";
    public static final String KEY_PAGE_STATS_CELL_DATA_UN_RECYCLE_NUM = "wxCellDataUnRecycleCount";
    public static final String KEY_PAGE_STATS_CELL_UN_RE_USE_NUM = "wxCellUnReUseCount";
    public static final String KEY_PAGE_STATS_IMG_UN_RECYCLE_NUM = "wxImgUnRecycleCount";
    public static final String KEY_PAGE_STATS_I_SCREEN_VIEW_COUNT = "wxInteractionScreenViewCount";
    public static final String KEY_PAGE_STATS_I_ALL_VIEW_COUNT = "wxInteractionAllViewCount";
    public static final String KEY_PAGE_STATS_I_COMPONENT_CREATE_COUNT = "wxInteractionComponentCreateCount";
    public static final String KEY_PAGE_ANIM_BACK_NUM = "wxAnimationInBackCount";
    public static final String KEY_PAGE_TIMER_BACK_NUM = "wxTimerInBackCount";
    public static final String KEY_PAGE_STATS_ACTUAL_DOWNLOAD_TIME = "wxActualNetworkTime";
    public static final String KEY_PAGE_STATS_IMG_LOAD_NUM = "wxImgLoadCount";
    public static final String KEY_PAGE_STATS_IMG_LOAD_SUCCESS_NUM = "wxImgLoadSuccessCount";
    public static final String KEY_PAGE_STATS_IMG_LOAD_FAIL_NUM = "wxImgLoadFailCount";
    public static final String KEY_PAGE_STATS_NET_NUM = "wxNetworkRequestCount";
    public static final String KEY_PAGE_STATS_NET_SUCCESS_NUM = "wxNetworkRequestSuccessCount";
    public static final String KEY_PAGE_STATS_NET_FAIL_NUM = "wxNetworkRequestFailCount";
    public static final String KEY_PAGE_STATS_JSLIB_INIT_TIME = "wxJSLibInitTime";
    public static final String KEY_PAGE_STATS_VIEW_CREATE_COST = "wxViewCost";
    public static final String KEY_PAGE_STATS_COMPONENT_CREATE_COST = "wxComponentCost";
    public static final String KEY_PAGE_STATS_EXECUTE_JS_CALLBACK_COST = "wxExecJsCallBack";
    public static final String KEY_PAGE_STATS_LAYOUT_TIME = "wxLayoutTime";
    public static final String VALUE_ERROR_CODE_DEFAULT = "0";
    public static final String VALUE_BUNDLE_LOAD_LENGTH = "wxLoadedLength";
    private String mInstanceId;
    private IWXApmMonitorAdapter apmInstance;
    private Map<String, Double> recordStatsMap;
    public final Map<String, Long> stageMap;
    private Map<String, Object> mPropertiesMap;
    private boolean isFSEnd;
    private boolean mHasInit = false;
    private boolean mEnd = false;
    private boolean hasRecordFistInteractionView = false;
    public final Map<String, Object> extInfo;
    public boolean forceStopRecordInteraction = false;
    public Rect instanceRect;
    public String reportPageName;
    public boolean hasReportLayerOverDraw = false;
    public boolean hasAddView;
    private Handler mUIHandler;
    public Set<String> exceptionRecord;
    private double interactionLayoutTime;
    public long componentCreateTime;
    private long interactionComponentCreateTime;
    public long viewCreateTime;
    private long interactionViewCreateTime;
    private long wxExecJsCallBackTime;
    private long interactionJsCallBackTime;
    private boolean mHasRecordDetailData;
    private boolean hasSendInteractionToJS;
    public volatile boolean isReady;
    private Runnable jsPerformanceCallBack;
    private Runnable delayCollectDataTask;
    private long preUpdateTime;

    public WXInstanceApm(String object) {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2;
        Handler handler;
        ConcurrentHashMap concurrentHashMap3;
        ConcurrentHashMap concurrentHashMap4;
        Runnable runnable;
        Runnable runnable2;
        CopyOnWriteArraySet<String> copyOnWriteArraySet;
        Object object2 = copyOnWriteArraySet;
        copyOnWriteArraySet = new CopyOnWriteArraySet<String>();
        this.exceptionRecord = object2;
        this.mHasRecordDetailData = false;
        this.hasSendInteractionToJS = false;
        this.isReady = true;
        object2 = runnable2;
        runnable2 = new Runnable(){

            @Override
            public void run() {
                WXInstanceApm.this.sendPerformanceToJS();
            }
        };
        this.jsPerformanceCallBack = object2;
        object2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                WXInstanceApm.this.recordPerformanceDetailData();
            }
        };
        this.delayCollectDataTask = object2;
        this.preUpdateTime = 0L;
        this.mInstanceId = object;
        object = concurrentHashMap4;
        concurrentHashMap4 = new ConcurrentHashMap();
        this.extInfo = object;
        object = concurrentHashMap3;
        concurrentHashMap3 = new ConcurrentHashMap();
        this.stageMap = object;
        object = handler;
        handler = new Handler(Looper.getMainLooper());
        this.mUIHandler = object;
        object = concurrentHashMap2;
        concurrentHashMap2 = new ConcurrentHashMap();
        this.recordStatsMap = object;
        object = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        this.mPropertiesMap = object;
        object = WXSDKManager.getInstance().getApmGenerater();
        if (object != null) {
            this.apmInstance = object.generateApmInstance(WEEX_PAGE_TOPIC);
        }
    }

    private void sendStageInfo(String string2, long l) {
        if (WXAnalyzerDataTransfer.isOpenPerformance) {
            Long l2 = l;
            WXAnalyzerDataTransfer.transferPerformance(((WXInstanceApm)this).mInstanceId, "stage", string2, l2);
        }
        if (KEY_PAGE_STAGES_RENDER_ORGIGIN.equalsIgnoreCase(string2)) {
            ((WXInstanceApm)this).mUIHandler.postDelayed(((WXInstanceApm)this).jsPerformanceCallBack, 8000L);
        }
        if ((this = ((WXInstanceApm)this).apmInstance) == null) {
            return;
        }
        this.onStage(string2, l);
    }

    private void sendProperty(String string2, Object object) {
        if (WXAnalyzerDataTransfer.isOpenPerformance) {
            WXAnalyzerDataTransfer.transferPerformance(((WXInstanceApm)this).mInstanceId, "properties", string2, object);
        }
        if ((this = ((WXInstanceApm)this).apmInstance) == null) {
            return;
        }
        this.addProperty(string2, object);
    }

    private void sendStats(String string2, double d) {
        if (WXAnalyzerDataTransfer.isOpenPerformance) {
            Double d2 = d;
            WXAnalyzerDataTransfer.transferPerformance(((WXInstanceApm)this).mInstanceId, "stats", string2, d2);
        }
        if ((this = ((WXInstanceApm)this).apmInstance) == null) {
            return;
        }
        this.addStats(string2, d);
    }

    private void printLog() {
        WXInstanceApm wXInstanceApm = l3;
        Long l = wXInstanceApm.stageMap.get(KEY_PAGE_STAGES_DOWN_BUNDLE_START);
        Long l2 = wXInstanceApm.stageMap.get(KEY_PAGE_STAGES_DOWN_BUNDLE_END);
        WXInstanceApm wXInstanceApm2 = l3;
        Long l3 = wXInstanceApm2.stageMap.get(KEY_PAGE_STAGES_INTERACTION);
        Long l4 = wXInstanceApm2.stageMap.get(KEY_PAGE_STAGES_CONTAINER_READY);
        if (l2 != null && l != null) {
            WXLogUtils.d("test->", "downLoadTime: " + (l2 - l));
        }
        if (l2 != null && l3 != null) {
            WXLogUtils.d("test->", "renderTime: " + (l3 - l2));
        }
        if (l4 != null && l3 != null) {
            WXLogUtils.d("test->", "showTime: " + (l3 - l4));
        }
    }

    private void addPropeyFromExtParms(String object, String string2, Map<String, Object> map) {
        if ((object = map.get(object)) instanceof String) {
            this.addProperty(string2, object);
        }
    }

    public void onInstanceReady(boolean bl) {
        this.isReady = true;
        if (bl) {
            this.onStage(KEY_PAGE_STAGES_DOWN_BUNDLE_START);
        }
        WXInstanceApm wXInstanceApm = this;
        wXInstanceApm.doInit();
        for (Map.Entry<String, Long> object : wXInstanceApm.stageMap.entrySet()) {
            this.sendStageInfo(object.getKey(), object.getValue());
        }
        for (Map.Entry<String, Number> entry : this.recordStatsMap.entrySet()) {
            this.sendStats(entry.getKey(), (Double)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.mPropertiesMap.entrySet()) {
            String string2 = entry.getKey();
            this.sendProperty(string2, entry.getValue());
        }
    }

    public void onEvent(String string2, Object object) {
        IWXApmMonitorAdapter iWXApmMonitorAdapter = ((WXInstanceApm)((Object)iWXApmMonitorAdapter)).apmInstance;
        if (iWXApmMonitorAdapter == null) {
            return;
        }
        iWXApmMonitorAdapter.onEvent(string2, object);
    }

    public void onStage(String string2) {
        long l = WXUtils.getFixUnixTime();
        this.onStageWithTime(string2, l);
    }

    public void onStageWithTime(String string2, long l) {
        if (this.mEnd) {
            return;
        }
        if (string2 == null) {
            return;
        }
        WXInstanceApm wXInstanceApm = this;
        wXInstanceApm.stageMap.put(string2, l);
        if (wXInstanceApm.isReady) {
            this.sendStageInfo(string2, l);
        }
    }

    public void addProperty(String string2, Object object) {
        if (this.mEnd) {
            return;
        }
        if (string2 != null && object != null) {
            WXInstanceApm wXInstanceApm = this;
            wXInstanceApm.mPropertiesMap.put(string2, object);
            if (wXInstanceApm.isReady) {
                this.sendProperty(string2, object);
            }
            return;
        }
    }

    public void addStats(String string2, double d) {
        if (this.mEnd) {
            return;
        }
        if (string2 == null) {
            return;
        }
        WXInstanceApm wXInstanceApm = this;
        wXInstanceApm.recordStatsMap.put(string2, d);
        if (wXInstanceApm.isReady) {
            this.sendStats(string2, d);
        }
    }

    public boolean hasInit() {
        return this.mHasInit;
    }

    public void doInit() {
        if (!this.isReady) {
            return;
        }
        if (this.mHasInit) {
            return;
        }
        this.mHasInit = true;
        Object object = this.apmInstance;
        if (object == null) {
            return;
        }
        object.onStart(this.mInstanceId);
        object = WXSDKManager.getInstance().getAllInstanceMap().get(this.mInstanceId);
        String string2 = object == null ? "unKnowUrl" : ((WXSDKInstance)object).getBundleUrl();
        WXInstanceApm wXInstanceApm = this;
        wXInstanceApm.addProperty(KEY_PAGE_PROPERTIES_BUBDLE_URL, string2);
        wXInstanceApm.addProperty(KEY_PROPERTIES_ERROR_CODE, VALUE_ERROR_CODE_DEFAULT);
        wXInstanceApm.addProperty(KEY_PAGE_PROPERTIES_JSLIB_VERSION, WXEnvironment.JS_LIB_SDK_VERSION);
        wXInstanceApm.addProperty(KEY_PAGE_PROPERTIES_WEEX_VERSION, WXEnvironment.WXSDK_VERSION);
        wXInstanceApm.addProperty(KEY_PAGE_PROPERTIES_WEEX_VERSION, WXEnvironment.WXSDK_VERSION);
        double d = WXBridgeManager.reInitCount;
        wXInstanceApm.addStats("wxReInitCount", d);
        if (object != null) {
            this.addProperty(KEY_PAGE_PROPERTIES_UIKIT_TYPE, ((WXSDKInstance)object).getRenderType());
        }
        this.addProperty("wxUseRuntimeApi", WXEnvironment.sUseRunTimeApi);
        if (object != null && (((WXSDKInstance)object).getRenderStrategy() == WXRenderStrategy.DATA_RENDER || ((WXSDKInstance)object).getRenderStrategy() == WXRenderStrategy.DATA_RENDER_BINARY)) {
            this.addProperty(KEY_PAGE_PROPERTIES_RENDER_TYPE, "eagle");
        }
        if (object != null) {
            for (Map.Entry<String, String> entry : ((WXSDKInstance)object).getContainerInfo().entrySet()) {
                String string3 = entry.getKey();
                this.addProperty(string3, entry.getValue());
            }
        }
    }

    public void setPageName(String string2) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2) && (object = WXSDKManager.getInstance().getAllInstanceMap().get(this.mInstanceId)) != null) {
            string2 = ((WXSDKInstance)object).getContainerInfo().get(KEY_PAGE_PROPERTIES_CONTAINER_NAME);
        }
        if ((object = this.apmInstance) != null) {
            string2 = object.parseReportUrl(string2);
        }
        this.reportPageName = string2;
        string2 = TextUtils.isEmpty((CharSequence)string2) ? "emptyPageName" : this.reportPageName;
        this.reportPageName = string2;
        this.addProperty(KEY_PAGE_PROPERTIES_BIZ_ID, string2);
    }

    public void onAppear() {
        IWXApmMonitorAdapter iWXApmMonitorAdapter = ((WXInstanceApm)((Object)iWXApmMonitorAdapter)).apmInstance;
        if (iWXApmMonitorAdapter == null) {
            return;
        }
        iWXApmMonitorAdapter.onAppear();
    }

    public void onDisAppear() {
        IWXApmMonitorAdapter iWXApmMonitorAdapter = ((WXInstanceApm)((Object)iWXApmMonitorAdapter)).apmInstance;
        if (iWXApmMonitorAdapter == null) {
            return;
        }
        iWXApmMonitorAdapter.onDisappear();
    }

    public void onEnd() {
        if (this.apmInstance != null && !this.mEnd) {
            WXInstanceApm wXInstanceApm = this;
            new Handler(Looper.getMainLooper()).removeCallbacks(this.delayCollectDataTask);
            wXInstanceApm.recordPerformanceDetailData();
            wXInstanceApm.exceptionRecord.clear();
            wXInstanceApm.mUIHandler.removeCallbacks(this.jsPerformanceCallBack);
            wXInstanceApm.onStage(KEY_PAGE_STAGES_DESTROY);
            if (!wXInstanceApm.mHasInit) {
                this.apmInstance.onEnd();
            }
            this.mEnd = true;
            if (WXEnvironment.isApkDebugable()) {
                this.printLog();
            }
            return;
        }
    }

    public void doDelayCollectData() {
        new Handler(Looper.getMainLooper()).postDelayed(this.delayCollectDataTask, 8000L);
    }

    public void arriveNewFsRenderTime() {
        if (this.apmInstance == null) {
            return;
        }
        this.onStage(KEY_PAGE_STAGES_NEW_FSRENDER);
    }

    public void arriveFSRenderTime() {
        if (this.apmInstance == null) {
            return;
        }
        this.isFSEnd = true;
        this.onStage(KEY_PAGE_STAGES_FSRENDER);
    }

    public void arriveInteraction(WXComponent object) {
        if (this.apmInstance != null && object != null && ((WXComponent)object).getInstance() != null) {
            if (WXAnalyzerDataTransfer.isOpenPerformance) {
                WXAnalyzerDataTransfer.transferInteractionInfo((WXComponent)object);
            }
            if (this.apmInstance == null) {
                return;
            }
            WXPerformance wXPerformance = ((WXComponent)object).getInstance().getWXPerformance();
            if (wXPerformance == null) {
                return;
            }
            long l = WXUtils.getFixUnixTime();
            if (WXAnalyzerDataTransfer.isInteractionLogOpen()) {
                Log.d((String)"wxInteractionAnalyzer", (String)("[client][wxinteraction]" + ((WXComponent)object).getInstance().getInstanceId() + "," + ((AbsBasicComponent)object).getComponentType() + "," + ((AbsBasicComponent)object).getRef() + "," + ((WXBasicComponent)object).getStyles() + "," + ((WXBasicComponent)object).getAttrs()));
            }
            if (!this.hasRecordFistInteractionView) {
                this.onStage(KEY_PAGE_STAGES_FIRST_INTERACTION_VIEW);
                this.hasRecordFistInteractionView = true;
            }
            if (this.forceStopRecordInteraction) {
                return;
            }
            long l2 = WXUtils.getFixUnixTime();
            if (l2 - this.preUpdateTime > 50L) {
                WXBridgeManager.getInstance().onInteractionTimeUpdate(this.mInstanceId);
                this.preUpdateTime = l2;
            }
            WXInstanceApm wXInstanceApm = this;
            wXInstanceApm.interactionComponentCreateTime = wXInstanceApm.componentCreateTime;
            wXInstanceApm.interactionViewCreateTime = wXInstanceApm.viewCreateTime;
            object = wXInstanceApm.recordStatsMap.get(KEY_PAGE_STATS_LAYOUT_TIME);
            double d = object == null ? 0.0 : (Double)object;
            WXInstanceApm wXInstanceApm2 = this;
            WXPerformance wXPerformance2 = wXPerformance;
            this.interactionLayoutTime = d;
            wXPerformance2.interactionTime = l - wXPerformance.renderUnixTimeOrigin;
            wXPerformance2.interactionRealUnixTime = System.currentTimeMillis();
            wXInstanceApm2.onStageWithTime(KEY_PAGE_STAGES_INTERACTION, l);
            wXInstanceApm2.updateDiffStats(KEY_PAGE_STATS_I_SCREEN_VIEW_COUNT, 1.0);
            double d2 = wXPerformance.localInteractionViewAddCount;
            this.updateMaxStats(KEY_PAGE_STATS_I_ALL_VIEW_COUNT, d2);
            object = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
            if (object != null) {
                double d3 = ((WXSDKInstance)object).getWXPerformance().componentCount;
                this.updateMaxStats(KEY_PAGE_STATS_I_COMPONENT_CREATE_COUNT, d3);
            }
            return;
        }
    }

    public void updateFSDiffStats(String string2, double d) {
        if (this.apmInstance != null && !this.isFSEnd) {
            this.updateDiffStats(string2, d);
            return;
        }
    }

    public void recordPerformanceDetailData() {
        if (this.mHasRecordDetailData) {
            return;
        }
        WXInstanceApm wXInstanceApm = this;
        wXInstanceApm.mHasRecordDetailData = true;
        double d = wXInstanceApm.interactionViewCreateTime;
        wXInstanceApm.addStats(KEY_PAGE_STATS_VIEW_CREATE_COST, d);
        d = wXInstanceApm.interactionComponentCreateTime;
        wXInstanceApm.addStats(KEY_PAGE_STATS_COMPONENT_CREATE_COST, d);
        d = wXInstanceApm.interactionJsCallBackTime;
        wXInstanceApm.addStats(KEY_PAGE_STATS_EXECUTE_JS_CALLBACK_COST, d);
        d = wXInstanceApm.interactionLayoutTime;
        wXInstanceApm.addStats(KEY_PAGE_STATS_LAYOUT_TIME, d);
    }

    public void updateDiffStats(String string2, double d) {
        if (this.apmInstance == null) {
            return;
        }
        d = (this.recordStatsMap.containsKey(string2) ? this.recordStatsMap.get(string2) : 0.0) + d;
        this.addStats(string2, d);
    }

    public void updateMaxStats(String string2, double d) {
        if (this.apmInstance == null) {
            return;
        }
        double d2 = this.recordStatsMap.containsKey(string2) ? this.recordStatsMap.get(string2) : 0.0;
        if (d2 < d) {
            this.addStats(string2, d);
        }
    }

    public void updateRecordInfo(Map<String, Object> object) {
        if (this.apmInstance != null && object != null) {
            WXInstanceApm wXInstanceApm = this;
            wXInstanceApm.addPropeyFromExtParms(KEY_PAGE_PROPERTIES_REQUEST_TYPE, KEY_PAGE_PROPERTIES_REQUEST_TYPE, (Map<String, Object>)object);
            wXInstanceApm.addPropeyFromExtParms("cacheType", KEY_PAGE_PROPERTIES_CACHE_TYPE, (Map<String, Object>)object);
            wXInstanceApm.addPropeyFromExtParms("zCacheInfo", KEY_PAGE_PROPERTIES_CACHE_INFO, (Map<String, Object>)object);
            double d = WXEnvironment.sJSLibInitTime;
            wXInstanceApm.addStats(KEY_PAGE_STATS_JSLIB_INIT_TIME, d);
            wXInstanceApm.addProperty(KEY_PAGE_PROPERTIES_JS_FM_INI, WXEnvironment.JsFrameworkInit);
            object = object.get("actualNetworkTime");
            if (object instanceof Long) {
                double d2 = ((Long)object).doubleValue();
                this.updateDiffStats(KEY_PAGE_STATS_ACTUAL_DOWNLOAD_TIME, d2);
            }
            return;
        }
    }

    public void actionNetRequest() {
        if (!this.isFSEnd) {
            this.updateFSDiffStats(KEY_PAGE_STATS_FS_REQUEST_NUM, 1.0);
        }
        this.updateDiffStats(KEY_PAGE_STATS_NET_NUM, 1.0);
    }

    public void actionNetResult(boolean bl, String string2) {
        if (bl) {
            this.updateDiffStats(KEY_PAGE_STATS_NET_SUCCESS_NUM, 1.0);
        } else {
            this.updateDiffStats(KEY_PAGE_STATS_NET_FAIL_NUM, 1.0);
        }
    }

    public void actionLoadImg() {
        this.updateDiffStats(KEY_PAGE_STATS_IMG_LOAD_NUM, 1.0);
    }

    public void actionLoadImgResult(boolean bl, String string2) {
        if (bl) {
            this.updateDiffStats(KEY_PAGE_STATS_IMG_LOAD_SUCCESS_NUM, 1.0);
        } else {
            this.updateDiffStats(KEY_PAGE_STATS_IMG_LOAD_FAIL_NUM, 1.0);
        }
    }

    public void sendPerformanceToJS() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap<String, String> hashMap3;
        if (((WXInstanceApm)((Object)hashMap5)).hasSendInteractionToJS) {
            return;
        }
        ((WXInstanceApm)((Object)hashMap5)).hasSendInteractionToJS = true;
        Object object = WXSDKManager.getInstance().getAllInstanceMap().get(((WXInstanceApm)((Object)hashMap5)).mInstanceId);
        if (object == null) {
            return;
        }
        WXSDKInstance wXSDKInstance = object;
        HashMap<String, String> hashMap4 = hashMap3;
        hashMap4(2);
        hashMap4.put(KEY_PAGE_PROPERTIES_BIZ_ID, ((WXInstanceApm)((Object)hashMap5)).reportPageName);
        hashMap3.put(KEY_PAGE_PROPERTIES_BUBDLE_URL, ((WXSDKInstance)object).getBundleUrl());
        HashMap hashMap5 = hashMap2;
        hashMap5(1);
        hashMap2.put(KEY_PAGE_STAGES_INTERACTION, ((WXSDKInstance)object).getWXPerformance().interactionRealUnixTime);
        object = hashMap;
        new HashMap(2).put("stage", hashMap5);
        object.put("properties", hashMap4);
        wXSDKInstance.fireGlobalEventCallback("wx_apm", (Map<String, Object>)object);
    }

    public String toPerfString() {
        StringBuilder stringBuilder;
        Long l = ((WXInstanceApm)((Object)l2)).stageMap.get(KEY_PAGE_STAGES_RENDER_ORGIGIN);
        WXInstanceApm wXInstanceApm = l2;
        Long l2 = wXInstanceApm.stageMap.get(KEY_PAGE_STAGES_INTERACTION);
        Long l3 = wXInstanceApm.stageMap.get(KEY_PAGE_STAGES_NEW_FSRENDER);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (l != null && l2 != null) {
            stringBuilder2.append("interactiveTime " + (l2 - l) + "ms");
        }
        if (l3 != null) {
            stringBuilder2.append(" wxNewFsRender " + l3 + "ms");
        }
        return stringBuilder2.toString();
    }

    public void updateNativePerformanceData(Map<String, String> object) {
        if (object == null) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            double d = -1.0;
            try {
                d = Double.valueOf((String)entry.getValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (d == -1.0) continue;
            String string2 = (String)entry.getKey();
            this.recordStatsMap.put(string2, d);
        }
    }
}

