/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.collection.ArrayMap;
import androidx.core.view.animation.PathInterpolatorCompat;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.animation.BackgroundColorProperty;
import com.taobao.weex.ui.animation.TransformParser;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class WXTransition {
    public static final String TRANSITION_PROPERTY = "transitionProperty";
    public static final String TRANSITION_DURATION = "transitionDuration";
    public static final String TRANSITION_DELAY = "transitionDelay";
    public static final String TRANSITION_TIMING_FUNCTION = "transitionTimingFunction";
    public static final Pattern PROPERTY_SPLIT_PATTERN = Pattern.compile("\\||,");
    private static final Set<String> LAYOUT_PROPERTIES = new HashSet<String>();
    private static final Set<String> TRANSFORM_PROPERTIES;
    private List<String> properties;
    private Interpolator interpolator;
    private long duration;
    private long delay;
    private WXComponent mWXComponent;
    private Handler handler;
    private ValueAnimator layoutValueAnimator;
    private Map<String, Object> layoutPendingUpdates;
    private ObjectAnimator transformAnimator;
    private Map<String, Object> transformPendingUpdates;
    private Runnable transitionEndEvent;
    private Map<String, Object> targetStyles;
    private Runnable animationRunnable;
    private Runnable transformAnimationRunnable;
    private volatile AtomicInteger lockToken;

    public WXTransition() {
        ArrayMap arrayMap;
        ArrayMap arrayMap2;
        ArrayMap arrayMap3;
        Handler handler;
        ArrayList arrayList;
        AtomicInteger atomicInteger;
        Object object = atomicInteger;
        atomicInteger = new AtomicInteger(0);
        v1.lockToken = object;
        object = arrayList;
        arrayList = new ArrayList(4);
        v1.properties = object;
        object = handler;
        handler = new Handler();
        v1.handler = object;
        object = arrayMap3;
        arrayMap3 = new ArrayMap();
        v1.layoutPendingUpdates = object;
        object = arrayMap2;
        arrayMap2 = new ArrayMap();
        v1.transformPendingUpdates = object;
        object = arrayMap;
        arrayMap = new ArrayMap();
        v1.targetStyles = object;
    }

    public static WXTransition fromMap(Map<String, Object> map, WXComponent wXComponent) {
        WXTransition wXTransition;
        if (map.get(TRANSITION_PROPERTY) == null) {
            return null;
        }
        String string2 = WXUtils.getString(map.get(TRANSITION_PROPERTY), null);
        if (string2 == null) {
            return null;
        }
        WXTransition wXTransition2 = wXTransition;
        wXTransition2();
        WXTransition.updateTransitionProperties(wXTransition, string2);
        if (wXTransition.properties.isEmpty()) {
            return null;
        }
        wXTransition2.duration = WXTransition.parseTimeMillis(map, TRANSITION_DURATION, 0L);
        wXTransition2.delay = WXTransition.parseTimeMillis(map, TRANSITION_DELAY, 0L);
        wXTransition2.interpolator = WXTransition.createTimeInterpolator(WXUtils.getString(map.get(TRANSITION_TIMING_FUNCTION), null));
        wXTransition2.mWXComponent = wXComponent;
        return wXTransition2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTransitionAnimation(final int n) {
        Runnable runnable;
        Object object;
        Object object2 = this.getTargetView();
        if (object2 == null) {
            return;
        }
        if (this.targetStyles.size() > 0) {
            object = this.properties.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!LAYOUT_PROPERTIES.contains(string2) && !TRANSFORM_PROPERTIES.contains(string2) || this.layoutPendingUpdates.containsKey(string2) || this.transformPendingUpdates.containsKey(string2)) continue;
                WXTransition wXTransition = this;
                Map<String, Object> map = wXTransition.targetStyles;
                synchronized (map) {
                    Throwable throwable2;
                    block10: {
                        try {
                            if (!wXTransition.targetStyles.containsKey(string2)) break block10;
                            WXTransition wXTransition2 = this;
                            Object object3 = wXTransition2.targetStyles.remove(string2);
                            wXTransition2.mWXComponent.getStyles().put(string2, object3);
                        }
                        catch (Throwable throwable2) {}
                    }
                    continue;
                    throw throwable2;
                }
            }
        }
        if ((object = this.transitionEndEvent) != null) {
            object2.removeCallbacks((Runnable)object);
        }
        if (this.transitionEndEvent == null && (float)this.duration > Float.MIN_NORMAL) {
            Runnable runnable2;
            object = runnable2;
            runnable2 = new Runnable(){

                @Override
                public void run() {
                    2 v0 = this;
                    WXTransition.access$302(v0.WXTransition.this, null);
                    if ((float)v0.WXTransition.this.duration < Float.MIN_NORMAL) {
                        return;
                    }
                    if (WXTransition.this.mWXComponent != null && ((AbstractCollection)WXTransition.this.mWXComponent.getEvents()).contains("transitionEnd")) {
                        WXTransition.this.mWXComponent.fireEvent("transitionEnd");
                    }
                }
            };
            this.transitionEndEvent = object;
        }
        if ((object = this.transformAnimationRunnable) != null) {
            object2.removeCallbacks((Runnable)object);
        }
        View view = object2;
        object2 = runnable;
        runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                3 v0 = this;
                AtomicInteger atomicInteger = v0.WXTransition.this.lockToken;
                synchronized (atomicInteger) {
                    Throwable throwable2;
                    block4: {
                        block3: {
                            try {
                                if (v0.n != WXTransition.this.lockToken.get()) break block3;
                                WXTransition.this.doPendingTransformAnimation(n);
                            }
                            catch (Throwable throwable2) {
                                break block4;
                            }
                        }
                        return;
                    }
                    throw throwable2;
                }
            }
        };
        this.transformAnimationRunnable = object2;
        view.post((Runnable)object2);
        this.doPendingLayoutAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doPendingTransformAnimation(int n) {
        Interpolator interpolator;
        ArrayList<PropertyValuesHolder> arrayList;
        ObjectAnimator objectAnimator = this.transformAnimator;
        if (objectAnimator != null) {
            objectAnimator.cancel();
            this.transformAnimator = null;
        }
        if (this.transformPendingUpdates.size() == 0) {
            return;
        }
        objectAnimator = this.getTargetView();
        if (objectAnimator == null) {
            return;
        }
        if (this.mWXComponent.getInstance() == null) {
            return;
        }
        ArrayList<PropertyValuesHolder> arrayList2 = arrayList;
        arrayList = new ArrayList<PropertyValuesHolder>(8);
        String string2 = WXUtils.getString(this.transformPendingUpdates.remove("transform"), null);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            void var7_24;
            float f = this.mWXComponent.getViewPortWidthForFloat();
            PropertyValuesHolder[] propertyValuesHolderArray = TransformParser.toHolders(TransformParser.parseTransForm(this.mWXComponent.getInstanceId(), string2, (int)this.mWXComponent.getLayoutWidth(), (int)this.mWXComponent.getLayoutHeight(), f));
            int n2 = propertyValuesHolderArray.length;
            boolean bl = false;
            while (var7_24 < n2) {
                arrayList2.add(propertyValuesHolderArray[var7_24]);
                ++var7_24;
            }
            Map<String, Object> map = this.targetStyles;
            // MONITORENTER : map
            this.targetStyles.put("transform", string2);
            // MONITOREXIT : map
        }
        for (String string3 : this.properties) {
            if (!TRANSFORM_PROPERTIES.contains(string3) || !this.transformPendingUpdates.containsKey(string3)) continue;
            String string4 = string3;
            Object object = this.transformPendingUpdates.remove(string3);
            Map<String, Object> map = this.targetStyles;
            // MONITORENTER : map
            this.targetStyles.put(string3, object);
            string4.hashCode();
            if (!string4.equals("opacity")) {
                void var5_14;
                ArgbEvaluator argbEvaluator;
                BackgroundColorProperty backgroundColorProperty;
                if (!string3.equals("backgroundColor")) continue;
                int n3 = WXResourceUtils.getColor(WXUtils.getString(this.mWXComponent.getStyles().getBackgroundColor(), null), 0);
                int n4 = WXResourceUtils.getColor(WXUtils.getString(object, null), 0);
                if (WXViewUtils.getBorderDrawable((View)objectAnimator) != null) {
                    int n5 = WXViewUtils.getBorderDrawable((View)objectAnimator).getColor();
                } else if (objectAnimator.getBackground() instanceof ColorDrawable) {
                    int n6 = ((ColorDrawable)objectAnimator.getBackground()).getColor();
                }
                BackgroundColorProperty backgroundColorProperty2 = backgroundColorProperty;
                backgroundColorProperty2();
                ArgbEvaluator argbEvaluator2 = argbEvaluator;
                argbEvaluator = new ArgbEvaluator();
                Integer n7 = (int)var5_14;
                Integer n8 = n4;
                Object[] objectArray = new Integer[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n7;
                objectArray[1] = n8;
                arrayList2.add(PropertyValuesHolder.ofObject((Property)backgroundColorProperty, (TypeEvaluator)argbEvaluator2, (Object[])objectArray2));
                continue;
            }
            float f = objectAnimator.getAlpha();
            float f2 = WXUtils.getFloat(object, Float.valueOf(1.0f)).floatValue();
            arrayList2.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{f, f2}));
            objectAnimator.setLayerType(1, null);
        }
        if (n == this.lockToken.get()) {
            this.transformPendingUpdates.clear();
        }
        ArrayList<PropertyValuesHolder> arrayList3 = arrayList2;
        this.transformAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)objectAnimator, (PropertyValuesHolder[])arrayList3.toArray(new PropertyValuesHolder[arrayList3.size()]));
        this.transformAnimator.setDuration(this.duration);
        long l = this.delay;
        if (l > 0L) {
            this.transformAnimator.setStartDelay(l);
        }
        if ((interpolator = this.interpolator) != null) {
            this.transformAnimator.setInterpolator((TimeInterpolator)interpolator);
        }
        this.transformAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean hasCancel = false;

            public void onAnimationCancel(Animator animator) {
                super.onAnimationCancel(animator);
                this.hasCancel = true;
            }

            public void onAnimationEnd(Animator animator) {
                if (this.hasCancel) {
                    return;
                }
                4 v0 = this;
                super.onAnimationEnd(animator);
                v0.WXTransition.this.onTransitionAnimationEnd();
            }
        });
        this.transformAnimator.start();
    }

    private PropertyValuesHolder createLayoutPropertyValueHolder(String string2, Object object) {
        String string3 = string2;
        Object object2 = null;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1970934485: {
                if (!string2.equals("marginLeft")) break;
                n = 13;
                break;
            }
            case 975087886: {
                if (!string2.equals("marginRight")) break;
                n = 12;
                break;
            }
            case 713848971: {
                if (!string2.equals("paddingRight")) break;
                n = 11;
                break;
            }
            case 202355100: {
                if (!string2.equals("paddingBottom")) break;
                n = 10;
                break;
            }
            case 113126854: {
                if (!string2.equals("width")) break;
                n = 9;
                break;
            }
            case 108511772: {
                if (!string2.equals("right")) break;
                n = 8;
                break;
            }
            case 90130308: {
                if (!string2.equals("paddingTop")) break;
                n = 7;
                break;
            }
            case 3317767: {
                if (!string2.equals("left")) break;
                n = 6;
                break;
            }
            case 115029: {
                if (!string2.equals("top")) break;
                n = 5;
                break;
            }
            case -289173127: {
                if (!string2.equals("marginBottom")) break;
                n = 4;
                break;
            }
            case -1044792121: {
                if (!string2.equals("marginTop")) break;
                n = 3;
                break;
            }
            case -1221029593: {
                if (!string2.equals("height")) break;
                n = 2;
                break;
            }
            case -1383228885: {
                if (!string2.equals("bottom")) break;
                n = 1;
                break;
            }
            case -1501175880: {
                if (!string2.equals("paddingLeft")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 13: {
                float f = ((WXTransition)object3).mWXComponent.getMargin().get(CSSShorthand.EDGE.LEFT);
                float f2 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f2;
                object2 = PropertyValuesHolder.ofFloat((String)"marginLeft", (float[])object2);
                break;
            }
            case 12: {
                float f = ((WXTransition)object3).mWXComponent.getMargin().get(CSSShorthand.EDGE.RIGHT);
                float f3 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f3;
                object2 = PropertyValuesHolder.ofFloat((String)"marginRight", (float[])object2);
                break;
            }
            case 11: {
                float f = ((WXTransition)object3).mWXComponent.getPadding().get(CSSShorthand.EDGE.RIGHT);
                float f4 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f4;
                object2 = PropertyValuesHolder.ofFloat((String)"paddingRight", (float[])object2);
                break;
            }
            case 10: {
                float f = ((WXTransition)object3).mWXComponent.getPadding().get(CSSShorthand.EDGE.BOTTOM);
                float f5 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f5;
                object2 = PropertyValuesHolder.ofFloat((String)"paddingBottom", (float[])object2);
                break;
            }
            case 9: {
                float f = ((WXTransition)object3).mWXComponent.getLayoutWidth();
                float f6 = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(object, Float.valueOf(0.0f)).floatValue(), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f6;
                object2 = PropertyValuesHolder.ofFloat((String)"width", (float[])object2);
                break;
            }
            case 8: {
                float f = ((WXTransition)object3).mWXComponent.getLayoutPosition().getRight();
                float f7 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f7;
                object2 = PropertyValuesHolder.ofFloat((String)"right", (float[])object2);
                break;
            }
            case 7: {
                float f = ((WXTransition)object3).mWXComponent.getPadding().get(CSSShorthand.EDGE.TOP);
                float f8 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f8;
                object2 = PropertyValuesHolder.ofFloat((String)"paddingTop", (float[])object2);
                break;
            }
            case 6: {
                float f = ((WXTransition)object3).mWXComponent.getLayoutPosition().getLeft();
                float f9 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f9;
                object2 = PropertyValuesHolder.ofFloat((String)"left", (float[])object2);
                break;
            }
            case 5: {
                float f = ((WXTransition)object3).mWXComponent.getLayoutPosition().getTop();
                float f10 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f10;
                object2 = PropertyValuesHolder.ofFloat((String)"top", (float[])object2);
                break;
            }
            case 4: {
                float f = ((WXTransition)object3).mWXComponent.getMargin().get(CSSShorthand.EDGE.BOTTOM);
                float f11 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f11;
                object2 = PropertyValuesHolder.ofFloat((String)"marginBottom", (float[])object2);
                break;
            }
            case 3: {
                float f = ((WXTransition)object3).mWXComponent.getMargin().get(CSSShorthand.EDGE.TOP);
                float f12 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f12;
                object2 = PropertyValuesHolder.ofFloat((String)"marginTop", (float[])object2);
                break;
            }
            case 2: {
                float f = ((WXTransition)object3).mWXComponent.getLayoutHeight();
                float f13 = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(object, Float.valueOf(0.0f)).floatValue(), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f13;
                object2 = PropertyValuesHolder.ofFloat((String)"height", (float[])object2);
                break;
            }
            case 1: {
                float f = ((WXTransition)object3).mWXComponent.getLayoutPosition().getBottom();
                float f14 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f14;
                object2 = PropertyValuesHolder.ofFloat((String)"bottom", (float[])object2);
                break;
            }
            case 0: {
                float f = ((WXTransition)object3).mWXComponent.getPadding().get(CSSShorthand.EDGE.LEFT);
                float f15 = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(object, ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat()), ((WXTransition)object3).mWXComponent.getViewPortWidthForFloat());
                float[] fArray = new float[2];
                object2 = fArray;
                fArray[0] = f;
                fArray[1] = f15;
                object2 = PropertyValuesHolder.ofFloat((String)"paddingLeft", (float[])object2);
            }
        }
        if (object2 == null) {
            float[] fArray = new float[2];
            Object object3 = fArray;
            fArray[0] = 1.0f;
            fArray[1] = 1.0f;
            object2 = PropertyValuesHolder.ofFloat((String)string2, (float[])object3);
        }
        return object2;
    }

    private void doLayoutPropertyValuesHolderAnimation(PropertyValuesHolder[] interpolator) {
        WXTransition wXTransition = this;
        this.layoutValueAnimator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])interpolator);
        this.layoutValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                PropertyValuesHolder[] propertyValuesHolderArray = valueAnimator.getValues();
                int n = propertyValuesHolderArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = propertyValuesHolderArray[i].getPropertyName();
                    WXTransition.asynchronouslyUpdateLayout(WXTransition.this.mWXComponent, string2, ((Float)valueAnimator.getAnimatedValue(string2)).floatValue());
                }
            }
        });
        wXTransition.layoutValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean hasCancel = false;

            public void onAnimationCancel(Animator animator) {
                super.onAnimationCancel(animator);
                this.hasCancel = true;
            }

            public void onAnimationEnd(Animator animator) {
                if (this.hasCancel) {
                    return;
                }
                6 v0 = this;
                super.onAnimationEnd(animator);
                v0.WXTransition.this.onTransitionAnimationEnd();
            }
        });
        interpolator = wXTransition.interpolator;
        if (interpolator != null) {
            this.layoutValueAnimator.setInterpolator((TimeInterpolator)interpolator);
        }
        WXTransition wXTransition2 = this;
        wXTransition2.layoutValueAnimator.setStartDelay(this.delay);
        wXTransition2.layoutValueAnimator.setDuration(this.duration);
        wXTransition2.layoutValueAnimator.start();
    }

    public static void asynchronouslyUpdateLayout(WXComponent object, final String string2, float f) {
        if (object != null && ((WXComponent)object).getInstance() != null) {
            WXComponent wXComponent = object;
            object = wXComponent.getRef();
            final String string3 = wXComponent.getInstanceId();
            if (!TextUtils.isEmpty((CharSequence)object) && !TextUtils.isEmpty((CharSequence)string3)) {
                WXSDKManager.getInstance().getWXBridgeManager().post(new Runnable(){
                    final /* synthetic */ String val$ref;
                    final /* synthetic */ float val$propertyValue;
                    {
                        this.val$ref = string4;
                        this.val$propertyValue = f;
                    }

                    @Override
                    public void run() {
                        String string22 = string2;
                        string22.hashCode();
                        int n = -1;
                        switch (string22.hashCode()) {
                            default: {
                                break;
                            }
                            case 1970934485: {
                                if (!string22.equals("marginLeft")) break;
                                n = 13;
                                break;
                            }
                            case 975087886: {
                                if (!string22.equals("marginRight")) break;
                                n = 12;
                                break;
                            }
                            case 713848971: {
                                if (!string22.equals("paddingRight")) break;
                                n = 11;
                                break;
                            }
                            case 202355100: {
                                if (!string22.equals("paddingBottom")) break;
                                n = 10;
                                break;
                            }
                            case 113126854: {
                                if (!string22.equals("width")) break;
                                n = 9;
                                break;
                            }
                            case 108511772: {
                                if (!string22.equals("right")) break;
                                n = 8;
                                break;
                            }
                            case 90130308: {
                                if (!string22.equals("paddingTop")) break;
                                n = 7;
                                break;
                            }
                            case 3317767: {
                                if (!string22.equals("left")) break;
                                n = 6;
                                break;
                            }
                            case 115029: {
                                if (!string22.equals("top")) break;
                                n = 5;
                                break;
                            }
                            case -289173127: {
                                if (!string22.equals("marginBottom")) break;
                                n = 4;
                                break;
                            }
                            case -1044792121: {
                                if (!string22.equals("marginTop")) break;
                                n = 3;
                                break;
                            }
                            case -1221029593: {
                                if (!string22.equals("height")) break;
                                n = 2;
                                break;
                            }
                            case -1383228885: {
                                if (!string22.equals("bottom")) break;
                                n = 1;
                                break;
                            }
                            case -1501175880: {
                                if (!string22.equals("paddingLeft")) break;
                                n = 0;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 13: {
                                WXBridgeManager.getInstance().setMargin(string3, this.val$ref, CSSShorthand.EDGE.LEFT, this.val$propertyValue);
                                break;
                            }
                            case 12: {
                                WXBridgeManager.getInstance().setMargin(string3, this.val$ref, CSSShorthand.EDGE.RIGHT, this.val$propertyValue);
                                break;
                            }
                            case 11: {
                                WXBridgeManager.getInstance().setPadding(string3, this.val$ref, CSSShorthand.EDGE.RIGHT, this.val$propertyValue);
                                break;
                            }
                            case 10: {
                                WXBridgeManager.getInstance().setPadding(string3, this.val$ref, CSSShorthand.EDGE.BOTTOM, this.val$propertyValue);
                                break;
                            }
                            case 9: {
                                WXBridgeManager.getInstance().setStyleWidth(string3, this.val$ref, this.val$propertyValue);
                                break;
                            }
                            case 8: {
                                WXBridgeManager.getInstance().setPosition(string3, this.val$ref, CSSShorthand.EDGE.RIGHT, this.val$propertyValue);
                                break;
                            }
                            case 7: {
                                WXBridgeManager.getInstance().setPadding(string3, this.val$ref, CSSShorthand.EDGE.TOP, this.val$propertyValue);
                                break;
                            }
                            case 6: {
                                WXBridgeManager.getInstance().setPosition(string3, this.val$ref, CSSShorthand.EDGE.LEFT, this.val$propertyValue);
                                break;
                            }
                            case 5: {
                                WXBridgeManager.getInstance().setPosition(string3, this.val$ref, CSSShorthand.EDGE.TOP, this.val$propertyValue);
                                break;
                            }
                            case 4: {
                                WXBridgeManager.getInstance().setMargin(string3, this.val$ref, CSSShorthand.EDGE.BOTTOM, this.val$propertyValue);
                                break;
                            }
                            case 3: {
                                WXBridgeManager.getInstance().setMargin(string3, this.val$ref, CSSShorthand.EDGE.TOP, this.val$propertyValue);
                                break;
                            }
                            case 2: {
                                WXBridgeManager.getInstance().setStyleHeight(string3, this.val$ref, this.val$propertyValue);
                                break;
                            }
                            case 1: {
                                WXBridgeManager.getInstance().setPosition(string3, this.val$ref, CSSShorthand.EDGE.BOTTOM, this.val$propertyValue);
                                break;
                            }
                            case 0: {
                                WXBridgeManager.getInstance().setPadding(string3, this.val$ref, CSSShorthand.EDGE.LEFT, this.val$propertyValue);
                            }
                        }
                    }
                });
                return;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void onTransitionAnimationEnd() {
        View view;
        if (this.duration > 0L && this.transitionEndEvent != null) {
            Object object;
            view = this.getTargetView();
            if (view != null && (object = this.transitionEndEvent) != null) {
                view.post((Runnable)object);
            }
            this.transitionEndEvent = null;
        }
        WXTransition wXTransition = this;
        view = wXTransition.targetStyles;
        synchronized (view) {
            Throwable throwable2;
            block8: {
                block7: {
                    try {
                        if (wXTransition.targetStyles.size() <= 0) break block7;
                        for (String string2 : this.properties) {
                            if (!this.targetStyles.containsKey(string2)) continue;
                            WXTransition wXTransition2 = this;
                            Object object = wXTransition2.targetStyles.remove(string2);
                            wXTransition2.mWXComponent.getStyles().put(string2, object);
                        }
                    }
                    catch (Throwable throwable2) {
                        break block8;
                    }
                    {
                        continue;
                    }
                    this.targetStyles.clear();
                }
                return;
            }
            throw throwable2;
        }
    }

    private View getTargetView() {
        WXComponent wXComponent = ((WXTransition)((Object)wXComponent)).mWXComponent;
        return wXComponent != null ? (View)wXComponent.getHostView() : null;
    }

    private static long parseTimeMillis(Map<String, Object> object, String string2, long l) {
        if ((object = WXUtils.getString(object.get(string2), null)) != null) {
            object = ((String)object).replaceAll("ms", "");
        }
        if (object != null) {
            if (WXEnvironment.isApkDebugable() && ((String)object).contains("px")) {
                WXLogUtils.w("Transition Duration Unit Only Support ms, " + (String)object + " is not ms Unit");
            }
            object = ((String)object).replaceAll("px", "");
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            return l;
        }
        try {
            return (long)Float.parseFloat((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    private static Interpolator createTimeInterpolator(String list) {
        if (!TextUtils.isEmpty((CharSequence)((Object)list))) {
            String string2 = list;
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 3105774: {
                    if (!((String)((Object)list)).equals("ease")) break;
                    n = 4;
                    break;
                }
                case -361990811: {
                    if (!((String)((Object)list)).equals("ease-in-out")) break;
                    n = 3;
                    break;
                }
                case -789192465: {
                    if (!((String)((Object)list)).equals("ease-out")) break;
                    n = 2;
                    break;
                }
                case -1102672091: {
                    if (!((String)((Object)list)).equals("linear")) break;
                    n = 1;
                    break;
                }
                case -1965120668: {
                    if (!((String)((Object)list)).equals("ease-in")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    SingleFunctionParser.FlatMapper<Float> flatMapper;
                    String string3;
                    SingleFunctionParser singleFunctionParser;
                    SingleFunctionParser singleFunctionParser2;
                    try {
                        SingleFunctionParser singleFunctionParser3;
                        singleFunctionParser2 = singleFunctionParser3;
                        singleFunctionParser = singleFunctionParser3;
                        string3 = list;
                    }
                    catch (RuntimeException runtimeException) {
                        if (!WXEnvironment.isApkDebugable()) break;
                        WXLogUtils.e("WXTransition", runtimeException);
                        break;
                    }
                    list = flatMapper;
                    flatMapper = new SingleFunctionParser.FlatMapper<Float>(){

                        @Override
                        public Float map(String string2) {
                            return Float.valueOf(Float.parseFloat(string2));
                        }
                    };
                    singleFunctionParser2(string3, list);
                    list = singleFunctionParser.parse("cubic-bezier");
                    if (list == null) break;
                    if (list.size() != 4) break;
                    float f = ((Float)list.get(0)).floatValue();
                    List list2 = list;
                    List list3 = list2;
                    List list4 = list2;
                    float f2 = ((Float)list2.get(1)).floatValue();
                    float f3 = ((Float)list4.get(2)).floatValue();
                    float f4 = ((Float)list3.get(3)).floatValue();
                    return PathInterpolatorCompat.create((float)f, (float)f2, (float)f3, (float)f4);
                }
                case 4: {
                    return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
                }
                case 3: {
                    return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)0.58f, (float)1.0f);
                }
                case 2: {
                    return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)0.58f, (float)1.0f);
                }
                case 1: {
                    return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
                case 0: {
                    return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
        return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
    }

    private static void updateTransitionProperties(WXTransition wXTransition, String string2) {
        if (string2 == null) {
            return;
        }
        wXTransition.properties.clear();
        String[] stringArray = PROPERTY_SPLIT_PATTERN.split(string2);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i].trim();
            if (TextUtils.isEmpty((CharSequence)string3)) continue;
            if (!LAYOUT_PROPERTIES.contains(string3) && !TRANSFORM_PROPERTIES.contains(string3)) {
                if (!WXEnvironment.isApkDebugable()) continue;
                WXLogUtils.e("WXTransition Property Not Supported" + string3 + " in " + string2);
                continue;
            }
            wXTransition.properties.add(string3);
        }
    }

    static /* synthetic */ Runnable access$202(WXTransition wXTransition, Runnable runnable) {
        wXTransition.animationRunnable = runnable;
        return runnable;
    }

    static /* synthetic */ Runnable access$302(WXTransition wXTransition, Runnable runnable) {
        wXTransition.transitionEndEvent = runnable;
        return runnable;
    }

    static {
        LAYOUT_PROPERTIES.add("width");
        LAYOUT_PROPERTIES.add("height");
        LAYOUT_PROPERTIES.add("marginTop");
        LAYOUT_PROPERTIES.add("marginBottom");
        LAYOUT_PROPERTIES.add("marginLeft");
        LAYOUT_PROPERTIES.add("marginRight");
        LAYOUT_PROPERTIES.add("left");
        LAYOUT_PROPERTIES.add("right");
        LAYOUT_PROPERTIES.add("top");
        LAYOUT_PROPERTIES.add("bottom");
        LAYOUT_PROPERTIES.add("paddingLeft");
        LAYOUT_PROPERTIES.add("paddingRight");
        LAYOUT_PROPERTIES.add("paddingTop");
        LAYOUT_PROPERTIES.add("paddingBottom");
        TRANSFORM_PROPERTIES = new HashSet<String>();
        TRANSFORM_PROPERTIES.add("opacity");
        TRANSFORM_PROPERTIES.add("backgroundColor");
        TRANSFORM_PROPERTIES.add("transform");
    }

    public boolean hasTransitionProperty(Map<String, Object> map) {
        Iterator<String> iterator = ((WXTransition)((Object)iterator)).properties.iterator();
        while (iterator.hasNext()) {
            if (!map.containsKey((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void updateTranstionParams(Map<String, Object> map) {
        if (map.containsKey(TRANSITION_DELAY)) {
            WXTransition wXTransition = this;
            wXTransition.mWXComponent.getStyles().put(TRANSITION_DELAY, map.remove(TRANSITION_DELAY));
            wXTransition.delay = WXTransition.parseTimeMillis(wXTransition.mWXComponent.getStyles(), TRANSITION_DELAY, 0L);
        }
        if (map.containsKey(TRANSITION_TIMING_FUNCTION) && map.get(TRANSITION_TIMING_FUNCTION) != null) {
            WXTransition wXTransition = this;
            wXTransition.mWXComponent.getStyles().put(TRANSITION_TIMING_FUNCTION, map.remove(TRANSITION_TIMING_FUNCTION));
            wXTransition.interpolator = WXTransition.createTimeInterpolator(wXTransition.mWXComponent.getStyles().get(TRANSITION_TIMING_FUNCTION).toString());
        }
        if (map.containsKey(TRANSITION_DURATION)) {
            WXTransition wXTransition = this;
            wXTransition.mWXComponent.getStyles().put(TRANSITION_DURATION, map.remove(TRANSITION_DURATION));
            wXTransition.duration = WXTransition.parseTimeMillis(wXTransition.mWXComponent.getStyles(), TRANSITION_DURATION, 0L);
        }
        if (map.containsKey(TRANSITION_PROPERTY)) {
            WXTransition wXTransition = this;
            wXTransition.mWXComponent.getStyles().put(TRANSITION_PROPERTY, map.remove(TRANSITION_PROPERTY));
            WXTransition.updateTransitionProperties(wXTransition, WXUtils.getString(wXTransition.mWXComponent.getStyles().get(TRANSITION_PROPERTY), null));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startTransition(Map<String, Object> var1_1) {
        v0 = this;
        var2_3 = v0.lockToken;
        synchronized (var2_3) {
            block13: {
                block12: {
                    try {
                        if (v0.getTargetView() == null) {
                            return;
                        }
                        v1 = this;
                        var3_4 = v1.lockToken.incrementAndGet();
                        var4_5 = v1.properties.iterator();
                    }
                    catch (Throwable v2) {}
                    throw v2;
                    while (var4_5.hasNext()) {
                        v3 = var1_1;
                        var5_8 = var4_5.next();
                        if (!v3.containsKey(var5_8)) continue;
                        var6_9 = var1_1.remove(var5_8);
                        if (!WXTransition.LAYOUT_PROPERTIES.contains(var5_8)) ** GOTO lbl-1000
                        v4 = this.layoutPendingUpdates.put(var5_8, var6_9);
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            if (!WXTransition.TRANSFORM_PROPERTIES.contains(var5_8)) continue;
                            v4 = this.transformPendingUpdates.put(var5_8, var6_9);
                        }
                    }
                    var1_2 = WXUtils.getNumberInt(this.mWXComponent.getAttrs().get("actionDelay"), 16);
                    if ((long)var1_2 <= (var4_6 = this.duration)) ** GOTO lbl-1000
                    var1_2 = (int)var4_6;
lbl-1000:
                    // 2 sources

                    {
                        if ((var4_7 = this.animationRunnable) == null) ** GOTO lbl29
                    }
                    {
                        this.handler.removeCallbacks(var4_7);
lbl29:
                        // 2 sources

                        v5 = var1_2;
                        v6 = this;
                    }
                    var4_7 = v7;
                    {
                        v7 = new Runnable(){

                            @Override
                            public void run() {
                                if (var3_4 == WXTransition.this.lockToken.get()) {
                                    WXTransition.this.doTransitionAnimation(var3_4);
                                }
                                WXTransition.access$202(WXTransition.this, null);
                            }
                        };
                        v6.animationRunnable = var4_7;
                        if (v5 <= 0) break block12;
                        this.handler.postDelayed(var4_7, (long)var1_2);
                    }
                    break block13;
                }
                var4_7.run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPendingLayoutAnimation() {
        PropertyValuesHolder[] propertyValuesHolderArray = this.layoutValueAnimator;
        if (this.layoutValueAnimator != null) {
            propertyValuesHolderArray.cancel();
            this.layoutValueAnimator = null;
        }
        if (this.layoutPendingUpdates.size() == 0) {
            return;
        }
        WXTransition wXTransition = this;
        propertyValuesHolderArray = new PropertyValuesHolder[wXTransition.layoutPendingUpdates.size()];
        int n = 0;
        if (wXTransition.properties.size() == 0) {
            return;
        }
        for (String string2 : this.properties) {
            if (!LAYOUT_PROPERTIES.contains(string2) || !this.layoutPendingUpdates.containsKey(string2)) continue;
            WXTransition wXTransition2 = this;
            Object object = wXTransition2.layoutPendingUpdates.remove(string2);
            Map<String, Object> map = wXTransition2.targetStyles;
            synchronized (map) {
                this.targetStyles.put(string2, object);
                // MONITOREXIT @DISABLED, blocks:[1, 2, 4] lbl24 : MonitorExitStatement: MONITOREXIT : var6_6
                propertyValuesHolderArray[n] = this.createLayoutPropertyValueHolder(string2, object);
                ++n;
            }
        }
        this.layoutPendingUpdates.clear();
        this.doLayoutPropertyValuesHolderAnimation(propertyValuesHolderArray);
    }

    public List<String> getProperties() {
        return this.properties;
    }
}

