/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.utils.WXLogUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WXSQLiteOpenHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "WXStorage";
    private static final int DATABASE_VERSION = 2;
    static final String TAG_STORAGE = "weex_storage";
    static SimpleDateFormat sDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    static final String TABLE_STORAGE = "default_wx_storage";
    static final String COLUMN_KEY = "key";
    static final String COLUMN_VALUE = "value";
    static final String COLUMN_TIMESTAMP = "timestamp";
    static final String COLUMN_PERSISTENT = "persistent";
    private static final int SLEEP_TIME_MS = 30;
    private static final String STATEMENT_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS default_wx_storage (key TEXT PRIMARY KEY,value TEXT NOT NULL,timestamp TEXT NOT NULL,persistent INTEGER DEFAULT 0)";
    private long mMaximumDatabaseSize = 0x3200000L;
    private Context mContext;
    private SQLiteDatabase mDb;

    public WXSQLiteOpenHelper(Context context) {
        super(context, DATABASE_NAME, null, 2);
        this.mContext = context;
    }

    private boolean deleteDB() {
        WXSQLiteOpenHelper wXSQLiteOpenHelper = this;
        wXSQLiteOpenHelper.closeDatabase();
        return wXSQLiteOpenHelper.mContext.deleteDatabase(DATABASE_NAME);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTableIfNotExists(@NonNull SQLiteDatabase sQLiteDatabase) {
        Throwable throwable2;
        block8: {
            block7: {
                block6: {
                    WXSQLiteOpenHelper wXSQLiteOpenHelper = null;
                    wXSQLiteOpenHelper = sQLiteDatabase.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = 'default_wx_storage'", null);
                    if (wXSQLiteOpenHelper == null || wXSQLiteOpenHelper.getCount() <= 0) break block6;
                    wXSQLiteOpenHelper.close();
                    return;
                }
                try {
                    sQLiteDatabase.execSQL(STATEMENT_CREATE_TABLE);
                    if (wXSQLiteOpenHelper == null) return;
                    break block7;
                }
                catch (Throwable throwable2) {
                    break block8;
                }
                catch (Exception exception) {}
                {
                    exception.printStackTrace();
                    if (wXSQLiteOpenHelper == null) return;
                }
            }
            wXSQLiteOpenHelper.close();
            return;
        }
        if (wXSQLiteOpenHelper == null) throw throwable2;
        wXSQLiteOpenHelper.close();
        throw throwable2;
    }

    @Nullable
    public SQLiteDatabase getDatabase() {
        WXSQLiteOpenHelper wXSQLiteOpenHelper = this;
        wXSQLiteOpenHelper.ensureDatabase();
        return wXSQLiteOpenHelper.mDb;
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL(STATEMENT_CREATE_TABLE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        if (n == n2) return;
        if (n2 == 2 && n == 1) {
            Throwable throwable2;
            block9: {
                String string2;
                String string3;
                SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
                WXLogUtils.d(TAG_STORAGE, "storage is updating from version " + n + " to version " + n2);
                long l = System.currentTimeMillis();
                sQLiteDatabase2.beginTransaction();
                String string4 = string3 = "ALTER TABLE default_wx_storage ADD COLUMN timestamp TEXT;";
                {
                    WXSQLiteOpenHelper wXSQLiteOpenHelper;
                    SQLiteDatabase sQLiteDatabase3;
                    WXSQLiteOpenHelper wXSQLiteOpenHelper2;
                    catch (Throwable throwable2) {
                        break block9;
                    }
                    catch (Exception exception) {}
                    {
                        wXSQLiteOpenHelper2 = this;
                        sQLiteDatabase3 = sQLiteDatabase;
                        wXSQLiteOpenHelper = this;
                        WXLogUtils.d(TAG_STORAGE, "storage updated failed from version " + n + " to version " + n2 + "," + exception.getMessage());
                        sQLiteDatabase.endTransaction();
                    }
                    WXLogUtils.d(TAG_STORAGE, "storage is rollback,all data will be removed");
                    wXSQLiteOpenHelper.deleteDB();
                    wXSQLiteOpenHelper2.onCreate(sQLiteDatabase3);
                    return;
                }
                {
                    WXLogUtils.d(TAG_STORAGE, "exec sql : " + string3);
                    sQLiteDatabase2.execSQL(string4);
                    string2 = string3 = "ALTER TABLE default_wx_storage ADD COLUMN persistent INTEGER;";
                }
                {
                    WXLogUtils.d(TAG_STORAGE, "exec sql : " + string3);
                    sQLiteDatabase2.execSQL(string2);
                    string3 = "UPDATE default_wx_storage SET timestamp = '" + sDateFormatter.format(new Date()) + "' , " + COLUMN_PERSISTENT + " = 0";
                }
                {
                    WXLogUtils.d(TAG_STORAGE, "exec sql : " + string3);
                    sQLiteDatabase2.execSQL(string3);
                    sQLiteDatabase2.setTransactionSuccessful();
                    l = System.currentTimeMillis() - l;
                }
                {
                    WXLogUtils.d(TAG_STORAGE, "storage updated success (" + l + "ms)");
                }
                sQLiteDatabase2.endTransaction();
                return;
            }
            sQLiteDatabase.endTransaction();
            throw throwable2;
        }
        WXSQLiteOpenHelper wXSQLiteOpenHelper = this;
        wXSQLiteOpenHelper.deleteDB();
        wXSQLiteOpenHelper.onCreate(sQLiteDatabase);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void ensureDatabase() {
        Throwable throwable222;
        SQLiteDatabase sQLiteDatabase = this.mDb;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            return;
        }
        int n = 0;
        while (true) {
            SQLiteDatabase sQLiteDatabase2;
            block14: {
                if (n < 2) {
                    if (n > 0) {
                        this.deleteDB();
                    }
                    this.mDb = this.getWritableDatabase();
                }
                sQLiteDatabase2 = this.mDb;
                if (sQLiteDatabase2 != null) break block14;
                return;
                {
                    catch (Throwable throwable222) {
                        break;
                    }
                }
            }
            WXSQLiteOpenHelper wXSQLiteOpenHelper = this;
            wXSQLiteOpenHelper.createTableIfNotExists(sQLiteDatabase2);
            wXSQLiteOpenHelper.mDb.setMaximumSize(this.mMaximumDatabaseSize);
            return;
            {
                catch (SQLiteException sQLiteException) {}
                sQLiteException.printStackTrace();
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
                {
                    Thread.currentThread().interrupt();
                }
            }
            ++n;
        }
        this.mDb = null;
        WXLogUtils.d(TAG_STORAGE, "ensureDatabase failed, throwable = " + throwable222.getMessage());
    }

    public synchronized void setMaximumSize(long l) {
        wXSQLiteOpenHelper.mMaximumDatabaseSize = l;
        WXSQLiteOpenHelper wXSQLiteOpenHelper = wXSQLiteOpenHelper.mDb;
        if (wXSQLiteOpenHelper != null) {
            wXSQLiteOpenHelper.setMaximumSize(l);
        }
    }

    public synchronized void closeDatabase() {
        SQLiteDatabase sQLiteDatabase = this.mDb;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            this.mDb.close();
            this.mDb = null;
        }
    }
}

