/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.InitConfig;
import com.taobao.weex.Script;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.ClassLoaderAdapter;
import com.taobao.weex.adapter.DefaultUriAdapter;
import com.taobao.weex.adapter.DefaultWXHttpAdapter;
import com.taobao.weex.adapter.ICrashInfoReporter;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.ITracingAdapter;
import com.taobao.weex.adapter.IWXAccessibilityRoleAdapter;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXJsFileLoaderAdapter;
import com.taobao.weex.adapter.IWXJscProcessManager;
import com.taobao.weex.adapter.IWXSoLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.navigator.INavigator;
import com.taobao.weex.appfram.storage.DefaultWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.bridge.IDCVueBridgeAdapter;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.common.WXWorkThreadManager;
import com.taobao.weex.font.FontAdapter;
import com.taobao.weex.performance.IApmGenerator;
import com.taobao.weex.performance.IWXAnalyzer;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class WXSDKManager {
    private static volatile WXSDKManager sManager;
    private static AtomicInteger sInstanceId;
    private static final int DEFAULT_VIEWPORT_WIDTH = 750;
    private final WXWorkThreadManager mWXWorkThreadManager;
    private WXBridgeManager mBridgeManager;
    WXRenderManager mWXRenderManager;
    private IWXUserTrackAdapter mIWXUserTrackAdapter;
    private IWXImgLoaderAdapter mIWXImgLoaderAdapter;
    private IWXSoLoaderAdapter mIWXSoLoaderAdapter;
    private IDrawableLoader mDrawableLoader;
    private IWXHttpAdapter mIWXHttpAdapter;
    private IActivityNavBarSetter mActivityNavBarSetter;
    private IWXAccessibilityRoleAdapter mRoleAdapter;
    private List<IWXAnalyzer> mWXAnalyzerList;
    private IApmGenerator mApmGenerater;
    private IWXJsFileLoaderAdapter mWXJsFileLoaderAdapter;
    private ICrashInfoReporter mCrashInfo;
    private IWXJSExceptionAdapter mIWXJSExceptionAdapter;
    private IWXConfigAdapter mConfigAdapter;
    private IWXStorageAdapter mIWXStorageAdapter;
    private IWXStatisticsListener mStatisticsListener;
    private URIAdapter mURIAdapter;
    private IDCVueBridgeAdapter mVueBridgeAdapter;
    private ClassLoaderAdapter mClassLoaderAdapter;
    private IWebSocketAdapterFactory mIWebSocketAdapterFactory;
    private ITracingAdapter mTracingAdapter;
    private WXValidateProcessor mWXValidateProcessor;
    private IWXJscProcessManager mWXJscProcessManager;
    private boolean mNeedInitV8;
    private Map<String, WXSDKInstance> mAllInstanceMap;
    private List<InstanceLifeCycleCallbacks> mLifeCycleCallbacks;
    private INavigator mNavigator;
    private FontAdapter mFontAdapter;

    private WXSDKManager() {
        WXRenderManager wXRenderManager;
        WXSDKManager wXSDKManager = wXRenderManager2;
        WXRenderManager wXRenderManager2 = wXRenderManager;
        wXRenderManager = new WXRenderManager();
        wXSDKManager(wXRenderManager2);
    }

    private WXSDKManager(WXRenderManager wXRenderManager) {
        WXSDKManager wXSDKManager = this;
        this.mNeedInitV8 = true;
        wXSDKManager.mWXRenderManager = wXRenderManager;
        wXSDKManager.mBridgeManager = WXBridgeManager.getInstance();
        wXSDKManager.mWXWorkThreadManager = new WXWorkThreadManager();
        wXSDKManager.mWXAnalyzerList = new CopyOnWriteArrayList<IWXAnalyzer>();
        wXSDKManager.mAllInstanceMap = new HashMap<String, WXSDKInstance>();
    }

    static void initInstance(WXRenderManager wXRenderManager) {
        sManager = new WXSDKManager(wXRenderManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WXSDKManager getInstance() {
        if (sManager != null) return sManager;
        Class<WXSDKManager> clazz = WXSDKManager.class;
        synchronized (WXSDKManager.class) {
            try {
                if (sManager != null) return sManager;
                sManager = new WXSDKManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    public static float getInstanceViewPortWidth(String object) {
        object = WXSDKManager.getInstance().getSDKInstance((String)object);
        if (object == null) {
            return 750.0f;
        }
        return ((WXSDKInstance)object).getInstanceViewPortWidthWithFloat();
    }

    static void setInstance(WXSDKManager wXSDKManager) {
        sManager = wXSDKManager;
    }

    static {
        sInstanceId = new AtomicInteger(0);
    }

    public void registerStatisticsListener(IWXStatisticsListener iWXStatisticsListener) {
        this.mStatisticsListener = iWXStatisticsListener;
    }

    public IWXStatisticsListener getWXStatisticsListener() {
        return this.mStatisticsListener;
    }

    public void onSDKEngineInitialize() {
        IWXStatisticsListener iWXStatisticsListener = ((WXSDKManager)((Object)iWXStatisticsListener)).mStatisticsListener;
        if (iWXStatisticsListener != null) {
            iWXStatisticsListener.onSDKEngineInitialize();
        }
    }

    public void setNeedInitV8(boolean bl) {
        this.mNeedInitV8 = bl;
    }

    public boolean needInitV8() {
        return this.mNeedInitV8;
    }

    public void takeJSHeapSnapshot(String string) {
        File file;
        Object object = file;
        if (!new File(string).exists() && !((File)object).mkdir()) {
            return;
        }
        object = String.valueOf(sInstanceId.get());
        String string2 = File.separator;
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        WXSDKManager wXSDKManager = object2;
        Object object2 = string + (String)object;
        object2 = (String)object2 + ".heapsnapshot";
        wXSDKManager.mBridgeManager.takeJSHeapSnapshot((String)object2);
    }

    public IActivityNavBarSetter getActivityNavBarSetter() {
        return this.mActivityNavBarSetter;
    }

    public void setActivityNavBarSetter(IActivityNavBarSetter iActivityNavBarSetter) {
        this.mActivityNavBarSetter = iActivityNavBarSetter;
    }

    public void restartBridge() {
        this.mBridgeManager.restart();
    }

    public WXBridgeManager getWXBridgeManager() {
        return this.mBridgeManager;
    }

    public WXRenderManager getWXRenderManager() {
        return this.mWXRenderManager;
    }

    public IWXJscProcessManager getWXJscProcessManager() {
        return this.mWXJscProcessManager;
    }

    public WXWorkThreadManager getWXWorkThreadManager() {
        return this.mWXWorkThreadManager;
    }

    public void setWxConfigAdapter(IWXConfigAdapter iWXConfigAdapter) {
        this.mConfigAdapter = iWXConfigAdapter;
    }

    public IWXConfigAdapter getWxConfigAdapter() {
        return this.mConfigAdapter;
    }

    @Nullable
    public WXSDKInstance getSDKInstance(String string) {
        return string == null ? null : this.mWXRenderManager.getWXSDKInstance(string);
    }

    public void postOnUiThread(Runnable runnable, long l) {
        this.mWXRenderManager.postOnUiThread(WXThread.secure(runnable), l);
    }

    public Map<String, WXSDKInstance> getAllInstanceMap() {
        return this.mAllInstanceMap;
    }

    public void destroy() {
        WXWorkThreadManager wXWorkThreadManager = this.mWXWorkThreadManager;
        if (wXWorkThreadManager != null) {
            wXWorkThreadManager.destroy();
        }
        this.mAllInstanceMap.clear();
    }

    @Deprecated
    public void callback(String string, String string2, Map<String, Object> map) {
        this.mBridgeManager.callback(string, string2, map);
    }

    @Deprecated
    public void callback(String string, String string2, Map<String, Object> map, boolean bl) {
        this.mBridgeManager.callback(string, string2, map, bl);
    }

    public void initScriptsFramework(String string) {
        this.mBridgeManager.initScriptsFramework(string);
    }

    public void registerComponents(List<Map<String, Object>> list) {
        this.mBridgeManager.registerComponents(list);
    }

    public void registerModules(Map<String, Object> map) {
        this.mBridgeManager.registerModules(map);
    }

    @Deprecated
    public void fireEvent(String string, String string2, String string3) {
        HashMap hashMap;
        WXSDKManager wXSDKManager = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        wXSDKManager.fireEvent(string, string2, string3, hashMap2);
    }

    @Deprecated
    public void fireEvent(String string, String string2, String string3, Map<String, Object> map) {
        this.fireEvent(string, string2, string3, map, null);
    }

    @Deprecated
    public void fireEvent(String string, String string2, String string3, Map<String, Object> map, Map<String, Object> map2) {
        if (WXEnvironment.isApkDebugable() && Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            throw new WXRuntimeException("[WXSDKManager]  fireEvent error");
        }
        this.mBridgeManager.fireEventOnNode(string, string2, string3, map, map2);
    }

    void createInstance(WXSDKInstance wXSDKInstance, Script script, Map<String, Object> map, String string) {
        WXSDKManager wXSDKManager = iterator;
        wXSDKManager.mWXRenderManager.registerInstance(wXSDKInstance);
        wXSDKManager.mBridgeManager.createInstance(wXSDKInstance.getInstanceId(), script, map, string);
        Iterator iterator = wXSDKManager.mLifeCycleCallbacks;
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((InstanceLifeCycleCallbacks)iterator.next()).onInstanceCreated(wXSDKInstance.getInstanceId());
            }
        }
    }

    void refreshInstance(String string, WXRefreshData wXRefreshData) {
        this.mBridgeManager.refreshInstance(string, wXRefreshData);
    }

    void destroyInstance(String string) {
        this.setCrashInfo("wx_current_url", "");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (WXUtils.isUiThread()) {
            List<InstanceLifeCycleCallbacks> list = this.mLifeCycleCallbacks;
            if (list != null) {
                list = list.iterator();
                while (list.hasNext()) {
                    ((InstanceLifeCycleCallbacks)list.next()).onInstanceDestroyed(string);
                }
            }
            WXSDKManager wXSDKManager = this;
            wXSDKManager.mWXRenderManager.removeRenderStatement(string);
            wXSDKManager.mBridgeManager.destroyInstance(string);
            WXModuleManager.destroyInstanceModules(string);
            return;
        }
        throw new WXRuntimeException("[WXSDKManager] destroyInstance error");
    }

    String generateInstanceId() {
        return String.valueOf(sInstanceId.incrementAndGet());
    }

    public IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return this.mIWXUserTrackAdapter;
    }

    public IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return this.mIWXImgLoaderAdapter;
    }

    public IWXJsFileLoaderAdapter getIWXJsFileLoaderAdapter() {
        return this.mWXJsFileLoaderAdapter;
    }

    public IDrawableLoader getDrawableLoader() {
        return this.mDrawableLoader;
    }

    public IWXJSExceptionAdapter getIWXJSExceptionAdapter() {
        return this.mIWXJSExceptionAdapter;
    }

    public void setIWXJSExceptionAdapter(IWXJSExceptionAdapter iWXJSExceptionAdapter) {
        this.mIWXJSExceptionAdapter = iWXJSExceptionAdapter;
    }

    @NonNull
    public IWXHttpAdapter getIWXHttpAdapter() {
        if (this.mIWXHttpAdapter == null) {
            DefaultWXHttpAdapter defaultWXHttpAdapter;
            DefaultWXHttpAdapter defaultWXHttpAdapter2 = defaultWXHttpAdapter;
            defaultWXHttpAdapter = new DefaultWXHttpAdapter();
            this.mIWXHttpAdapter = defaultWXHttpAdapter2;
        }
        return this.mIWXHttpAdapter;
    }

    public IApmGenerator getApmGenerater() {
        return this.mApmGenerater;
    }

    @NonNull
    public URIAdapter getURIAdapter() {
        if (this.mURIAdapter == null) {
            DefaultUriAdapter defaultUriAdapter;
            DefaultUriAdapter defaultUriAdapter2 = defaultUriAdapter;
            defaultUriAdapter = new DefaultUriAdapter();
            this.mURIAdapter = defaultUriAdapter2;
        }
        return this.mURIAdapter;
    }

    @NonNull
    public IDCVueBridgeAdapter getVueBridgeAdapter() {
        return this.mVueBridgeAdapter;
    }

    public ClassLoaderAdapter getClassLoaderAdapter() {
        if (this.mClassLoaderAdapter == null) {
            ClassLoaderAdapter classLoaderAdapter;
            ClassLoaderAdapter classLoaderAdapter2 = classLoaderAdapter;
            classLoaderAdapter = new ClassLoaderAdapter();
            this.mClassLoaderAdapter = classLoaderAdapter2;
        }
        return this.mClassLoaderAdapter;
    }

    public IWXSoLoaderAdapter getIWXSoLoaderAdapter() {
        return this.mIWXSoLoaderAdapter;
    }

    public List<IWXAnalyzer> getWXAnalyzerList() {
        return this.mWXAnalyzerList;
    }

    public void addWXAnalyzer(IWXAnalyzer iWXAnalyzer) {
        if (!this.mWXAnalyzerList.contains(iWXAnalyzer)) {
            this.mWXAnalyzerList.add(iWXAnalyzer);
        }
    }

    public void rmWXAnalyzer(IWXAnalyzer iWXAnalyzer) {
        this.mWXAnalyzerList.remove(iWXAnalyzer);
    }

    void setInitConfig(InitConfig initConfig) {
        this.mIWXHttpAdapter = initConfig.getHttpAdapter();
        this.mIWXImgLoaderAdapter = initConfig.getImgAdapter();
        this.mDrawableLoader = initConfig.getDrawableLoader();
        this.mIWXStorageAdapter = initConfig.getStorageAdapter();
        this.mVueBridgeAdapter = initConfig.getVueBridgeAdaper();
        this.mIWXUserTrackAdapter = initConfig.getUtAdapter();
        this.mURIAdapter = initConfig.getURIAdapter();
        this.mIWebSocketAdapterFactory = initConfig.getWebSocketAdapterFactory();
        this.mIWXJSExceptionAdapter = initConfig.getJSExceptionAdapter();
        this.mIWXSoLoaderAdapter = initConfig.getIWXSoLoaderAdapter();
        this.mClassLoaderAdapter = initConfig.getClassLoaderAdapter();
        this.mApmGenerater = initConfig.getApmGenerater();
        this.mWXJsFileLoaderAdapter = initConfig.getJsFileLoaderAdapter();
        this.mWXJscProcessManager = initConfig.getJscProcessManager();
    }

    public IWXStorageAdapter getIWXStorageAdapter() {
        if (this.mIWXStorageAdapter == null) {
            Application application = WXEnvironment.sApplication;
            if (application != null) {
                DefaultWXStorage defaultWXStorage;
                DefaultWXStorage defaultWXStorage2 = defaultWXStorage;
                defaultWXStorage = new DefaultWXStorage((Context)application);
                this.mIWXStorageAdapter = defaultWXStorage2;
            } else {
                WXLogUtils.e("WXStorageModule", "No Application context found,you should call WXSDKEngine#initialize() method in your application");
            }
        }
        return this.mIWXStorageAdapter;
    }

    public void notifyTrimMemory() {
        this.mBridgeManager.notifyTrimMemory();
    }

    public void notifySerializeCodeCache() {
        this.mBridgeManager.notifySerializeCodeCache();
    }

    @Nullable
    public IWebSocketAdapter getIWXWebSocketAdapter() {
        IWebSocketAdapterFactory iWebSocketAdapterFactory = ((WXSDKManager)((Object)iWebSocketAdapterFactory)).mIWebSocketAdapterFactory;
        if (iWebSocketAdapterFactory != null) {
            return iWebSocketAdapterFactory.createWebSocketAdapter();
        }
        return null;
    }

    public void registerValidateProcessor(WXValidateProcessor wXValidateProcessor) {
        this.mWXValidateProcessor = wXValidateProcessor;
    }

    public WXValidateProcessor getValidateProcessor() {
        return this.mWXValidateProcessor;
    }

    public void setCrashInfoReporter(ICrashInfoReporter iCrashInfoReporter) {
        this.mCrashInfo = iCrashInfoReporter;
    }

    public void setCrashInfo(String string, String string2) {
        ICrashInfoReporter iCrashInfoReporter = ((WXSDKManager)((Object)iCrashInfoReporter)).mCrashInfo;
        if (iCrashInfoReporter != null) {
            iCrashInfoReporter.addCrashInfo(string, string2);
        }
    }

    public void setTracingAdapter(ITracingAdapter iTracingAdapter) {
        this.mTracingAdapter = iTracingAdapter;
    }

    public ITracingAdapter getTracingAdapter() {
        return this.mTracingAdapter;
    }

    public void registerInstanceLifeCycleCallbacks(InstanceLifeCycleCallbacks instanceLifeCycleCallbacks) {
        if (this.mLifeCycleCallbacks == null) {
            ArrayList<InstanceLifeCycleCallbacks> arrayList;
            ArrayList<InstanceLifeCycleCallbacks> arrayList2 = arrayList;
            arrayList = new ArrayList<InstanceLifeCycleCallbacks>();
            this.mLifeCycleCallbacks = arrayList2;
        }
        this.mLifeCycleCallbacks.add(instanceLifeCycleCallbacks);
    }

    public void setAccessibilityRoleAdapter(IWXAccessibilityRoleAdapter iWXAccessibilityRoleAdapter) {
        this.mRoleAdapter = iWXAccessibilityRoleAdapter;
    }

    public IWXAccessibilityRoleAdapter getAccessibilityRoleAdapter() {
        return this.mRoleAdapter;
    }

    public INavigator getNavigator() {
        return this.mNavigator;
    }

    public void setNavigator(INavigator iNavigator) {
        this.mNavigator = iNavigator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FontAdapter getFontAdapter() {
        if (this.mFontAdapter != null) return this.mFontAdapter;
        WXSDKManager wXSDKManager = this;
        synchronized (wXSDKManager) {
            Throwable throwable2;
            block4: {
                FontAdapter fontAdapter;
                try {
                    if (wXSDKManager.mFontAdapter != null) return this.mFontAdapter;
                    WXSDKManager wXSDKManager2 = this;
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                FontAdapter fontAdapter2 = fontAdapter;
                fontAdapter = new FontAdapter();
                wXSDKManager2.mFontAdapter = fontAdapter2;
                // ** MonitorExit[this] (shouldn't be in output)
                return this.mFontAdapter;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public static interface InstanceLifeCycleCallbacks {
        public void onInstanceDestroyed(String var1);

        public void onInstanceCreated(String var1);
    }
}

