/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.video;

import android.view.ViewGroup;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.media.video.DHVideoFrameItem;
import java.util.HashMap;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoPlayerMgr {
    private static VideoPlayerMgr mInstance;
    private HashMap<String, DHVideoFrameItem> mPlayerCaches = new HashMap();
    private ViewGroup.LayoutParams _vlps;
    private AbsMgr mFeatureMgr;

    public static VideoPlayerMgr getInstance() {
        if (mInstance == null) {
            mInstance = new VideoPlayerMgr();
        }
        return mInstance;
    }

    public void initFeature(AbsMgr mFeatureMgr) {
        this.mFeatureMgr = mFeatureMgr;
    }

    public IWebview findWebview(IWebview webview, String webId) {
        if (webview == null) {
            return null;
        }
        IApp app = webview.obtainApp();
        if (app == null) {
            return null;
        }
        Object object = this.mFeatureMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, (Object)new Object[]{webview, "ui", "findWebview", new String[]{app.obtainAppId(), webId}});
        if (object instanceof IWebview) {
            return (IWebview)object;
        }
        return null;
    }

    public void createVideoPlayer(IWebview webview, String id, JSONArray rectJa, JSONObject style, String userId, boolean isCerate) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        } else {
            frameItem = new DHVideoFrameItem(webview.getContext(), id, webview, rectJa, style, userId);
            this.mPlayerCaches.put(id, frameItem);
        }
        if (!isCerate) {
            frameItem.appendToFrame(webview.obtainFrameView());
        }
    }

    public void play(String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.play();
        }
    }

    public void pause(String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.pause();
        }
    }

    public void stop(String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.stop();
        }
    }

    public void close(IWebview webview, String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.close();
            frameItem.removeFrameItem();
        }
    }

    public void sendDanmu(String id, JSONObject danmu) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.sendDanmu(danmu);
        }
    }

    public JSONObject findVideoPlayer(String id) {
        if (id == null) {
            return null;
        }
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null) {
            for (String key : this.mPlayerCaches.keySet()) {
                DHVideoFrameItem item = this.mPlayerCaches.get(key);
                if (!id.equals(item.getUserId())) continue;
                frameItem = item;
            }
        }
        if (frameItem != null) {
            try {
                return new JSONObject("{'name':'" + frameItem.getUserId() + "','uid':'" + frameItem.getmId() + "'}");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    public AdaFrameItem appendVideoPlayer(String id, IFrameView frameView) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.appendToFrame(frameView);
        }
        return frameItem;
    }

    public void seekTo(String id, String position) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.seek(position);
        }
    }

    public void recovery() {
        if (this.mPlayerCaches != null && this.mPlayerCaches.size() > 0) {
            Set<String> keySet = this.mPlayerCaches.keySet();
            for (String entry : keySet) {
                this.mPlayerCaches.get(entry).release();
            }
        }
        this.mPlayerCaches.clear();
    }

    public void rmovePlayer(String id) {
        if (this.mPlayerCaches != null && this.mPlayerCaches.size() > 0 && this.mPlayerCaches.containsKey(id)) {
            this.mPlayerCaches.remove(id);
        }
    }

    public void requestFullScreen(String id, String direction) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.requestFullScreen(direction);
        }
    }

    public void exitFullScreen(String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.exitFullScreen();
        }
    }

    public void show(String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.show();
        }
    }

    public void hidden(String id) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.hidden();
        }
    }

    public void addEventListener(IWebview webview, String id, String evnet, String callbackId, String webId) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.addEventListener(evnet, callbackId, webId);
        }
    }

    public void setOptions(String id, JSONObject options) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.setOptions(options);
        }
    }

    public void setPlayBackRate(String id, String rate) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches != null && this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem != null) {
            frameItem.sendPlayBackRate(rate);
        }
    }

    public void resize(IWebview webview, String id, JSONArray pJsArgs) {
        DHVideoFrameItem frameItem = null;
        if (this.mPlayerCaches.containsKey(id)) {
            frameItem = this.mPlayerCaches.get(id);
        }
        if (frameItem == null) {
            return;
        }
        frameItem.resize(pJsArgs);
    }
}

