/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.support.v18.scanner;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.List;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanResult;

class UserScanCallbackWrapper
extends ScanCallback {
    private final WeakReference<ScanCallback> weakScanCallback;

    UserScanCallbackWrapper(@NonNull ScanCallback userCallback) {
        this.weakScanCallback = new WeakReference<ScanCallback>(userCallback);
    }

    boolean isDead() {
        return this.weakScanCallback.get() == null;
    }

    @Nullable
    ScanCallback get() {
        return (ScanCallback)this.weakScanCallback.get();
    }

    @Override
    public void onScanResult(int callbackType, @NonNull ScanResult result) {
        ScanCallback userCallback = (ScanCallback)this.weakScanCallback.get();
        if (userCallback != null) {
            userCallback.onScanResult(callbackType, result);
        }
    }

    @Override
    public void onBatchScanResults(@NonNull List<ScanResult> results) {
        ScanCallback userCallback = (ScanCallback)this.weakScanCallback.get();
        if (userCallback != null) {
            userCallback.onBatchScanResults(results);
        }
    }

    @Override
    public void onScanFailed(int errorCode) {
        ScanCallback userCallback = (ScanCallback)this.weakScanCallback.get();
        if (userCallback != null) {
            userCallback.onScanFailed(errorCode);
        }
    }
}

