/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.support.v18.scanner;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.UserScanCallbackWrapper;

class ScanCallbackWrapperSet<W extends BluetoothLeScannerCompat.ScanCallbackWrapper> {
    @NonNull
    private final Set<W> wrappers = new HashSet<W>();

    ScanCallbackWrapperSet() {
    }

    @NonNull
    public Set<W> values() {
        return this.wrappers;
    }

    boolean isEmpty() {
        return this.wrappers.isEmpty();
    }

    void add(@NonNull W wrapper) {
        this.wrappers.add(wrapper);
    }

    boolean contains(@NonNull ScanCallback callback) {
        for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : this.wrappers) {
            UserScanCallbackWrapper callbackWrapper;
            if (wrapper.scanCallback == callback) {
                return true;
            }
            if (!(wrapper.scanCallback instanceof UserScanCallbackWrapper) || (callbackWrapper = (UserScanCallbackWrapper)wrapper.scanCallback).get() != callback) continue;
            return true;
        }
        return false;
    }

    @Nullable
    W get(@NonNull ScanCallback callback) {
        for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : this.wrappers) {
            UserScanCallbackWrapper callbackWrapper;
            if (wrapper.scanCallback == callback) {
                return (W)wrapper;
            }
            if (!(wrapper.scanCallback instanceof UserScanCallbackWrapper) || (callbackWrapper = (UserScanCallbackWrapper)wrapper.scanCallback).get() != callback) continue;
            return (W)wrapper;
        }
        return null;
    }

    @Nullable
    W remove(@NonNull ScanCallback callback) {
        for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : this.wrappers) {
            UserScanCallbackWrapper callbackWrapper;
            if (wrapper.scanCallback == callback) {
                return (W)wrapper;
            }
            if (!(wrapper.scanCallback instanceof UserScanCallbackWrapper) || (callbackWrapper = (UserScanCallbackWrapper)wrapper.scanCallback).get() != callback) continue;
            this.wrappers.remove(wrapper);
            return (W)wrapper;
        }
        this.cleanUp();
        return null;
    }

    private void cleanUp() {
        LinkedList<BluetoothLeScannerCompat.ScanCallbackWrapper> deadWrappers = new LinkedList<BluetoothLeScannerCompat.ScanCallbackWrapper>();
        for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : this.wrappers) {
            UserScanCallbackWrapper callbackWrapper;
            if (!(wrapper.scanCallback instanceof UserScanCallbackWrapper) || !(callbackWrapper = (UserScanCallbackWrapper)wrapper.scanCallback).isDead()) continue;
            deadWrappers.add(wrapper);
        }
        for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : deadWrappers) {
            this.wrappers.remove(wrapper);
        }
    }
}

