/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.support.v18.scanner;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerImplMarshmallow;
import no.nordicsemi.android.support.v18.scanner.PendingIntentExecutor;
import no.nordicsemi.android.support.v18.scanner.PendingIntentReceiver;
import no.nordicsemi.android.support.v18.scanner.ScanFilter;
import no.nordicsemi.android.support.v18.scanner.ScanRecord;
import no.nordicsemi.android.support.v18.scanner.ScanResult;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;

@TargetApi(value=26)
class BluetoothLeScannerImplOreo
extends BluetoothLeScannerImplMarshmallow {
    @NonNull
    private final HashMap<PendingIntent, PendingIntentExecutorWrapper> wrappers = new HashMap();

    BluetoothLeScannerImplOreo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    PendingIntentExecutorWrapper getWrapper(@NonNull PendingIntent callbackIntent) {
        HashMap<PendingIntent, PendingIntentExecutorWrapper> hashMap = this.wrappers;
        synchronized (hashMap) {
            if (this.wrappers.containsKey(callbackIntent)) {
                PendingIntentExecutorWrapper wrapper = this.wrappers.get(callbackIntent);
                if (wrapper == null) {
                    throw new IllegalStateException("Scanning has been stopped");
                }
                return wrapper;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWrapper(@NonNull PendingIntent callbackIntent, @NonNull PendingIntentExecutorWrapper wrapper) {
        HashMap<PendingIntent, PendingIntentExecutorWrapper> hashMap = this.wrappers;
        synchronized (hashMap) {
            this.wrappers.put(callbackIntent, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startScanInternal(@Nullable List<ScanFilter> filters, @Nullable ScanSettings settings, @NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            throw new IllegalStateException("BT le scanner not available");
        }
        ScanSettings nonNullSettings = settings != null ? settings : new ScanSettings.Builder().build();
        List<ScanFilter> nonNullFilters = filters != null ? filters : Collections.emptyList();
        android.bluetooth.le.ScanSettings nativeSettings = this.toNativeScanSettings(adapter, nonNullSettings, false);
        ArrayList<android.bluetooth.le.ScanFilter> nativeFilters = null;
        if (filters != null && adapter.isOffloadedFilteringSupported() && nonNullSettings.getUseHardwareFilteringIfSupported()) {
            nativeFilters = this.toNativeScanFilters(filters);
        }
        HashMap<PendingIntent, PendingIntentExecutorWrapper> hashMap = this.wrappers;
        synchronized (hashMap) {
            this.wrappers.remove(callbackIntent);
        }
        PendingIntent pendingIntent = this.createStartingPendingIntent(nonNullFilters, nonNullSettings, context, callbackIntent, requestCode);
        scanner.startScan(nativeFilters, nativeSettings, pendingIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopScanInternal(@NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            throw new IllegalStateException("BT le scanner not available");
        }
        PendingIntent pendingIntent = this.createStoppingPendingIntent(context, requestCode);
        scanner.stopScan(pendingIntent);
        HashMap<PendingIntent, PendingIntentExecutorWrapper> hashMap = this.wrappers;
        synchronized (hashMap) {
            this.wrappers.put(callbackIntent, null);
        }
    }

    @NonNull
    private PendingIntent createStartingPendingIntent(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        Intent intent = new Intent(context, PendingIntentReceiver.class);
        intent.setAction("no.nordicsemi.android.support.v18.ACTION_FOUND");
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        intent.putParcelableArrayListExtra("no.nordicsemi.android.support.v18.EXTRA_FILTERS", this.toNativeScanFilters(filters));
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_SETTINGS", (Parcelable)this.toNativeScanSettings(adapter, settings, true));
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_USE_HARDWARE_BATCHING", settings.getUseHardwareBatchingIfSupported());
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_USE_HARDWARE_FILTERING", settings.getUseHardwareFilteringIfSupported());
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_USE_HARDWARE_CALLBACK_TYPES", settings.getUseHardwareCallbackTypesIfSupported());
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_MATCH_MODE", settings.getMatchMode());
        intent.putExtra("no.nordicsemi.android.support.v18.EXTRA_NUM_OF_MATCHES", settings.getNumOfMatches());
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)flags);
    }

    @NonNull
    private PendingIntent createStoppingPendingIntent(@NonNull Context context, int requestCode) {
        Intent intent = new Intent(context, PendingIntentReceiver.class);
        intent.setAction("no.nordicsemi.android.support.v18.ACTION_FOUND");
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)flags);
    }

    @Override
    @NonNull
    android.bluetooth.le.ScanSettings toNativeScanSettings(@NonNull BluetoothAdapter adapter, @NonNull ScanSettings settings, boolean exactCopy) {
        ScanSettings.Builder builder = new ScanSettings.Builder();
        if (exactCopy || adapter.isOffloadedScanBatchingSupported() && settings.getUseHardwareBatchingIfSupported()) {
            builder.setReportDelay(settings.getReportDelayMillis());
        }
        if (exactCopy || settings.getUseHardwareCallbackTypesIfSupported()) {
            builder.setCallbackType(settings.getCallbackType()).setMatchMode(settings.getMatchMode()).setNumOfMatches(settings.getNumOfMatches());
        }
        builder.setScanMode(settings.getScanMode()).setLegacy(settings.getLegacy()).setPhy(settings.getPhy());
        return builder.build();
    }

    @NonNull
    ScanSettings fromNativeScanSettings(@NonNull android.bluetooth.le.ScanSettings settings, boolean useHardwareBatchingIfSupported, boolean useHardwareFilteringIfSupported, boolean useHardwareCallbackTypesIfSupported, long matchLostDeviceTimeout, long matchLostTaskInterval, int matchMode, int numOfMatches) {
        ScanSettings.Builder builder = new ScanSettings.Builder().setLegacy(settings.getLegacy()).setPhy(settings.getPhy()).setCallbackType(settings.getCallbackType()).setScanMode(settings.getScanMode()).setReportDelay(settings.getReportDelayMillis()).setUseHardwareBatchingIfSupported(useHardwareBatchingIfSupported).setUseHardwareFilteringIfSupported(useHardwareFilteringIfSupported).setUseHardwareCallbackTypesIfSupported(useHardwareCallbackTypesIfSupported).setMatchOptions(matchLostDeviceTimeout, matchLostTaskInterval).setMatchMode(matchMode).setNumOfMatches(numOfMatches);
        return builder.build();
    }

    @NonNull
    ArrayList<ScanFilter> fromNativeScanFilters(@NonNull List<android.bluetooth.le.ScanFilter> filters) {
        ArrayList<ScanFilter> nativeScanFilters = new ArrayList<ScanFilter>();
        for (android.bluetooth.le.ScanFilter filter : filters) {
            nativeScanFilters.add(this.fromNativeScanFilter(filter));
        }
        return nativeScanFilters;
    }

    @NonNull
    ScanFilter fromNativeScanFilter(@NonNull android.bluetooth.le.ScanFilter filter) {
        ScanFilter.Builder builder = new ScanFilter.Builder();
        builder.setDeviceAddress(filter.getDeviceAddress()).setDeviceName(filter.getDeviceName()).setServiceUuid(filter.getServiceUuid(), filter.getServiceUuidMask()).setManufacturerData(filter.getManufacturerId(), filter.getManufacturerData(), filter.getManufacturerDataMask());
        if (filter.getServiceDataUuid() != null) {
            builder.setServiceData(filter.getServiceDataUuid(), filter.getServiceData(), filter.getServiceDataMask());
        }
        return builder.build();
    }

    @Override
    @NonNull
    ScanResult fromNativeScanResult(@NonNull android.bluetooth.le.ScanResult result) {
        int eventType = result.getDataStatus() << 5 | (result.isLegacy() ? 16 : 0) | (result.isConnectable() ? 1 : 0);
        byte[] data = result.getScanRecord() != null ? result.getScanRecord().getBytes() : null;
        return new ScanResult(result.getDevice(), eventType, result.getPrimaryPhy(), result.getSecondaryPhy(), result.getAdvertisingSid(), result.getTxPower(), result.getRssi(), result.getPeriodicAdvertisingInterval(), ScanRecord.parseFromBytes(data), result.getTimestampNanos());
    }

    static class PendingIntentExecutorWrapper
    extends BluetoothLeScannerCompat.ScanCallbackWrapper {
        @NonNull
        final PendingIntentExecutor executor;

        PendingIntentExecutorWrapper(boolean offloadedBatchingSupported, boolean offloadedFilteringSupported, @NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull PendingIntentExecutor executor) {
            super(offloadedBatchingSupported, offloadedFilteringSupported, filters, settings, executor, new Handler());
            this.executor = executor;
        }
    }
}

