/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.support.v18.scanner;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanCallbackWrapperSet;
import no.nordicsemi.android.support.v18.scanner.ScanFilter;
import no.nordicsemi.android.support.v18.scanner.ScanRecord;
import no.nordicsemi.android.support.v18.scanner.ScanResult;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;
import no.nordicsemi.android.support.v18.scanner.ScannerService;
import no.nordicsemi.android.support.v18.scanner.UserScanCallbackWrapper;

@TargetApi(value=21)
class BluetoothLeScannerImplLollipop
extends BluetoothLeScannerCompat {
    @NonNull
    private final ScanCallbackWrapperSet<ScanCallbackWrapperLollipop> wrappers = new ScanCallbackWrapperSet();

    BluetoothLeScannerImplLollipop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startScanInternal(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback, @NonNull Handler handler) {
        ScanCallbackWrapperLollipop wrapper;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            throw new IllegalStateException("BT le scanner not available");
        }
        boolean offloadedBatchingSupported = adapter.isOffloadedScanBatchingSupported();
        boolean offloadedFilteringSupported = adapter.isOffloadedFilteringSupported();
        ScanCallbackWrapperSet<ScanCallbackWrapperLollipop> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            if (this.wrappers.contains(callback)) {
                throw new IllegalArgumentException("scanner already started with given callback");
            }
            UserScanCallbackWrapper callbackWrapper = new UserScanCallbackWrapper(callback);
            wrapper = new ScanCallbackWrapperLollipop(offloadedBatchingSupported, offloadedFilteringSupported, filters, settings, callbackWrapper, handler);
            this.wrappers.add(wrapper);
        }
        android.bluetooth.le.ScanSettings nativeScanSettings = this.toNativeScanSettings(adapter, settings, false);
        ArrayList<android.bluetooth.le.ScanFilter> nativeScanFilters = null;
        if (!filters.isEmpty() && offloadedFilteringSupported && settings.getUseHardwareFilteringIfSupported()) {
            nativeScanFilters = this.toNativeScanFilters(filters);
        }
        scanner.startScan(nativeScanFilters, nativeScanSettings, wrapper.nativeCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopScanInternal(@NonNull ScanCallback callback) {
        BluetoothLeScanner scanner;
        ScanCallbackWrapperLollipop wrapper;
        ScanCallbackWrapperSet<ScanCallbackWrapperLollipop> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            wrapper = this.wrappers.remove(callback);
        }
        if (wrapper == null) {
            return;
        }
        wrapper.close();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && (scanner = adapter.getBluetoothLeScanner()) != null) {
            scanner.stopScan(wrapper.nativeCallback);
        }
    }

    @Override
    void startScanInternal(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            throw new IllegalStateException("BT le scanner not available");
        }
        Intent service = new Intent(context, ScannerService.class);
        service.putParcelableArrayListExtra("no.nordicsemi.android.support.v18.EXTRA_FILTERS", new ArrayList<ScanFilter>(filters));
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_SETTINGS", (Parcelable)settings);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        service.putExtra("no.nordicsemi.android.support.v18.REQUEST_CODE", requestCode);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_START", true);
        context.startService(service);
    }

    @Override
    void stopScanInternal(@NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        Intent service = new Intent(context, ScannerService.class);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        service.putExtra("no.nordicsemi.android.support.v18.REQUEST_CODE", requestCode);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_START", false);
        context.startService(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushPendingScanResults(@NonNull ScanCallback callback) {
        ScanCallbackWrapperLollipop wrapper;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null!");
        }
        ScanCallbackWrapperSet<ScanCallbackWrapperLollipop> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            wrapper = this.wrappers.get(callback);
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("callback not registered!");
        }
        ScanSettings settings = wrapper.scanSettings;
        if (adapter.isOffloadedScanBatchingSupported() && settings.getUseHardwareBatchingIfSupported()) {
            BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
            if (scanner == null) {
                return;
            }
            scanner.flushPendingScanResults(wrapper.nativeCallback);
        } else {
            wrapper.flushPendingScanResults();
        }
    }

    @NonNull
    android.bluetooth.le.ScanSettings toNativeScanSettings(@NonNull BluetoothAdapter adapter, @NonNull ScanSettings settings, boolean exactCopy) {
        ScanSettings.Builder builder = new ScanSettings.Builder();
        if (exactCopy || adapter.isOffloadedScanBatchingSupported() && settings.getUseHardwareBatchingIfSupported()) {
            builder.setReportDelay(settings.getReportDelayMillis());
        }
        if (settings.getScanMode() != -1) {
            builder.setScanMode(settings.getScanMode());
        } else {
            builder.setScanMode(0);
        }
        settings.disableUseHardwareCallbackTypes();
        return builder.build();
    }

    @NonNull
    ArrayList<android.bluetooth.le.ScanFilter> toNativeScanFilters(@NonNull List<ScanFilter> filters) {
        ArrayList<android.bluetooth.le.ScanFilter> nativeScanFilters = new ArrayList<android.bluetooth.le.ScanFilter>();
        for (ScanFilter filter : filters) {
            nativeScanFilters.add(this.toNativeScanFilter(filter));
        }
        return nativeScanFilters;
    }

    @NonNull
    android.bluetooth.le.ScanFilter toNativeScanFilter(@NonNull ScanFilter filter) {
        ScanFilter.Builder builder = new ScanFilter.Builder();
        builder.setServiceUuid(filter.getServiceUuid(), filter.getServiceUuidMask()).setManufacturerData(filter.getManufacturerId(), filter.getManufacturerData(), filter.getManufacturerDataMask());
        if (filter.getDeviceAddress() != null) {
            builder.setDeviceAddress(filter.getDeviceAddress());
        }
        if (filter.getDeviceName() != null) {
            builder.setDeviceName(filter.getDeviceName());
        }
        if (filter.getServiceDataUuid() != null) {
            builder.setServiceData(filter.getServiceDataUuid(), filter.getServiceData(), filter.getServiceDataMask());
        }
        return builder.build();
    }

    @NonNull
    ScanResult fromNativeScanResult(@NonNull android.bluetooth.le.ScanResult nativeScanResult) {
        byte[] data = nativeScanResult.getScanRecord() != null ? nativeScanResult.getScanRecord().getBytes() : null;
        return new ScanResult(nativeScanResult.getDevice(), ScanRecord.parseFromBytes(data), nativeScanResult.getRssi(), nativeScanResult.getTimestampNanos());
    }

    @NonNull
    ArrayList<ScanResult> fromNativeScanResults(@NonNull List<android.bluetooth.le.ScanResult> nativeScanResults) {
        ArrayList<ScanResult> results = new ArrayList<ScanResult>();
        for (android.bluetooth.le.ScanResult nativeScanResult : nativeScanResults) {
            ScanResult result = this.fromNativeScanResult(nativeScanResult);
            results.add(result);
        }
        return results;
    }

    static class ScanCallbackWrapperLollipop
    extends BluetoothLeScannerCompat.ScanCallbackWrapper {
        @NonNull
        private final android.bluetooth.le.ScanCallback nativeCallback = new android.bluetooth.le.ScanCallback(){
            private long lastBatchTimestamp;

            public void onScanResult(int callbackType, android.bluetooth.le.ScanResult nativeScanResult) {
                handler.post(() -> {
                    BluetoothLeScannerImplLollipop scannerImpl = (BluetoothLeScannerImplLollipop)BluetoothLeScannerCompat.getScanner();
                    ScanResult result = scannerImpl.fromNativeScanResult(nativeScanResult);
                    this.handleScanResult(callbackType, result);
                });
            }

            public void onBatchScanResults(List<android.bluetooth.le.ScanResult> nativeScanResults) {
                handler.post(() -> {
                    long now = SystemClock.elapsedRealtime();
                    if (this.lastBatchTimestamp > now - scanSettings.getReportDelayMillis() + 5L) {
                        return;
                    }
                    this.lastBatchTimestamp = now;
                    BluetoothLeScannerImplLollipop scannerImpl = (BluetoothLeScannerImplLollipop)BluetoothLeScannerCompat.getScanner();
                    ArrayList<ScanResult> results = scannerImpl.fromNativeScanResults(nativeScanResults);
                    this.handleScanResults(results);
                });
            }

            public void onScanFailed(int errorCode) {
                handler.post(() -> {
                    if (scanSettings.getUseHardwareCallbackTypesIfSupported() && scanSettings.getCallbackType() != 1) {
                        scanSettings.disableUseHardwareCallbackTypes();
                        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
                        try {
                            scanner.stopScan(scanCallback);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            scanner.startScanInternal(filters, scanSettings, scanCallback, handler);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    this.handleScanError(errorCode);
                });
            }
        };

        private ScanCallbackWrapperLollipop(boolean offloadedBatchingSupported, boolean offloadedFilteringSupported, @NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback, @NonNull Handler handler) {
            super(offloadedBatchingSupported, offloadedFilteringSupported, filters, settings, callback, handler);
        }
    }
}

