/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.support.v18.scanner;

import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanCallbackWrapperSet;
import no.nordicsemi.android.support.v18.scanner.ScanFilter;
import no.nordicsemi.android.support.v18.scanner.ScanRecord;
import no.nordicsemi.android.support.v18.scanner.ScanResult;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;
import no.nordicsemi.android.support.v18.scanner.ScannerService;
import no.nordicsemi.android.support.v18.scanner.UserScanCallbackWrapper;

class BluetoothLeScannerImplJB
extends BluetoothLeScannerCompat {
    @NonNull
    private final ScanCallbackWrapperSet<BluetoothLeScannerCompat.ScanCallbackWrapper> wrappers = new ScanCallbackWrapperSet();
    @Nullable
    private HandlerThread handlerThread;
    @Nullable
    private Handler powerSaveHandler;
    private long powerSaveRestInterval;
    private long powerSaveScanInterval;
    private final Runnable powerSaveSleepTask = new Runnable(){

        @Override
        public void run() {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null && BluetoothLeScannerImplJB.this.powerSaveRestInterval > 0L && BluetoothLeScannerImplJB.this.powerSaveScanInterval > 0L) {
                adapter.stopLeScan(BluetoothLeScannerImplJB.this.scanCallback);
                BluetoothLeScannerImplJB.this.powerSaveHandler.postDelayed(BluetoothLeScannerImplJB.this.powerSaveScanTask, BluetoothLeScannerImplJB.this.powerSaveRestInterval);
            }
        }
    };
    private final Runnable powerSaveScanTask = new Runnable(){

        @Override
        public void run() {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null && BluetoothLeScannerImplJB.this.powerSaveRestInterval > 0L && BluetoothLeScannerImplJB.this.powerSaveScanInterval > 0L) {
                adapter.startLeScan(BluetoothLeScannerImplJB.this.scanCallback);
                BluetoothLeScannerImplJB.this.powerSaveHandler.postDelayed(BluetoothLeScannerImplJB.this.powerSaveSleepTask, BluetoothLeScannerImplJB.this.powerSaveScanInterval);
            }
        }
    };
    private final BluetoothAdapter.LeScanCallback scanCallback = (device, rssi, scanRecord) -> {
        ScanResult scanResult = new ScanResult(device, ScanRecord.parseFromBytes(scanRecord), rssi, SystemClock.elapsedRealtimeNanos());
        ScanCallbackWrapperSet<BluetoothLeScannerCompat.ScanCallbackWrapper> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            Set<BluetoothLeScannerCompat.ScanCallbackWrapper> scanCallbackWrappers = this.wrappers.values();
            for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : scanCallbackWrappers) {
                wrapper.handler.post(() -> wrapper.handleScanResult(1, scanResult));
            }
        }
    };

    BluetoothLeScannerImplJB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startScanInternal(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback, @NonNull Handler handler) {
        boolean shouldStart;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        ScanCallbackWrapperSet<BluetoothLeScannerCompat.ScanCallbackWrapper> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            if (this.wrappers.contains(callback)) {
                throw new IllegalArgumentException("scanner already started with given scanCallback");
            }
            UserScanCallbackWrapper callbackWrapper = new UserScanCallbackWrapper(callback);
            BluetoothLeScannerCompat.ScanCallbackWrapper wrapper = new BluetoothLeScannerCompat.ScanCallbackWrapper(false, false, filters, settings, callbackWrapper, handler);
            shouldStart = this.wrappers.isEmpty();
            this.wrappers.add(wrapper);
        }
        if (this.handlerThread == null) {
            this.handlerThread = new HandlerThread(BluetoothLeScannerImplJB.class.getName());
            this.handlerThread.start();
            this.powerSaveHandler = new Handler(this.handlerThread.getLooper());
        }
        this.setPowerSaveSettings();
        if (shouldStart) {
            adapter.startLeScan(this.scanCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopScanInternal(@NonNull ScanCallback callback) {
        boolean shouldStop;
        BluetoothLeScannerCompat.ScanCallbackWrapper wrapper;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        ScanCallbackWrapperSet<BluetoothLeScannerCompat.ScanCallbackWrapper> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            wrapper = this.wrappers.remove(callback);
            shouldStop = this.wrappers.isEmpty();
        }
        if (wrapper == null) {
            return;
        }
        wrapper.close();
        this.setPowerSaveSettings();
        if (shouldStop) {
            adapter.stopLeScan(this.scanCallback);
            if (this.powerSaveHandler != null) {
                this.powerSaveHandler.removeCallbacksAndMessages(null);
            }
            if (this.handlerThread != null) {
                this.handlerThread.quitSafely();
                this.handlerThread = null;
            }
        }
    }

    @Override
    void startScanInternal(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        Intent service = new Intent(context, ScannerService.class);
        service.putParcelableArrayListExtra("no.nordicsemi.android.support.v18.EXTRA_FILTERS", new ArrayList<ScanFilter>(filters));
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_SETTINGS", (Parcelable)settings);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        service.putExtra("no.nordicsemi.android.support.v18.REQUEST_CODE", requestCode);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_START", true);
        context.startService(service);
    }

    @Override
    void stopScanInternal(@NonNull Context context, @NonNull PendingIntent callbackIntent, int requestCode) {
        Intent service = new Intent(context, ScannerService.class);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        service.putExtra("no.nordicsemi.android.support.v18.REQUEST_CODE", requestCode);
        service.putExtra("no.nordicsemi.android.support.v18.EXTRA_START", false);
        context.startService(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushPendingScanResults(@NonNull ScanCallback callback) {
        BluetoothLeScannerCompat.ScanCallbackWrapper wrapper;
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null!");
        }
        ScanCallbackWrapperSet<BluetoothLeScannerCompat.ScanCallbackWrapper> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            wrapper = this.wrappers.get(callback);
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("callback not registered!");
        }
        wrapper.flushPendingScanResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPowerSaveSettings() {
        long minRest = Long.MAX_VALUE;
        long minScan = Long.MAX_VALUE;
        ScanCallbackWrapperSet<BluetoothLeScannerCompat.ScanCallbackWrapper> scanCallbackWrapperSet = this.wrappers;
        synchronized (scanCallbackWrapperSet) {
            for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : this.wrappers.values()) {
                ScanSettings settings = wrapper.scanSettings;
                if (!settings.hasPowerSaveMode()) continue;
                if (minRest > settings.getPowerSaveRest()) {
                    minRest = settings.getPowerSaveRest();
                }
                if (minScan <= settings.getPowerSaveScan()) continue;
                minScan = settings.getPowerSaveScan();
            }
        }
        if (minRest < Long.MAX_VALUE && minScan < Long.MAX_VALUE) {
            this.powerSaveRestInterval = minRest;
            this.powerSaveScanInterval = minScan;
            if (this.powerSaveHandler != null) {
                this.powerSaveHandler.removeCallbacks(this.powerSaveScanTask);
                this.powerSaveHandler.removeCallbacks(this.powerSaveSleepTask);
                this.powerSaveHandler.postDelayed(this.powerSaveSleepTask, this.powerSaveScanInterval);
            }
        } else {
            this.powerSaveScanInterval = 0L;
            this.powerSaveRestInterval = 0L;
            if (this.powerSaveHandler != null) {
                this.powerSaveHandler.removeCallbacks(this.powerSaveScanTask);
                this.powerSaveHandler.removeCallbacks(this.powerSaveSleepTask);
            }
        }
    }
}

