/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.common.parser;

import java.util.ArrayList;
import java.util.Locale;
import no.nordicsemi.android.ble.data.Data;

public class HeartRateMeasurementParser {
    private static final byte HEART_RATE_VALUE_FORMAT = 1;
    private static final byte SENSOR_CONTACT_STATUS = 6;
    private static final byte ENERGY_EXPANDED_STATUS = 8;
    private static final byte RR_INTERVAL = 16;

    public static String parse(Data data) {
        int flags;
        int offset = 0;
        boolean value16bit = ((flags = data.getIntValue(17, offset++).intValue()) & 1) > 0;
        int sensorContactStatus = (flags & 6) >> 1;
        boolean energyExpandedStatus = (flags & 8) > 0;
        boolean rrIntervalStatus = (flags & 0x10) > 0;
        int heartRateValue = data.getIntValue(value16bit ? 18 : 17, offset++);
        if (value16bit) {
            ++offset;
        }
        int energyExpanded = -1;
        if (energyExpandedStatus) {
            energyExpanded = data.getIntValue(18, offset);
        }
        offset += 2;
        ArrayList<Float> rrIntervals = new ArrayList<Float>();
        if (rrIntervalStatus) {
            for (int o = offset; o < data.getValue().length; o += 2) {
                int units = data.getIntValue(18, o);
                rrIntervals.add(Float.valueOf((float)units * 1000.0f / 1024.0f));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Heart Rate Measurement: ").append(heartRateValue).append(" bpm");
        switch (sensorContactStatus) {
            case 0: 
            case 1: {
                builder.append(",Sensor Contact Not Supported");
                break;
            }
            case 2: {
                builder.append(",Contact is NOT Detected");
                break;
            }
            case 3: {
                builder.append(",Contact is Detected");
            }
        }
        if (energyExpandedStatus) {
            builder.append(",Energy Expanded: ").append(energyExpanded).append(" kJ");
        }
        if (rrIntervalStatus) {
            builder.append(",RR Interval: ");
            for (Float interval : rrIntervals) {
                builder.append(String.format(Locale.US, "%.02f ms, ", interval));
            }
            builder.setLength(builder.length() - 2);
        }
        return builder.toString();
    }
}

