/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.callback;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import androidx.annotation.NonNull;
import com.android.chileaf.fitness.callback.AccelerometerCallback;
import com.android.chileaf.fitness.callback.BindDeviceCallback;
import com.android.chileaf.fitness.callback.BloodOxygenCallback;
import com.android.chileaf.fitness.callback.BluetoothStatusCallback;
import com.android.chileaf.fitness.callback.BodySportCallback;
import com.android.chileaf.fitness.callback.HeartRateMaxCallback;
import com.android.chileaf.fitness.callback.HeartRateThroughoutTheDayCallback;
import com.android.chileaf.fitness.callback.HistoryBloodOxygenCallback;
import com.android.chileaf.fitness.callback.HistoryBodyTemperatureCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDetailDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDetailRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfHealthDataCallback;
import com.android.chileaf.fitness.callback.HistorySevenDaysOfSportsCallback;
import com.android.chileaf.fitness.callback.HistorySkippingRopeCallback;
import com.android.chileaf.fitness.callback.HistorySleepCallback;
import com.android.chileaf.fitness.callback.HistorySportsCallback;
import com.android.chileaf.fitness.callback.IntervalStepCallback;
import com.android.chileaf.fitness.callback.MACAddressCallback;
import com.android.chileaf.fitness.callback.MeasureModeStateCallback;
import com.android.chileaf.fitness.callback.PhysicalConditionCallback;
import com.android.chileaf.fitness.callback.RespiratoryRateCallback;
import com.android.chileaf.fitness.callback.SensorRawDataCallback;
import com.android.chileaf.fitness.callback.SingleTapRecordCallback;
import com.android.chileaf.fitness.callback.SkippingRopeDataCallback;
import com.android.chileaf.fitness.callback.SpecificFunctionCallback;
import com.android.chileaf.fitness.callback.SportModeCallback;
import com.android.chileaf.fitness.callback.SportModeExitStatusCallback;
import com.android.chileaf.fitness.callback.SportsRealTimeDataCallback;
import com.android.chileaf.fitness.callback.TemperatureCallback;
import com.android.chileaf.fitness.callback.UserIdNameCallback;
import com.android.chileaf.fitness.callback.UserInfoCallback;
import com.android.chileaf.fitness.callback.VibrationIntensityCallback;
import com.android.chileaf.fitness.callback.WashHandsCallback;
import com.android.chileaf.fitness.callback.WeatherStatusCallback;
import com.android.chileaf.model.BloodOxygenHistory;
import com.android.chileaf.model.BodyTemperatureHistory;
import com.android.chileaf.model.HeartRateAllDay;
import com.android.chileaf.model.HistoryOfHealth;
import com.android.chileaf.model.HistoryOfHeartRate;
import com.android.chileaf.model.HistoryOfHeartRateDetail;
import com.android.chileaf.model.HistoryOfHeartRateDetailRecord;
import com.android.chileaf.model.HistorySevenDaysOfSports;
import com.android.chileaf.model.HistorySkippingRope;
import com.android.chileaf.model.HistorySleep;
import com.android.chileaf.model.HistorySports;
import com.android.chileaf.model.IntervalStep;
import com.android.chileaf.util.DateUtil;
import com.android.chileaf.util.HexUtil;
import com.android.chileaf.util.LogUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.ble.callback.profile.ProfileReadResponse;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.utils.ParserUtils;

public abstract class WearReceivedCallback
extends ProfileReadResponse
implements UserInfoCallback,
BodySportCallback,
BluetoothStatusCallback,
HistorySevenDaysOfSportsCallback,
HistoryOfHRRecordCallback,
HistoryOfHRDataCallback,
IntervalStepCallback,
SingleTapRecordCallback,
HistorySleepCallback,
WashHandsCallback,
BloodOxygenCallback,
TemperatureCallback,
VibrationIntensityCallback,
SportModeCallback,
WeatherStatusCallback,
HistoryBodyTemperatureCallback,
HistoryBloodOxygenCallback,
HistorySportsCallback,
BindDeviceCallback,
SpecificFunctionCallback,
SkippingRopeDataCallback,
HistorySkippingRopeCallback,
HeartRateThroughoutTheDayCallback,
SportsRealTimeDataCallback,
AccelerometerCallback,
PhysicalConditionCallback,
SportModeExitStatusCallback,
SensorRawDataCallback,
MACAddressCallback,
HistoryOfHealthDataCallback,
UserIdNameCallback,
MeasureModeStateCallback,
RespiratoryRateCallback,
HistoryOfHRDetailRecordCallback,
HistoryOfHRDetailDataCallback,
HeartRateMaxCallback {
    private static final long END_TAG = 0xFFFFFFFFL;
    private long mStamp = 0L;
    private boolean isStamp = false;
    private final List<Data> mPackages = new ArrayList<Data>();
    private List<HistorySevenDaysOfSports> mHistorySevenDaysOfSports;
    private List<Long> mHistoryOfRecords;
    private List<HistoryOfHeartRate> mHistoryOfHeartRates;
    private List<IntervalStep> mIntervalSteps;
    private List<Long> mSingleTapRecords;
    private List<HistorySleep> mHistorySleeps;
    private List<BodyTemperatureHistory> mTemperatureHistory;
    private List<BloodOxygenHistory> mBloodOxygenHistory;
    private List<HistorySports> mHistorySportsCallback;
    private List<HistorySkippingRope> mSkippingRopes;
    private List<HeartRateAllDay> mHeartRateAllDays;
    private List<HistoryOfHeartRateDetailRecord> mHistoryOfDetailRecords;
    private List<HistoryOfHeartRateDetail> mHistoryOfDetailHeartRates;
    public static final int TYPE_SPORT = 2;
    public static final int TYPE_HEART = 4;
    public static final int TYPE_HEARTS = 6;
    public static final int TYPE_INTERVAL = 8;
    public static final int TYPE_SINGLE_TAP = 16;
    public static final int TYPE_SLEEP = 18;
    public static final int TYPE_TEMPERATURE = 20;
    public static final int TYPE_BLOOD_OXYGEN = 22;
    public static final int TYPE_HEALTH = 24;
    public static final int TYPE_HEART_DETAIL = 32;
    public static final int TYPE_HEARTS_DETAIL = 34;
    private int mSequence = 0;
    private boolean isStart = false;

    public WearReceivedCallback() {
    }

    protected WearReceivedCallback(Parcel in) {
        super(in);
    }

    @Override
    public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
        block127: {
            super.onDataReceived(device, data);
            boolean validate = data.getIntValue(17, 1).intValue() == data.size();
            byte[] value = data.getValue();
            if (!validate) {
                this.onInvalidDataReceived(device, data);
                LogUtil.w("onDataReceived:length:%s", data.size());
                return;
            }
            int mode = data.getIntValue(17, 2);
            try {
                int type;
                if (mode == 3) {
                    int age = this.getIntParse(value, 5, 1);
                    int sex = this.getIntParse(value, 6, 1);
                    int weight = this.getIntParse(value, 7, 1);
                    int height = this.getIntParse(value, 8, 1);
                    long mobile = this.getLongParse(value, 9, 5);
                    this.onUserInfoReceived(device, age, sex, weight, height, mobile);
                    break block127;
                }
                if (mode == 5) {
                    int cmd;
                    if (this.mHistorySleeps == null) {
                        this.mHistorySleeps = new ArrayList<HistorySleep>();
                    }
                    if ((cmd = this.getIntParse(value, 3, 1)) == 3) {
                        this.mPackages.add(data);
                    } else if (cmd == 255) {
                        for (int index = 0; index < this.mPackages.size(); ++index) {
                            byte[] slice = this.subSlice(4, this.mPackages.get(index).getValue());
                            for (int i = 0; i < slice.length; ++i) {
                                int length = this.getIntParse(slice, i, 1);
                                if (length < 1) continue;
                                long stamp = this.getLongParse(slice, ++i, 4);
                                i += 4;
                                int[] actions = new int[length];
                                for (int j = 0; j < length; ++j) {
                                    actions[j] = this.getIntParse(slice, i + j, 1);
                                }
                                i += length - 1;
                                HistorySleep historySleep = new HistorySleep(stamp * 1000L - 28800000L, actions);
                                this.mHistorySleeps.add(historySleep);
                            }
                        }
                        this.onSleepDataReceived(device, this.mHistorySleeps);
                        this.mHistorySleeps.clear();
                        this.mPackages.clear();
                    }
                    break block127;
                }
                if (mode == 21) {
                    int step = this.getIntParse(value, 3, 3);
                    int distance = this.getIntParse(value, 6, 3);
                    int calorie = this.getIntParse(value, 9, 3);
                    this.onSportReceived(device, step, distance, (float)calorie / 10.0f);
                    break block127;
                }
                if (mode == 18) {
                    int step = this.getIntParse(value, 3, 3);
                    int distance = this.getIntParse(value, 6, 3);
                    int calorie = this.getIntParse(value, 9, 3);
                    int speed = this.getIntParse(value, 12, 3);
                    int cadence = this.getIntParse(value, 15, 1);
                    int sportMode = this.getIntParse(value, 16, 1);
                    int hour = this.getIntParse(value, 17, 1);
                    int minute = this.getIntParse(value, 18, 1);
                    int seconds = this.getIntParse(value, 19, 1);
                    int maxOxygenUptake = this.getIntParse(value, 20, 1);
                    int numberOfBreaths = this.getIntParse(value, 21, 1);
                    int emotion = this.getIntParse(value, 22, 1);
                    int pressure = this.getIntParse(value, 23, 1);
                    int fatigueIndex = this.getIntParse(value, 24, 1);
                    this.onSportRealTimeDataReceived(device, step, distance, (float)calorie / 10.0f, speed, cadence, sportMode, hour, minute, seconds, maxOxygenUptake, numberOfBreaths, emotion, pressure, fatigueIndex);
                    break block127;
                }
                if (mode == 63) {
                    int status = this.getIntParse(value, 3, 1);
                    this.onBluetoothStatusReceived(device, status == 1);
                    break block127;
                }
                if (mode == 22) {
                    if (this.mHistorySevenDaysOfSports == null) {
                        this.mHistorySevenDaysOfSports = new ArrayList<HistorySevenDaysOfSports>();
                    }
                    byte[] slice = this.subSlice(3, value);
                    this.parseSportHistory(slice);
                    this.onHistorySevenDaysOfSportsReceived(device, this.mHistorySevenDaysOfSports);
                    this.mHistorySevenDaysOfSports.clear();
                    break block127;
                }
                if (mode == 33) {
                    long utcTag;
                    if (this.mHistoryOfRecords == null) {
                        this.mHistoryOfRecords = new ArrayList<Long>();
                    }
                    if ((utcTag = this.getLongParse(value, 3, 4)) != 0xFFFFFFFFL) {
                        this.mPackages.add(data);
                    } else {
                        for (int index = 0; index < this.mPackages.size(); ++index) {
                            byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                            LogUtil.d("mHistoryOfRecords index:%d values:%s", index, ParserUtils.parse(slice));
                            for (int i = 0; i < slice.length / 4; ++i) {
                                int offset = i * 4;
                                long stamp = this.getLongParse(slice, offset, 4);
                                long record = DateUtil.restoreZoneUTC(stamp);
                                this.mHistoryOfRecords.add(record);
                                LogUtil.d("mHistoryOfRecords index:%d record:%s", i, stamp);
                            }
                        }
                        this.onHistoryOfHRRecordReceived(device, this.mHistoryOfRecords);
                        this.mHistoryOfRecords.clear();
                        this.mPackages.clear();
                    }
                    break block127;
                }
                if (mode == 34 || mode == 35) {
                    if (this.mHistoryOfHeartRates == null) {
                        this.mHistoryOfHeartRates = new ArrayList<HistoryOfHeartRate>();
                    }
                    if (mode == 34) {
                        if (!this.isStamp) {
                            this.mStamp = this.getLongParse(value, 3, 4);
                            this.isStamp = true;
                        }
                        this.mPackages.add(data);
                    }
                    if (mode == 35) {
                        for (int index = 0; index < this.mPackages.size(); ++index) {
                            byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                            LogUtil.d("mHistoryOfHeartRates index:%d values:%s", index, ParserUtils.parse(slice));
                            for (int i = 4; i < slice.length; ++i) {
                                int heart = this.getIntParse(slice, i, 1);
                                long stamp = DateUtil.restoreZoneUTC(this.mStamp);
                                HistoryOfHeartRate heartRate = new HistoryOfHeartRate(stamp, heart);
                                this.mHistoryOfHeartRates.add(heartRate);
                                ++this.mStamp;
                            }
                        }
                        this.onHistoryOfHRDataReceived(device, this.mHistoryOfHeartRates);
                        this.mHistoryOfHeartRates.clear();
                        this.mPackages.clear();
                        this.isStamp = false;
                        this.mStamp = 0L;
                    }
                    break block127;
                }
                if (mode == 64 || mode == 65) {
                    if (this.mIntervalSteps == null) {
                        this.mIntervalSteps = new ArrayList<IntervalStep>();
                    }
                    if (mode == 64) {
                        this.mPackages.add(data);
                    }
                    if (mode == 65) {
                        for (int index = 0; index < this.mPackages.size(); ++index) {
                            byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                            LogUtil.d("mIntervalSteps index:%d values:%s", index, ParserUtils.parse(slice));
                            for (int i = 0; i < slice.length / 8; ++i) {
                                int offset = i * 8;
                                long stamp = DateUtil.restoreZoneUTC(this.getLongParse(slice, offset, 4));
                                int step = this.getIntParse(slice, offset + 4, 4);
                                IntervalStep intervalStep = new IntervalStep(stamp, step);
                                this.mIntervalSteps.add(intervalStep);
                            }
                        }
                        this.onIntervalStepReceived(device, this.mIntervalSteps);
                        this.mIntervalSteps.clear();
                        this.mPackages.clear();
                    }
                    break block127;
                }
                if (mode == 66 || mode == 67) {
                    if (this.mSingleTapRecords == null) {
                        this.mSingleTapRecords = new ArrayList<Long>();
                    }
                    if (mode == 66) {
                        this.mPackages.add(data);
                    }
                    if (mode == 67) {
                        for (int index = 0; index < this.mPackages.size(); ++index) {
                            byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                            LogUtil.d("mSingleTapRecords index:%d values:%s", index, ParserUtils.parse(slice));
                            for (int i = 0; i < slice.length / 4; ++i) {
                                int offset = i * 4;
                                long stamp = this.getLongParse(slice, offset, 4);
                                long record = DateUtil.restoreZoneUTC(stamp);
                                this.mSingleTapRecords.add(record);
                            }
                        }
                        this.onSingleTapRecordReceived(device, this.mSingleTapRecords);
                        this.mSingleTapRecords.clear();
                        this.mPackages.clear();
                    }
                    break block127;
                }
                if (mode == 60) {
                    int cmd;
                    if (this.mHeartRateAllDays == null) {
                        this.mHeartRateAllDays = new ArrayList<HeartRateAllDay>();
                    }
                    if ((cmd = this.getIntParse(value, 3, 1)) == 1) {
                        for (int j = 4; j < value.length; ++j) {
                            long utc = this.getIntParse(value, j, 4);
                            utc *= 1000L;
                            utc -= 28800000L;
                            int len = value[j += 4];
                            ++j;
                            ArrayList<Integer> hearts = new ArrayList<Integer>();
                            for (int i = 0; i < len; ++i) {
                                int heart = this.getIntParse(value, i + j, 1);
                                hearts.add(heart);
                            }
                            HeartRateAllDay heartRateAllDay = new HeartRateAllDay(utc, hearts);
                            this.mHeartRateAllDays.add(heartRateAllDay);
                            if ((j += len - 1) != value.length - 2) {
                                continue;
                            }
                            break block127;
                        }
                        break block127;
                    }
                    this.onHeartRateThroughoutTheDayCallbackReceived(device, this.mHeartRateAllDays);
                    this.mHeartRateAllDays.clear();
                    break block127;
                }
                if (mode == 59) {
                    int cmd = this.getIntParse(value, 3, 1);
                    if (this.mHistorySportsCallback == null) {
                        this.mHistorySportsCallback = new ArrayList<HistorySports>();
                    }
                    if (cmd == 1) {
                        byte[] slice = HexUtil.subByte(value, 4, value.length - 1);
                        int index = 0;
                        int len = slice.length / 17;
                        for (int i = 0; i < len; ++i) {
                            long utc = this.getIntParse(slice, index, 4);
                            utc *= 1000L;
                            utc -= 28800000L;
                            int sportMode = this.getIntParse(slice, index += 4, 1);
                            long exerciseTime = this.getIntParse(slice, ++index, 4);
                            long step = this.getIntParse(slice, index += 4, 4);
                            int calorie = this.getIntParse(slice, index += 4, 4);
                            index += 4;
                            HistorySports historySports = new HistorySports(utc, sportMode, exerciseTime, step, (float)calorie / 10.0f);
                            this.mHistorySportsCallback.add(historySports);
                        }
                        this.onHistorySportsReceived(device, this.mHistorySportsCallback);
                        this.mHistorySportsCallback.clear();
                    }
                } else if (mode == 57) {
                    int cmd;
                    if (this.mBloodOxygenHistory == null) {
                        this.mBloodOxygenHistory = new ArrayList<BloodOxygenHistory>();
                    }
                    if ((cmd = this.getIntParse(value, 3, 1)) == 1) {
                        byte[] slice = HexUtil.subByte(value, 4, value.length - 1);
                        for (int i = 0; i < slice.length / 8; ++i) {
                            int offset = i * 8;
                            long utc = this.getIntParse(slice, offset, 4);
                            utc *= 1000L;
                            int mValue = this.getIntParse(slice, offset + 4, 1);
                            int gesture = this.getIntParse(slice, offset + 5, 1);
                            int piValue = this.getIntParse(slice, offset + 6, 1);
                            int onWrist = this.getIntParse(slice, offset + 7, 1);
                            BloodOxygenHistory bloodOxygenHistory = new BloodOxygenHistory(utc -= 28800000L, String.valueOf(mValue), gesture, piValue, onWrist);
                            this.mBloodOxygenHistory.add(bloodOxygenHistory);
                        }
                        this.onHistoryBloodOxygenReceived(device, this.mBloodOxygenHistory);
                        this.mBloodOxygenHistory.clear();
                    }
                } else if (mode == 58) {
                    int cmd;
                    if (this.mTemperatureHistory == null) {
                        this.mTemperatureHistory = new ArrayList<BodyTemperatureHistory>();
                    }
                    if ((cmd = this.getIntParse(value, 3, 1)) == 1) {
                        int len = value.length - 1;
                        int i = 4;
                        while (i < len) {
                            long utc = this.getIntParse(value, i, 4);
                            utc *= 1000L;
                            utc -= 28800000L;
                            int tempLen = this.getIntParse(value, i += 4, 1);
                            ++i;
                            double[] temps = new double[tempLen];
                            for (int i1 = 0; i1 < tempLen; ++i1) {
                                double temp;
                                temps[i1] = temp = (double)this.getIntParse(value, i, 2) / 10.0;
                                i += 2;
                            }
                            BodyTemperatureHistory bodyTemperatureHistory = new BodyTemperatureHistory(utc, temps);
                            this.mTemperatureHistory.add(bodyTemperatureHistory);
                        }
                    }
                    this.onBodyBodyTemperatureHistoryReceived(device, this.mTemperatureHistory);
                    this.mTemperatureHistory.clear();
                } else if (mode == 10) {
                    boolean state = this.getIntParse(value, 3, 1) == 1;
                    this.onWeatherStatusReceived(device, state);
                } else if (mode == 11) {
                    boolean state = this.getIntParse(value, 3, 1) == 1;
                    this.onVibrationIntensityReceived(device, state);
                } else if (mode == 13) {
                    boolean state = this.getIntParse(value, 3, 1) == 1;
                    this.onSportModeReceived(device, state);
                } else if (mode == 14) {
                    boolean state = this.getIntParse(value, 3, 1) == 1;
                    this.onSpecificFunctionReceived(device, state);
                } else if (mode == 55) {
                    if (value[1] <= 6) {
                        return;
                    }
                    int mSwitch = this.getIntParse(value, 3, 1);
                    if (value[1] <= 8) {
                        return;
                    }
                    int blValue = this.getIntParse(value, 4, 1);
                    int gesture = this.getIntParse(value, 5, 1);
                    int piValue = this.getIntParse(value, 6, 1);
                    int onwrist = this.getIntParse(value, 7, 1);
                    this.onBloodOxygenReceived(device, mSwitch, String.valueOf(blValue), gesture, piValue, onwrist);
                } else if (mode == 56) {
                    float environment = (float)this.getIntParse(value, 3, 2) / 10.0f;
                    float wrist = (float)this.getIntParse(value, 5, 2) / 10.0f;
                    float body = (float)this.getIntParse(value, 7, 2) / 10.0f;
                    this.onTemperatureReceived(device, environment, wrist, body);
                } else if (mode == 103) {
                    int jumpRopeSwitch = this.getIntParse(value, 3, 1);
                    long todaySkipCount = this.getIntParse(value, 4, 2);
                    long currentSkipCount = this.getIntParse(value, 6, 2);
                    float currentSkipCalories = (float)this.getIntParse(value, 8, 3) / 10.0f;
                    long totalSkipTime = this.getIntParse(value, 11, 4);
                    long currentSkipTime = this.getIntParse(value, 15, 3);
                    this.onSkippingRopeDataReceived(device, jumpRopeSwitch, todaySkipCount, currentSkipCount, currentSkipCalories, totalSkipTime, currentSkipTime);
                } else if (mode == 68) {
                    byte[] dataByte = new byte[value.length - 4];
                    System.arraycopy(value, 4, dataByte, 0, value.length - 4);
                    int index = dataByte.length / 16;
                    int subscript = 0;
                    if (this.mSkippingRopes == null) {
                        this.mSkippingRopes = new ArrayList<HistorySkippingRope>();
                    }
                    for (int i = 0; i < index; ++i) {
                        long utc = this.getIntParse(dataByte, subscript, 4);
                        utc *= 1000L;
                        utc -= 28800000L;
                        long count = this.getIntParse(dataByte, subscript += 4, 2);
                        long calorie = this.getIntParse(dataByte, subscript += 2, 2);
                        long minute = this.getIntParse(dataByte, subscript += 2, 1);
                        long seconds = this.getIntParse(dataByte, ++subscript, 1);
                        long max_speed = this.getIntParse(dataByte, ++subscript, 2);
                        long utc1 = this.getIntParse(dataByte, subscript += 2, 4);
                        utc1 *= 1000L;
                        subscript += 4;
                        HistorySkippingRope historySkippingRope = new HistorySkippingRope(utc, count, (float)calorie / 10.0f, minute, seconds, max_speed, utc1 -= 28800000L);
                        this.mSkippingRopes.add(historySkippingRope);
                    }
                    this.onHistorySkippingRopeReceived(device, this.mSkippingRopes);
                    this.mSkippingRopes.clear();
                } else if (mode == 96) {
                    int sequence = this.getIntParse(value, 3, 1);
                    for (int i = 0; i < data.size() / 12; ++i) {
                        int offset = i * 12;
                        int gyroscopeX = data.getIntValue(34, offset + 4);
                        int gyroscopeY = data.getIntValue(34, offset + 6);
                        int gyroscopeZ = data.getIntValue(34, offset + 8);
                        int accelerometerX = data.getIntValue(34, offset + 10);
                        int accelerometerY = data.getIntValue(34, offset + 12);
                        int accelerometerZ = data.getIntValue(34, offset + 14);
                        this.onSensorRawDataReceived(device, sequence, gyroscopeX, gyroscopeY, gyroscopeZ, accelerometerX, accelerometerY, accelerometerZ);
                    }
                } else if (mode == 97) {
                    int sequence = this.getIntParse(value, 3, 1);
                    int len = value.length - 5;
                    byte[] slice = new byte[len];
                    System.arraycopy(value, 4, slice, 0, len);
                    for (int i = 0; i < len / 8; ++i) {
                        int offset = i * 8;
                        int ppg = this.getSignedIntParse(slice, offset);
                        int x = this.getSignedIntParse(slice, offset + 2);
                        int y = this.getSignedIntParse(slice, offset + 4);
                        int z = this.getSignedIntParse(slice, offset + 6);
                        this.on3DRawDataReceived(device, sequence, ppg, x, y, z);
                    }
                } else if (mode == 116) {
                    long type2 = this.getLongParse(value, 3, 2);
                    if (type2 == 12L) {
                        int state = this.getIntParse(value, 5, 1);
                        this.onSportModeExitStatusReceived(device, state);
                    }
                } else if (mode == 117) {
                    long type3 = this.getLongParse(value, 3, 2);
                    if (type3 == 6L) {
                        int max = this.getIntParse(value, 5, 1);
                        this.onHeartRateMaxReceived(device, max);
                    } else if (type3 == 11L) {
                        int emotion = this.getIntParse(value, 5, 1);
                        int fatigue = this.getIntParse(value, 6, 1);
                        int pressure = this.getIntParse(value, 7, 1);
                        this.onPhysicalConditionReceived(device, emotion, fatigue, pressure);
                    } else if (type3 == 13L) {
                        byte[] bytes = HexUtil.subByteByLength(value, 5, 6);
                        String address = HexUtil.getAddress(HexUtil.reverse(bytes));
                        this.onMACAddressReceived(device, address);
                    } else if (type3 == 32L) {
                        long utcTag;
                        if (this.mHistoryOfDetailRecords == null) {
                            this.mHistoryOfDetailRecords = new ArrayList<HistoryOfHeartRateDetailRecord>();
                        }
                        if ((utcTag = this.getLongParse(value, 5, 4)) != 0xFFFFFFFFL) {
                            this.mPackages.add(data);
                        } else {
                            for (int index = 0; index < this.mPackages.size(); ++index) {
                                byte[] slice = this.subSlice(5, this.mPackages.get(index).getValue());
                                LogUtil.d("mHistoryOfRecords index:%d values:%s", index, ParserUtils.parse(slice));
                                for (int i = 0; i < slice.length / 5; ++i) {
                                    int offset = i * 5;
                                    long stamp = this.getLongParse(slice, offset, 4);
                                    long restoreTime = DateUtil.restoreZoneUTC(stamp);
                                    int active = this.getIntParse(slice, offset + 4, 1);
                                    HistoryOfHeartRateDetailRecord record = new HistoryOfHeartRateDetailRecord(active, restoreTime);
                                    this.mHistoryOfDetailRecords.add(record);
                                    LogUtil.d("mHistoryOfRecords index:%d record:%s", i, stamp);
                                }
                            }
                            this.onHistoryOfHRDetailRecordReceived(device, this.mHistoryOfDetailRecords);
                            this.mHistoryOfDetailRecords.clear();
                            this.mPackages.clear();
                        }
                    } else if (type3 == 33L) {
                        if (this.mHistoryOfDetailHeartRates == null) {
                            this.mHistoryOfDetailHeartRates = new ArrayList<HistoryOfHeartRateDetail>();
                        }
                        long utcTag = this.getLongParse(value, 5, 4);
                        if (!this.isStamp) {
                            this.mStamp = utcTag;
                            this.isStamp = true;
                        }
                        this.mPackages.add(data);
                        if (utcTag == 0xFFFFFFFFL) {
                            for (int index = 0; index < this.mPackages.size(); ++index) {
                                byte[] slice = this.subSlice(9, this.mPackages.get(index).getValue());
                                for (int i = 0; i < slice.length / 8; ++i) {
                                    int offset = i * 8;
                                    long stamp = DateUtil.restoreZoneUTC(this.mStamp);
                                    int heart = this.getIntParse(slice, offset, 1);
                                    int calorie = this.getIntParse(slice, offset + 1, 3);
                                    boolean wear = this.getIntParse(slice, offset + 4, 1) == 1;
                                    int strength = this.getIntParse(slice, offset + 5, 1);
                                    int sport = this.getIntParse(slice, offset + 6, 1);
                                    int breathRate = this.getIntParse(slice, offset + 7, 1);
                                    HistoryOfHeartRateDetail heartRate = new HistoryOfHeartRateDetail(stamp, heart, (float)calorie / 10.0f, wear, strength, sport, breathRate);
                                    this.mHistoryOfDetailHeartRates.add(heartRate);
                                    ++this.mStamp;
                                }
                            }
                            this.onHistoryOfHRDetailDataReceived(device, this.mHistoryOfDetailHeartRates);
                            this.mHistoryOfDetailHeartRates.clear();
                            this.mPackages.clear();
                            this.isStamp = false;
                            this.mStamp = 0L;
                        }
                    }
                } else if (mode == 16) {
                    int state = this.getIntParse(value, 3, 1);
                    this.onBindDeviceReceived(device, state);
                } else if (mode == 145) {
                    long utcTag = this.getLongParse(value, 3, 4);
                    if (utcTag != 0xFFFFFFFFL) {
                        if (!this.isStart) {
                            this.mSequence = 0;
                            this.isStart = true;
                            this.onHistoryOfHealthDataStart();
                        }
                        byte[] slice = this.subSlice(3, value);
                        for (int i = 0; i < slice.length / 18; ++i) {
                            int offset = i * 18;
                            long start = this.getLongParse(slice, offset, 4);
                            long stamp = this.getLongParse(slice, offset + 4, 4);
                            long record = DateUtil.restoreZoneUTC(stamp);
                            int type4 = this.getIntParse(slice, offset + 8, 1);
                            int stressLevel = this.getIntParse(slice, offset + 9, 1);
                            int breathRate = this.getIntParse(slice, offset + 10, 1);
                            int vo2max = this.getIntParse(slice, offset + 11, 1);
                            int emotionLevel = this.getIntParse(slice, offset + 12, 1);
                            int stamina = this.getIntParse(slice, offset + 13, 1);
                            int heartRate = this.getIntParse(slice, offset + 14, 1);
                            int bloodOxygen = this.getIntParse(slice, offset + 15, 1);
                            float temperature = (float)this.getIntParse(slice, offset + 16, 2) / 10.0f;
                            ++this.mSequence;
                            this.onHistoryOfHealthDataReceived(device, this.mSequence, new HistoryOfHealth(start, record, type4, stressLevel, breathRate, vo2max, emotionLevel, stamina, heartRate, bloodOxygen, temperature));
                        }
                    } else {
                        this.onHistoryOfHealthDataComplete();
                    }
                } else if (mode == 146) {
                    int current = this.getIntParse(value, 3, 1);
                    int state = this.getIntParse(value, 4, 1);
                    this.onMeasureModeStateReceived(device, current, state);
                } else if (mode == 149) {
                    long userId = this.getLongParse(value, 3, 3);
                    int length = this.getIntParse(value, 6, 1);
                    byte[] bytes = HexUtil.subByteByLength(value, 7, length);
                    this.onUserIdNameReceived(device, userId, HexUtil.decodingUTF8(bytes));
                } else if (mode == 150 && (type = this.getIntParse(value, 3, 1)) == 3) {
                    int respiratoryRate = this.getIntParse(value, 4, 1);
                    this.onRespiratoryRateReceived(device, respiratoryRate);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearType(int type) {
        switch (type) {
            case 2: {
                if (this.mHistorySevenDaysOfSports == null) break;
                this.mHistorySevenDaysOfSports.clear();
                break;
            }
            case 4: {
                if (this.mHistoryOfRecords == null) break;
                this.mHistoryOfRecords.clear();
                break;
            }
            case 6: {
                if (this.mHistoryOfHeartRates == null) break;
                this.mHistoryOfHeartRates.clear();
                break;
            }
            case 8: {
                if (this.mIntervalSteps == null) break;
                this.mIntervalSteps.clear();
                break;
            }
            case 16: {
                if (this.mSingleTapRecords == null) break;
                this.mSingleTapRecords.clear();
                break;
            }
            case 18: {
                if (this.mHistorySleeps == null) break;
                this.mHistorySleeps.clear();
                break;
            }
            case 20: {
                if (this.mTemperatureHistory == null) break;
                this.mTemperatureHistory.clear();
                break;
            }
            case 22: {
                if (this.mBloodOxygenHistory == null) break;
                this.mBloodOxygenHistory.clear();
                break;
            }
            case 24: {
                this.mSequence = 0;
                this.isStart = false;
                break;
            }
            case 32: {
                if (this.mHistoryOfDetailRecords == null) break;
                this.mHistoryOfDetailRecords.clear();
                break;
            }
            case 34: {
                if (this.mHistoryOfDetailHeartRates == null) break;
                this.mHistoryOfDetailHeartRates.clear();
                break;
            }
        }
        this.mPackages.clear();
        this.isStamp = false;
        this.mStamp = 0L;
    }

    private void parseSportHistory(byte[] value) {
        for (int i = 0; i < value.length / 14; ++i) {
            int offset = i * 14;
            long stamp = this.getLongParse(value, offset, 4);
            long step = this.getLongParse(value, offset + 4, 3);
            long calorie = this.getLongParse(value, offset + 7, 3);
            long duration = this.getLongParse(value, offset + 10, 3);
            int stand = this.getIntParse(value, offset + 13, 1);
            stamp = DateUtil.restoreZoneUTC(stamp);
            this.mHistorySevenDaysOfSports.add(new HistorySevenDaysOfSports(stamp, step, (float)calorie / 10.0f, duration, stand));
        }
    }

    private synchronized byte[] subSlice(int start, byte[] value) {
        return HexUtil.subByte(value, start, value.length - 1);
    }

    private long getLongParse(byte[] bytes, int pos, int len) {
        long val = 0L;
        len += pos;
        for (int i = pos; i < len; ++i) {
            val <<= 8;
            val |= (long)bytes[i] & 0xFFL;
        }
        return val;
    }

    private int getIntParse(byte[] bytes, int pos, int len) {
        int val = 0;
        len += pos;
        for (int i = pos; i < len; ++i) {
            val <<= 8;
            val |= bytes[i] & 0xFF;
        }
        return val;
    }

    private int getSignedIntParse(byte[] bytes, int pos) {
        if (bytes[pos] > 0) {
            return this.getIntParse(bytes, pos, 2);
        }
        return bytes[pos] << 8 | bytes[pos + 1] & 0xFF;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataType {
    }
}

