/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.external;

import android.content.Context;
import android.content.SharedPreferences;
import com.android.chileaf.WearManager;
import com.android.chileaf.external.NotificationSpec;
import com.android.chileaf.external.PhoneCallSpec;
import com.google.gson.Gson;
import java.lang.reflect.Type;

public class SpecManager {
    private static final String SPEC_PREFS = "spec_prefs";
    private Gson mGson;
    private Context mContext;
    private WearManager mManager;
    private SharedPreferences mPreferences;

    private SpecManager() {
    }

    public static SpecManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setWearManager(WearManager manager) {
        this.mManager = manager;
    }

    private SharedPreferences getPreferences() {
        if (this.mPreferences == null) {
            this.mPreferences = this.mContext.getSharedPreferences(SPEC_PREFS, 0);
        }
        return this.mPreferences;
    }

    private void putString(String key, String value) {
        this.getPreferences().edit().putString(key, value).apply();
    }

    private String getString(String key, String value) {
        return this.getPreferences().getString(key, value);
    }

    private void toJson(String key, Object value) {
        String json = this.getGson().toJson(value);
        this.putString(key, json);
    }

    private <T> T fromJson(String key, Class<T> clazz) {
        return (T)this.getGson().fromJson(this.getString(key, null), clazz);
    }

    private <T> T fromJson(String key, Type type) {
        return (T)this.getGson().fromJson(this.getString(key, null), type);
    }

    private Gson getGson() {
        if (this.mGson == null) {
            this.mGson = new Gson();
        }
        return this.mGson;
    }

    public void onCallNotification(PhoneCallSpec call) {
        if (this.mManager != null) {
            this.mManager.setCallConfig(call);
        }
    }

    public void onMessageNotification(NotificationSpec notification) {
        if (this.mManager != null) {
            this.mManager.setNotificationConfig(notification);
        }
    }

    private static class SingletonHolder {
        private static final SpecManager INSTANCE = new SpecManager();

        private SingletonHolder() {
        }
    }
}

