/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.external;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.SmsMessage;
import com.android.chileaf.external.NotificationSpec;
import com.android.chileaf.external.NotificationType;
import com.android.chileaf.external.SpecManager;
import java.util.LinkedHashMap;
import java.util.Map;

public class SMSReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        Object[] pdus;
        NotificationSpec notificationSpec = new NotificationSpec();
        notificationSpec.type = NotificationType.SMS;
        notificationSpec.stamp = System.currentTimeMillis();
        Bundle bundle = intent.getExtras();
        if (bundle != null && (pdus = (Object[])bundle.get("pdus")) != null) {
            int pduSize = pdus.length;
            LinkedHashMap<String, StringBuilder> messageMap = new LinkedHashMap<String, StringBuilder>();
            SmsMessage[] messages = new SmsMessage[pduSize];
            for (int i = 0; i < pduSize; ++i) {
                messages[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
                String originatingAddress = messages[i].getOriginatingAddress();
                if (!messageMap.containsKey(originatingAddress)) {
                    messageMap.put(originatingAddress, new StringBuilder());
                }
                ((StringBuilder)messageMap.get(originatingAddress)).append(messages[i].getMessageBody());
            }
            for (Map.Entry entry : messageMap.entrySet()) {
                String originatingAddress = (String)entry.getKey();
                if (originatingAddress == null) continue;
                notificationSpec.title = originatingAddress;
                notificationSpec.content = ((StringBuilder)entry.getValue()).toString();
                SpecManager.getInstance().onMessageNotification(notificationSpec);
            }
        }
    }
}

