/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.external;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import com.android.chileaf.external.NotificationSpec;
import com.android.chileaf.external.NotificationType;
import com.android.chileaf.external.PhoneCallSpec;
import com.android.chileaf.external.SpecManager;

public class PhoneCallReceiver
extends BroadcastReceiver {
    private String mSavedNumber;
    private int mLastState = 0;

    public void onReceive(Context context, Intent intent) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        Bundle extras = intent.getExtras();
        if (extras != null) {
            String action = intent.getAction();
            if (action != null && action.equals("android.intent.action.NEW_OUTGOING_CALL")) {
                this.mSavedNumber = extras.getString("android.intent.extra.PHONE_NUMBER");
            } else if (intent.hasExtra("incoming_number")) {
                String number = extras.getString("incoming_number");
                int state = tm.getCallState();
                this.onCallStateChanged(state, number);
            }
        }
    }

    public void onCallStateChanged(int state, String number) {
        if (this.mLastState == state) {
            return;
        }
        int callCommand = -1;
        if (state == 2) {
            if (this.mLastState != 1) {
                NotificationSpec notificationSpec = new NotificationSpec();
                notificationSpec.content = number;
                notificationSpec.type = NotificationType.MISSEDCALL;
                notificationSpec.title = NotificationType.MISSEDCALL.title;
                notificationSpec.stamp = System.currentTimeMillis();
                SpecManager.getInstance().onMessageNotification(notificationSpec);
                this.mSavedNumber = number;
            }
        } else {
            if (state == 1) {
                callCommand = 1;
                this.mSavedNumber = number;
            } else if (state == 0) {
                callCommand = 0;
            }
            if (callCommand != -1) {
                PhoneCallSpec phoneCallSpec = new PhoneCallSpec();
                phoneCallSpec.number = this.mSavedNumber;
                phoneCallSpec.command = callCommand;
                SpecManager.getInstance().onCallNotification(phoneCallSpec);
            }
        }
        this.mLastState = state;
    }
}

