/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.external;

import android.app.Notification;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.android.chileaf.external.AppNotificationType;
import com.android.chileaf.external.NotificationSpec;
import com.android.chileaf.external.NotificationType;
import com.android.chileaf.external.PhoneCallReceiver;
import com.android.chileaf.external.PhoneCallSpec;
import com.android.chileaf.external.SMSReceiver;
import com.android.chileaf.external.SpecManager;
import com.android.chileaf.util.LogUtil;
import java.util.HashMap;
import java.util.List;

public class NotificationListener
extends NotificationListenerService {
    private long activeCallPostTime;
    private final HashMap<String, Long> notificationBurstPrevention = new HashMap();
    private final HashMap<String, Long> notificationOldRepeatPrevention = new HashMap();
    private PhoneCallReceiver mPhoneCallReceiver = null;
    private SMSReceiver mSMSReceiver = null;

    public void onCreate() {
        IntentFilter filter;
        super.onCreate();
        if (this.mPhoneCallReceiver == null) {
            this.mPhoneCallReceiver = new PhoneCallReceiver();
            filter = new IntentFilter();
            filter.addAction("android.intent.action.PHONE_STATE");
            filter.addAction("android.intent.action.NEW_OUTGOING_CALL");
            this.registerReceiver(this.mPhoneCallReceiver, filter);
        }
        if (this.mSMSReceiver == null) {
            this.mSMSReceiver = new SMSReceiver();
            filter = new IntentFilter();
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            this.registerReceiver(this.mSMSReceiver, filter);
        }
    }

    public void onNotificationPosted(StatusBarNotification sbn) {
        this.onNotificationPosted(sbn, null);
    }

    public void onNotificationPosted(StatusBarNotification sbn, NotificationListenerService.RankingMap rankingMap) {
        Long prevention;
        Log.e((String)"onNotificationPosted", (String)sbn.toString());
        if (Build.VERSION.SDK_INT >= 21 && "call".equals(sbn.getNotification().category) && sbn.isOngoing()) {
            this.handleCallNotification(sbn);
            return;
        }
        String source = sbn.getPackageName().toLowerCase();
        Notification notification = sbn.getNotification();
        if (this.notificationOldRepeatPrevention.containsKey(source) && (prevention = this.notificationOldRepeatPrevention.get(source)) != null && notification.when <= prevention) {
            return;
        }
        long current = System.currentTimeMillis();
        NotificationSpec notificationSpec = new NotificationSpec();
        notificationSpec.stamp = current;
        notificationSpec.sourceAppId = source;
        Log.d((String)"", (String)("onNotificationPosted: " + source));
        notificationSpec.type = (NotificationType)((Object)AppNotificationType.getInstance().get(source));
        if (notificationSpec.type == null) {
            notificationSpec.type = NotificationType.OTHER;
        }
        this.dissectNotificationTo(notification, notificationSpec);
        NotificationCompat.WearableExtender wearableExtender = new NotificationCompat.WearableExtender(notification);
        List actions = wearableExtender.getActions();
        if (actions.isEmpty() && NotificationCompat.isGroupSummary((Notification)notification)) {
            return;
        }
        this.notificationBurstPrevention.put(source, current);
        if (0L != notification.when) {
            this.notificationOldRepeatPrevention.put(source, notification.when);
        }
        SpecManager.getInstance().onMessageNotification(notificationSpec);
    }

    private void handleCallNotification(StatusBarNotification sbn) {
        String app = sbn.getPackageName();
        Notification notify = sbn.getNotification();
        if (Build.VERSION.SDK_INT >= 21) {
            String appName;
            this.dumpExtras(notify.extras);
            String number = notify.extras.containsKey("android.people") ? notify.extras.getString("android.people") : (notify.extras.containsKey("android.title") ? notify.extras.getString("android.title") : ((appName = this.getAppName(app)) != null ? appName : app));
            this.activeCallPostTime = sbn.getPostTime();
            PhoneCallSpec phoneCallSpec = new PhoneCallSpec();
            phoneCallSpec.number = number;
            phoneCallSpec.command = 1;
            SpecManager.getInstance().onCallNotification(phoneCallSpec);
        }
    }

    private String getAppName(String pkg) {
        PackageManager pm = this.getPackageManager();
        try {
            return (String)pm.getApplicationLabel(pm.getApplicationInfo(pkg, 0));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String sanitizeUnicode(String orig) {
        return orig.replaceAll("\\p{C}", "");
    }

    private void dissectNotificationTo(Notification notification, NotificationSpec notificationSpec) {
        Bundle extras = NotificationCompat.getExtras((Notification)notification);
        if (extras == null) {
            return;
        }
        this.dumpExtras(extras);
        CharSequence title = extras.getCharSequence("android.title");
        if (title != null) {
            notificationSpec.title = this.sanitizeUnicode(title.toString());
        }
        CharSequence contentCS = null;
        if (extras.containsKey("android.bigText")) {
            contentCS = extras.getCharSequence("android.bigText");
        } else if (extras.containsKey("android.text")) {
            contentCS = extras.getCharSequence("android.text");
        }
        if (contentCS != null) {
            notificationSpec.content = this.sanitizeUnicode(contentCS.toString());
        }
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
        LogUtil.i("Notification removed: %s", sbn.getPackageName());
        if (Build.VERSION.SDK_INT >= 21 && "call".equals(sbn.getNotification().category) && this.activeCallPostTime == sbn.getPostTime()) {
            this.activeCallPostTime = 0L;
            PhoneCallSpec phoneCallSpec = new PhoneCallSpec();
            phoneCallSpec.name = "";
            phoneCallSpec.command = 0;
            SpecManager.getInstance().onCallNotification(phoneCallSpec);
        }
    }

    private void dumpExtras(Bundle bundle) {
        for (String key : bundle.keySet()) {
            Object value = bundle.get(key);
            if (value == null) continue;
            Log.d((String)"dumpExtras", (String)String.format("Notification extra: %s %s (%s)", key, value.toString(), value.getClass().getName()));
        }
    }

    public void onDestroy() {
        if (this.mPhoneCallReceiver != null) {
            this.unregisterReceiver(this.mPhoneCallReceiver);
            this.mPhoneCallReceiver = null;
        }
        if (this.mSMSReceiver != null) {
            this.unregisterReceiver(this.mSMSReceiver);
            this.mSMSReceiver = null;
        }
        super.onDestroy();
    }
}

